/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROctetString_;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.exception.AlgorithmNotFoundException;
import xjyb.org.bjca.jce.exception.CertificateNotMatchException;
import xjyb.org.bjca.jce.exception.DecryptDataException;
import xjyb.org.bjca.jce.exception.DecryptKeyException;
import xjyb.org.bjca.jce.exception.EncryptAlgException;
import xjyb.org.bjca.jce.exception.EncryptDataException;
import xjyb.org.bjca.jce.exception.EncryptKeyException;
import xjyb.org.bjca.jce.exception.WriteEnvDataException;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.EncryptedContentInfo;
import xjyb.org.bjca.jce.fastparser.EnvelopedData;
import xjyb.org.bjca.jce.fastparser.FastPkcs7;
import xjyb.org.bjca.jce.fastparser.IssuerAndSerialNumber;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.RecipientInfo;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.util.encoders.Base64;

public class PKCS7EnvelopedData
implements PKCSObjectIdentifiers {
    public static SecretKey key;
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    static final int MD5 = 1;
    static final int MD2 = 2;
    static final int SHA1 = 3;
    static final int RSA = 4;
    static final int DSA = 5;
    static final int SHA224 = 6;
    static final int SHA256 = 7;
    static final int SHA384 = 8;
    static final int SHA512 = 9;
    static final int RC4 = 10;
    static final int DES = 11;
    static final int DESEDE = 12;
    static final int RC2 = 13;
    static final int AES = 14;
    public static final int IV_LENGTH = 8;
    private static final String OID_ENVELOPEDDATATYPE = "1.2.840.113549.1.7.3";
    private static final String OID_ENCRYPTCONTENT = "1.2.840.113549.1.7.1";
    private static final String OID_RSA_ECB_PKCS1PADDING = "1.2.840.113549.1.1.1";
    static final String ID_MD5 = "1.2.840.113549.2.5";
    static final String ID_MD2 = "1.2.840.113549.2.2";
    static final String ID_SHA1 = "1.3.14.3.2.26";
    static final String ID_RSA = "1.2.840.113549.1.1.1";
    static final String ID_DSA = "1.2.840.10040.4.1";
    static final String ID_SHA224 = "2.16.840.1.101.3.4.2.4";
    static final String ID_SHA256 = "2.16.840.1.101.3.4.2.1";
    static final String ID_SHA384 = "2.16.840.1.101.3.4.2.2";
    static final String ID_SHA512 = "2.16.840.1.101.3.4.2.3";
    static final String ID_RC4 = "1.2.840.113549.3.4";
    static final String ID_DES = "1.3.14.3.2.7";
    static final String ID_DESEDE = "1.2.840.113549.3.7";
    static final String ID_RC2 = "1.2.840.113549.3.2";
    static final String ID_AES = "2.16.840.1.101.3.4.2";
    static String[] algArray;
    static String[] algArray2;
    static HashMap algmap;
    byte[] bsPKCS7 = null;
    FastPkcs7 fxPKCS7 = new FastPkcs7();

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, PrivateKey prik, String provider) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, IOException {
        byte[] out;
        block22: {
            if (!this.fxPKCS7.pkcs7Data(envelopeddata)) {
                throw new SecurityException("can't decode PKCS7EnvlopedData object");
            }
            EnvelopedData ed = this.fxPKCS7.getEnvelopedData();
            if (ed == null) {
                throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
            }
            ArrayList riList = ed.getVRecipientInfo();
            RecipientInfo ri = (RecipientInfo)riList.get(0);
            Item item = ri.getIssuerAndSerialNumber();
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(envelopeddata, item);
            item = iasn.getIssuer();
            byte[] bs = new byte[item.length];
            bs = DerUtil.getItemDataAndTag(envelopeddata, item);
            ASN1InputStream in = new ASN1InputStream(bs);
            String issuer = "";
            try {
                DERObject obj = in.readObject();
                ASN1Sequence seq = ASN1Sequence.getInstance(obj);
                X509Name name = new X509Name(seq);
                issuer = name.toString();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String sn = iasn.getSerialNumber().getSerialNumber().toString(10);
            String certIssuer = ((Object)((X509Certificate)cert).getIssuerDN()).toString();
            String certSN = ((X509Certificate)cert).getSerialNumber().toString(10);
            if (!certSN.equals(sn)) {
                throw new CertificateNotMatchException("Certificate is not match");
            }
            byte[] encKey = ri.getEncKey();
            EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
            item = eci.getContentEncryptionAlgorithm();
            bs = new byte[item.length];
            System.arraycopy(envelopeddata, item.offset, bs, 0, bs.length);
            in = new ASN1InputStream(bs);
            String algName = "";
            try {
                AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance(in.readObject());
                String algoid = alg.getObjectId().getId();
                algName = PKCS7EnvelopedData.getAlgorithmNameByOid(algoid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            item = eci.getIvParameter();
            bs = DerUtil.getItemDataAndTag(envelopeddata, item);
            IvParameterSpec param = null;
            if (bs.length != 0 && bs.length > 2 && (bs[0] != 5 || bs[1] != 0)) {
                byte[] tmp = new byte[8];
                if (bs[0] == 48 && bs[1] == 10 && bs[2] == 4 && bs[3] == 8) {
                    System.arraycopy(bs, 4, tmp, 0, tmp.length);
                } else {
                    System.arraycopy(bs, 2, tmp, 0, tmp.length);
                }
                param = new IvParameterSpec(tmp);
            }
            item = eci.getEncryptedContent();
            byte[] encdata = new byte[item.length];
            System.arraycopy(envelopeddata, item.offset, encdata, 0, encdata.length);
            byte[] key = null;
            try {
                WrapCard wrapCard = new WrapCard();
                key = wrapCard.rsaExternalDecrypt(prik, encKey);
            }
            catch (Exception ex) {
                throw new DecryptKeyException(ex.getMessage());
            }
            out = null;
            try {
                Cipher cd = Cipher.getInstance(algName);
                SecretKeySpec sk = new SecretKeySpec(key, PKCS7EnvelopedData.getAlgorithmFromAllName(algName));
                cd.init(2, (Key)sk, param);
                try {
                    out = cd.doFinal(encdata);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (out != null) break block22;
                DERInputStream derInputStream = new DERInputStream(new ByteArrayInputStream(encdata));
                if (derInputStream == null) {
                    return null;
                }
                try {
                    DERObject whole = derInputStream.readObject();
                    if (whole instanceof DEROctetString) {
                        byte contextHeadLen = encdata[1];
                        int lengthType = contextHeadLen & 0xF0;
                        byte[] encDataAct = null;
                        int encLengthLength = 0;
                        if (lengthType == 128) {
                            encLengthLength = contextHeadLen & 0xF;
                            encDataAct = new byte[encdata.length - 2 - encLengthLength];
                        } else {
                            encDataAct = new byte[encdata.length - 2];
                        }
                        System.arraycopy(encdata, 2 + encLengthLength, encDataAct, 0, encDataAct.length);
                        out = cd.doFinal(encDataAct);
                    }
                }
                catch (Exception e) {}
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new DecryptDataException(ex.getMessage());
            }
        }
        return out;
    }

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, P11Interface p11Impl, String m_keyType, String m_container) throws Exception {
        if (!this.fxPKCS7.pkcs7Data(envelopeddata)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        EnvelopedData ed = this.fxPKCS7.getEnvelopedData();
        if (ed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
        }
        ArrayList riList = ed.getVRecipientInfo();
        RecipientInfo ri = (RecipientInfo)riList.get(0);
        Item item = ri.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(envelopeddata, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString(10);
        String certIssuer = ((Object)((X509Certificate)cert).getIssuerDN()).toString();
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(10);
        if (!certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certificate is not match");
        }
        byte[] encKey = ri.getEncKey();
        EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
        item = eci.getContentEncryptionAlgorithm();
        bs = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, bs, 0, bs.length);
        in = new ASN1InputStream(bs);
        String algName = "";
        try {
            AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance(in.readObject());
            String algoid = alg.getObjectId().getId();
            algName = PKCS7EnvelopedData.getAlgorithmNameByOid(algoid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        item = eci.getIvParameter();
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        IvParameterSpec param = null;
        if (bs.length != 0 && (bs[2] != 5 || bs[3] != 0)) {
            byte[] tmp = new byte[bs[3]];
            System.arraycopy(bs, 4, tmp, 0, tmp.length);
            param = new IvParameterSpec(tmp);
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        key = p11Impl.priKeyDecryptByRsa(m_container, Integer.parseInt(m_keyType), encKey);
        byte[] out = null;
        try {
            Cipher cd = Cipher.getInstance(algName);
            SecretKeySpec sk = new SecretKeySpec(key, PKCS7EnvelopedData.getAlgorithmFromAllName(algName));
            cd.init(2, (Key)sk, param);
            out = cd.doFinal(encdata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, PrivateKey prik) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, IOException {
        return this.decrypt(envelopeddata, cert, prik, "BC");
    }

    private String getKeyMethodFromEncryMethod(String str) throws AlgorithmNotFoundException {
        if ("RSA-SHA1".equals(str)) {
            return "RSA";
        }
        if ("DES".equals(str)) {
            return "3DES";
        }
        if ("T-DES".equals(str)) {
            return "3DES";
        }
        throw new AlgorithmNotFoundException("\u6b64\u7b97\u6cd5\u65e0\u6548\uff01");
    }

    public byte[] encrypt(byte[] plaindata, byte[] cert, String algStr, String provider, PublicKey pubk) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException, IOException {
        int alg = PKCS7EnvelopedData.getAlgID(algStr);
        String algName = PKCS7EnvelopedData.getAlgName(alg);
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        X509CertificateStructure x509Cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(cert));
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(x509Cert.getIssuer().toString()), x509Cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(PKCS7EnvelopedData.getAlgorithmFromAllName(algName));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey key = kg.generateKey();
        byte[] keyData = key.getEncoded();
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc key exception ," + ex.getMessage());
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlg = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DERObject derParam = (DERObject)derAlg.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(algName);
            c.init(1, (Key)key, param);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DEROctetString_ encContent = new DEROctetString_(encdata);
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(byte[] plaindata, byte[] cert, String algStr, String provider, PublicKey pubk, byte[] key, byte[] iv) throws Exception {
        int alg = PKCS7EnvelopedData.getAlgID(algStr);
        String algName = PKCS7EnvelopedData.getAlgName(alg);
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        X509CertificateStructure x509Cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(cert));
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(x509Cert.getIssuer().toString()), x509Cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
        DESedeKeySpec keyspec = new DESedeKeySpec(key);
        SecretKey deskey = keyfactory.generateSecret(keyspec);
        byte[] keyData = key;
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptKeyException("enc key exception ," + ex.getMessage());
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlgTmp = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DEROctetString sIV = new DEROctetString(iv);
        AlgorithmIdentifier derAlg = new AlgorithmIdentifier(derAlgTmp.getObjectId(), sIV);
        IvParameterSpec param = new IvParameterSpec(iv);
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(algName);
            c.init(1, (Key)deskey, param);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DEROctetString_ encContent = new DEROctetString_(encdata);
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(long plaindataLen, byte[] cert, String algStr, String provider, PublicKey pubk, byte[] key, byte[] iv) throws Exception {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        X509CertificateStructure x509Cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(cert));
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(x509Cert.getIssuer().toString()), x509Cert.getSerialNumber());
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        byte[] keyData = key;
        Cipher c = null;
        byte[] encKey = null;
        c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(1, pubk);
        encKey = c.doFinal(keyData);
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        int alg = PKCS7EnvelopedData.getAlgID(algStr);
        AlgorithmIdentifier derAlgTmp = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DEROctetString sIV = new DEROctetString(iv);
        AlgorithmIdentifier derAlg = new AlgorithmIdentifier(derAlgTmp.getObjectId(), sIV);
        byte[] lengthByte = DerUtil.getDerLength(plaindataLen);
        byte[] encdata = new byte[lengthByte.length + 1];
        encdata[0] = -128;
        System.arraycopy(lengthByte, 0, encdata, 1, lengthByte.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] contentTypeByte = contentType.getEncoded();
        byte[] derAlgByte = derAlg.getEncoded();
        long contLeng = (long)(contentTypeByte.length + derAlgByte.length + encdata.length) + plaindataLen;
        byteArrayOutputStream.write(48);
        byteArrayOutputStream.write(DerUtil.getDerLength(contLeng));
        byteArrayOutputStream.write(contentTypeByte);
        byteArrayOutputStream.write(derAlgByte);
        byteArrayOutputStream.write(encdata);
        ByteArrayOutputStream envByteArrayOutputStream = new ByteArrayOutputStream();
        byte[] versionByte = version.getEncoded();
        byte[] recipientInfosByte = recipientInfos.getEncoded();
        long envLeng = (long)(versionByte.length + recipientInfosByte.length + byteArrayOutputStream.toByteArray().length) + plaindataLen;
        envByteArrayOutputStream.write(48);
        envByteArrayOutputStream.write(DerUtil.getDerLength(envLeng));
        envByteArrayOutputStream.write(versionByte);
        envByteArrayOutputStream.write(recipientInfosByte);
        envByteArrayOutputStream.write(byteArrayOutputStream.toByteArray());
        ByteArrayOutputStream derTagByteArrayOutputStream = new ByteArrayOutputStream();
        derTagByteArrayOutputStream.write(160);
        derTagByteArrayOutputStream.write(DerUtil.getDerLength((long)envByteArrayOutputStream.toByteArray().length + plaindataLen));
        derTagByteArrayOutputStream.write(envByteArrayOutputStream.toByteArray());
        ByteArrayOutputStream p7ByteArrayOutputStream = new ByteArrayOutputStream();
        String envdatatype = OID_ENVELOPEDDATATYPE;
        byte[] identifierByte = new DERObjectIdentifier(envdatatype).getEncoded();
        long p7Leng = (long)(identifierByte.length + derTagByteArrayOutputStream.toByteArray().length) + plaindataLen;
        p7ByteArrayOutputStream.write(48);
        p7ByteArrayOutputStream.write(DerUtil.getDerLength(p7Leng));
        p7ByteArrayOutputStream.write(identifierByte);
        p7ByteArrayOutputStream.write(derTagByteArrayOutputStream.toByteArray());
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        if (envByteArrayOutputStream != null) {
            envByteArrayOutputStream.close();
        }
        if (derTagByteArrayOutputStream != null) {
            derTagByteArrayOutputStream.close();
        }
        if (p7ByteArrayOutputStream != null) {
            p7ByteArrayOutputStream.close();
        }
        return p7ByteArrayOutputStream.toByteArray();
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String algStr, String provider) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        int alg = PKCS7EnvelopedData.getAlgID(algStr);
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((Object)((X509Certificate)cert).getIssuerDN()).toString()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(PKCS7EnvelopedData.getKeyGenAlgName(alg), provider);
        }
        catch (NoSuchProviderException ex) {
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey key = kg.generateKey();
        byte[] keyData = key.getEncoded();
        PublicKey pubk = cert.getPublicKey();
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception");
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlg = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DERObject derParam = (DERObject)derAlg.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(PKCS7EnvelopedData.getAlgName(alg), provider);
            c.init(1, (Key)key, param);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DERTaggedObject encContent = new DERTaggedObject(true, 0, new DEROctetString(encdata));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String algStr) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        return this.encrypt(plaindata, cert, algStr, "BC");
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, int alg) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((Object)((X509Certificate)cert).getIssuerDN()).toString()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(PKCS7EnvelopedData.getKeyGenAlgName(alg), "BC");
        }
        catch (NoSuchProviderException ex) {
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey key = kg.generateKey();
        byte[] keyData = key.getEncoded();
        PublicKey pubk = cert.getPublicKey();
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception");
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlg = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DERObject derParam = (DERObject)derAlg.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] rand = new byte[8];
        IvParameterSpec iv = new IvParameterSpec(rand);
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(PKCS7EnvelopedData.getAlgName(alg), "BC");
            c.init(1, (Key)key, iv);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DERTaggedObject encContent = new DERTaggedObject(true, 0, new DEROctetString(encdata));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bs;
    }

    private static String getAlgorithmNameByOid(String oid) throws AlgorithmNotFoundException {
        if (oid.equals(ID_DESEDE)) {
            return "DESede/CBC/PKCS5Padding";
        }
        if (oid.equals(ID_DES)) {
            return "DES/CBC/PKCS5Padding";
        }
        if (oid.equals(ID_AES)) {
            return "AES/ECB/PKCS5Padding";
        }
        throw new AlgorithmNotFoundException("\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u7b97\u6cd5 oid: " + oid);
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier_bjca(int alg) {
        String oid = null;
        boolean hasIV = false;
        if (alg == 10) {
            oid = ID_RC4;
            hasIV = false;
        } else if (alg == 13) {
            oid = ID_RC2;
            hasIV = true;
        } else if (alg == 12) {
            oid = ID_DESEDE;
            hasIV = true;
        } else if (alg == 11) {
            oid = ID_DES;
            hasIV = true;
        } else if (alg == 14) {
            oid = ID_AES;
            hasIV = true;
        }
        DEROctetString sIV = null;
        if (hasIV) {
            byte[] iv = new byte[8];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            sIV = new DEROctetString(iv);
        }
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(sIV);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), cont);
        return algID;
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier(int alg) {
        String oid = null;
        boolean hasIV = false;
        if (alg == 10) {
            oid = ID_RC4;
            hasIV = false;
        } else if (alg == 13) {
            oid = ID_RC2;
            hasIV = true;
        } else if (alg == 12) {
            oid = ID_DESEDE;
            hasIV = true;
        } else if (alg == 11) {
            oid = ID_DES;
            hasIV = true;
        } else if (alg == 14) {
            oid = ID_AES;
        }
        DEROctetString sIV = null;
        if (hasIV) {
            byte[] iv = new byte[8];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            sIV = new DEROctetString(iv);
        }
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), sIV);
        return algID;
    }

    private static String getKeyGenAlgName(int alg) {
        String name = "";
        if (alg == 10) {
            name = "RC4";
        } else if (alg == 3) {
            name = "RC2";
        } else if (alg == 2) {
            name = "DES";
        } else if (alg == 1) {
            name = "DESEDE";
        }
        return name;
    }

    private static String getAlgName(String oid) {
        String name = null;
        if (algmap.containsKey(oid)) {
            name = algmap.get(oid).toString();
        }
        return name;
    }

    private static String getAlgName(int alg) {
        String name = null;
        name = algArray[alg - 1];
        return name;
    }

    private static int getAlgID(String alg) {
        int id = 0;
        int loop = algArray2.length;
        for (int i = 0; i < loop; ++i) {
            if (!alg.equalsIgnoreCase(algArray2[i])) continue;
            id = i + 1;
            break;
        }
        return id;
    }

    private static String getAlgorithmFromAllName(String allName) {
        int i = allName.indexOf("/");
        String algName = allName.substring(0, i);
        return algName;
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        try {
            PKCS7EnvelopedData p7 = new PKCS7EnvelopedData();
            byte[] key = Base64.decode("AEm/T1R1gsfGxsPKL/PRSa3N+X+2Tfhh");
            byte[] iv = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv[i] = (byte)(i + 2);
            }
            String certString = "MIIFJTCCBA2gAwIBAgIKQAAAAAAAABV0ZTANBgkqhkiG9w0BAQUFADBSMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTEYMBYGA1UECwwPUHVibGljIFRydXN0IENBMRowGAYDVQQDDBFQdWJsaWMgVHJ1c3QgQ0EtMjAeFw0xMzA0MTExNjAwMDBaFw0yMzA0MTIxNTU5NTlaMFoxCzAJBgNVBAYTAkNOMRkwFwYDVQQKDBBEU1ZT6K6+5aSH6K+B5LmmMRkwFwYDVQQLDBBEU1ZT6K6+5aSH6K+B5LmmMRUwEwYDVQQDDAzorr7lpIfor4HkuaYwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKHIFxJQVK+BIx6uIG9CHDzCQUABWIsL9td/+t6ySRDyMZqvl0ZkomS6GFfeqcPjqs0/CDnWcyq7nfK3fmMrc9/Mf76p85eUfGxFCT2DPfvdZh0vuWKrHkoyEIlK34COgdYRPZ2yX82YLS9d5KlxG5JyfW2JKJMvpW79LD01iCZNAgMBAAGjggJ3MIICczAfBgNVHSMEGDAWgBT7t9RWF1iMI33V+EIB1O13m1fr6TAMBgNVHQ8EBQMDB/gAMCsGA1UdEAQkMCKADzIwMTMwNDEyMDAwMDAwWoEPMjAyMzA0MTIyMzU5NTlaMAkGA1UdEwQCMAAwga8GA1UdHwSBpzCBpDBtoGugaaRnMGUxCzAJBgNVBAYTAkNOMQ0wCwYDVQQKDARCSkNBMRgwFgYDVQQLDA9QdWJsaWMgVHJ1c3QgQ0ExGjAYBgNVBAMMEVB1YmxpYyBUcnVzdCBDQS0yMREwDwYDVQQDEwhjYTRjcmwyNTAzoDGgL4YtaHR0cDovL2xkYXAuYmpjYS5vcmcuY24vY3JsL3B0Y2EvY2E0Y3JsMjUuY3JsMBEGCWCGSAGG+EIBAQQEAwIA/zAqBgtghkgBZQMCATAJCgQbaHR0cDovL2JqY2Eub3JnLmNuL2JqY2EuY3J0MBQGBSpWCwcJBAtKSjEyMzQ1Njc4OTAXBghghkgBhvhEAgQLSkoxMjM0NTY3ODkwGwYIKlaGSAGBMAEEDzAxMTAwMDEwMDA0ODkzMDAaBgYqVgsHAQgEEDE1MENASkoxMjM0NTY3ODkwgbAGA1UdIASBqDCBpTA1BgkqgRwBxTiBFQEwKDAmBggrBgEFBQcCARYaaHR0cDovL3d3dy5iamNhLm9yZy5jbi9jcHMwNQYJKoEcAcU4gRUCMCgwJgYIKwYBBQUHAgEWGmh0dHA6Ly93d3cuYmpjYS5vcmcuY24vY3BzMDUGCSqBHAHFOIEVAzAoMCYGCCsGAQUFBwIBFhpodHRwOi8vd3d3LmJqY2Eub3JnLmNuL2NwczANBgkqhkiG9w0BAQUFAAOCAQEADjI8yTkJPNNfjPnHtK3EwHUs1OtvcQWTdCZLlvr6zRiZTScPocvTJfyOX7RaAOhaZ0DzTKjpB/se+X6WUPDmaMaU74x+9KEXK7lyiidl5niiaV5ahV2ykH890je34Q2ILAn6k5b7nKOEoEeoQ0pzthKrTZnlbdm0MNU59Lnu4ePN2F+cyfXowrGiVSw3akglFoyeJ9b317gmsEBQ7VSVLJDhkcPyH4ygzwrMIzD9+e2fYJFyjJ4C+EdyV2mtk+3nOpeGasQtYKxaqiaqpg8eJP86tIKhWBnPzIr7Z4LN96+k8kkUJyTl0pQ+9lXmBF2pja5TrHkQNmdrp7+nW+5Mcg==";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean compereDN(String DN1, String JKSDN) {
        if (DN1 == null || JKSDN == null) {
            return false;
        }
        if (DN1.equals(JKSDN)) {
            return true;
        }
        String[] temp = JKSDN.split(",");
        String turnDN = temp[0].trim();
        for (int i = 1; i <= temp.length - 1; ++i) {
            turnDN = turnDN + "," + temp[i].trim();
        }
        return DN1.equals(turnDN);
    }

    static {
        algArray = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "DESede/CBC/PKCS5Padding", "RC2", "AES/ECB/PKCS5Padding"};
        algArray2 = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "3DES", "RC2", "AES"};
        algmap = null;
        algmap = new HashMap();
        algmap.put(ID_MD5, "MD5");
        algmap.put(ID_MD2, "MD2");
        algmap.put(ID_SHA1, "SHA1");
        algmap.put("1.2.840.113549.1.1.1", "RSA");
        algmap.put(ID_DSA, "DSA");
        algmap.put(ID_SHA224, "SHA224");
        algmap.put(ID_SHA256, "SHA256");
        algmap.put(ID_SHA384, "SHA384");
        algmap.put(ID_SHA512, "SHA512");
        algmap.put(ID_RC4, "RC4");
        algmap.put(ID_DES, "DES");
        algmap.put(ID_DESEDE, "DESEDE");
        algmap.put(ID_RC2, "RC2");
        algmap.put(ID_AES, "AES");
    }
}

