/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.impl.entity;

import xjyb.org.apache.http.HttpException;
import xjyb.org.apache.http.HttpMessage;
import xjyb.org.apache.http.ProtocolException;
import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.entity.ContentLengthStrategy;
import xjyb.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

