/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.utils.Base64Util;

public class CryptoUtil
extends SuperUtil {
    private long[] SymmKeyObj = new long[1];

    public CryptoUtil(String appName) {
        super(appName);
    }

    public String BJS_SymmEncrypt(BjcaApiEngine apiengine, long ALGID, long cryptoMode, byte[] key, long keyLen, byte[] iv, byte[] toBeEncryptedBlob) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        long[] SymmKeyObj = new long[1];
        String sdata = null;
        int execflag = 0;
        try {
            execflag = apiengine.BCA_CreateSymmKeyObj(SymmKeyObj, ALGID, 1L, cryptoMode, key, keyLen, iv);
        }
        catch (Exception e) {
            sdata = null;
            this.errorlog("Exception in dynamic link libraries,symmetric encryption,BCA_CreateSymmKeyObj!", e);
            this.debuglog("Exception in dynamic link libraries,symmetric encryption,BCA_CreateSymmKeyObj!");
            throw new EncryptDataException("Exception in dynamic link libraries,symmetric encryption,BCA_CreateSymmKeyObj!");
        }
        if (execflag != 0) {
            sdata = null;
            this.errorlog("Failed to encrypt by symmetric,BCA_CreateSymmKeyObj");
            this.debuglog("Failed to encrypt by symmetric,BCA_CreateSymmKeyObj");
            throw new EncryptDataException("Failed to encrypt by symmetric,BCA_CreateSymmKeyObj");
        }
        byte[] outData = new byte[toBeEncryptedBlob.length + 24];
        long[] outDataLen = new long[1];
        try {
            execflag = apiengine.BCA_SymmEncrypt(SymmKeyObj[0], toBeEncryptedBlob, toBeEncryptedBlob.length, outData, outDataLen);
        }
        catch (Exception e) {
            this.errorlog("Exception in dynamic link libraries,symmetric encryption,BCA_SymmEncrypt!", e);
            this.debuglog("Exception in dynamic link libraries,symmetric encryption,BCA_SymmEncrypt!");
            throw new EncryptDataException("Exception in dynamic link libraries,symmetric encryption,BCA_SymmEncrypt!");
        }
        if (execflag != 0) {
            sdata = null;
            this.errorlog("Failed to encrypt by symmetric,BCA_SymmEncrypt");
            this.debuglog("Failed to encrypt by symmetric,BCA_SymmEncrypt");
            throw new EncryptDataException("Failed to encrypt by symmetric,BCA_SymmEncrypt");
        }
        int dataLen = (int)outDataLen[0];
        sdata = base64Util.BJS_EncodeBase64(outData, dataLen);
        apiengine.BCA_DestroySymmKeyObj(SymmKeyObj[0]);
        return sdata;
    }

    public void BJS_SymmEncryptInit(BjcaApiEngine apiengine, long ALGID, long cryptoMode, byte[] key, int keylen, byte[] iv) throws EncryptDataException {
        int rv = 0;
        try {
            rv = apiengine.BCA_CreateSymmKeyObj(this.SymmKeyObj, ALGID, 1L, cryptoMode, key, keylen, iv);
        }
        catch (Exception see) {
            this.errorlog("Exception in symmetric encryption,BJS_SymmEncryptInit!", see);
            this.debuglog("Exception in symmetric encryption,BJS_SymmEncryptInit!");
            throw new EncryptDataException("Exception symmetric encryption,BJS_SymmEncryptInit!");
        }
        if (rv != 0) {
            this.errorlog("Failed to encrypt,BJS_SymmEncryptInit!");
            this.debuglog("Failed to encrypt,BJS_SymmEncryptInit!");
            throw new EncryptDataException("Failed to encrypt,BJS_SymmEncryptInit!");
        }
    }

    public byte[] BJS_SymmEncryptUpdata(BjcaApiEngine apiengine, byte[] indata, int len) throws EncryptDataException {
        int rv = 0;
        byte[] outdata = new byte[len + 64];
        long[] outlen = new long[1];
        if (this.SymmKeyObj[0] == 0L) {
            this.errorlog("Failed to initialize,BJS_SymmEncryptUpdata");
            this.debuglog("Failed to initialize,BJS_SymmEncryptUpdata");
            throw new EncryptDataException("Failed to initialize,BJS_SymmEncryptUpdata");
        }
        try {
            rv = apiengine.BCA_SymmEncryptUpdate(this.SymmKeyObj[0], indata, len, outdata, outlen);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BJS_SymmEncryptUpdata", see);
            this.debuglog("Exception in dynamic link libraries,BJS_SymmEncryptUpdata");
            throw new EncryptDataException("Exception in dynamic link libraries,BJS_SymmEncryptUpdata");
        }
        if (rv == 0) {
            byte[] sdata = new byte[(int)outlen[0]];
            System.arraycopy(outdata, 0, sdata, 0, sdata.length);
            return sdata;
        }
        this.errorlog("Failed to encrypt,BJS_SymmEncryptUpdata");
        this.debuglog("Failed to encrypt,BJS_SymmEncryptUpdata");
        throw new EncryptDataException("Failed to encrypt,BJS_SymmEncryptUpdata");
    }

    public byte[] BJS_SymmEncryptFinal(BjcaApiEngine apiengine) throws EncryptDataException {
        byte[] outdata = new byte[64];
        long[] outlen = new long[1];
        if (this.SymmKeyObj[0] == 0L) {
            this.errorlog("Failed to initialize,BJS_SymmEncryptFinal");
            this.debuglog("Failed to initialize,BJS_SymmEncryptFinal");
            throw new EncryptDataException("Failed to initialize,BJS_SymmEncryptFinal");
        }
        int rv = 0;
        try {
            rv = apiengine.BCA_SymmEncryptFinal(this.SymmKeyObj[0], outdata, outlen);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BJS_SymmEncryptFinal", see);
            this.debuglog("Exception in dynamic link libraries,BJS_SymmEncryptFinal");
            throw new EncryptDataException("Exception in dynamic link libraries,BJS_SymmEncryptFinal");
        }
        finally {
            apiengine.BCA_DestroySymmKeyObj(this.SymmKeyObj[0]);
            this.SymmKeyObj[0] = 0L;
        }
        if (rv == 0) {
            byte[] sdata = new byte[(int)outlen[0]];
            System.arraycopy(outdata, 0, sdata, 0, sdata.length);
            return sdata;
        }
        this.errorlog("Failed to encrypt,BCA_SymmEncryptFinal");
        this.debuglog("Failed to encrypt,BCA_SymmEncryptFinal");
        throw new EncryptDataException("Failed to encrypt,BCA_SymmEncryptFinal");
    }

    public boolean BJS_SymmEncFile(BjcaApiEngine apiengine, String srcfile, String destfile, byte[] key, long EncAlg, long mode) throws EncryptDataException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            File fin = new File(srcfile);
            fis = new FileInputStream(fin);
            fos = new FileOutputStream(destfile);
            long filelen = fin.length();
            byte[] iv = new byte[8];
            for (i = 0; i < 8; ++i) {
                iv[i] = (byte)(i + 2);
            }
            this.BJS_SymmEncryptInit(apiengine, EncAlg, mode, key, key.length, iv);
            long count = filelen / 1024L;
            byte[] inbuf = new byte[1024];
            byte[] outbuf = null;
            i = 0;
            while ((long)i <= count) {
                int rlen = fis.read(inbuf);
                outbuf = this.BJS_SymmEncryptUpdata(apiengine, inbuf, rlen);
                fos.write(outbuf);
                ++i;
            }
            outbuf = this.BJS_SymmEncryptFinal(apiengine);
            fos.write(outbuf);
            fos.close();
            fis.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.errorlog("Failed to encrypt,BJS_SymmEncFile", e);
            this.debuglog("Failed to encrypt,BJS_SymmEncFile");
            throw new EncryptDataException("Failed to encrypt,BJS_SymmEncFile");
        }
        finally {
            try {
                fos.close();
                fis.close();
            }
            catch (IOException e) {
                this.errorlog("Failed to close io", e);
                this.debuglog("Failed to close io");
            }
        }
    }

    public byte[] BJS_SymmDecrypt(BjcaApiEngine apiengine, long ALGID, long cryptoMode, byte[] key, long keyLen, byte[] iv, String beDecryptedBlob) throws DecryptDataException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] sdata = null;
        long[] SymmKeyObj = new long[1];
        int execflag = 0;
        try {
            execflag = apiengine.BCA_CreateSymmKeyObj(SymmKeyObj, ALGID, 0L, cryptoMode, key, keyLen, iv);
        }
        catch (Exception e) {
            this.errorlog("Exception in dynamic link libraries,BJS_SymmDecrypt", e);
            this.debuglog("Exception in dynamic link libraries,BJS_SymmDecrypt");
            throw new DecryptDataException("Exception in dynamic link libraries,BJS_SymmDecrypt");
        }
        if (execflag != 0) {
            this.errorlog("Failed to initialize,BCA_CreateSymmKeyObj");
            this.debuglog("Failed to initialize,BCA_CreateSymmKeyObj");
            throw new DecryptDataException("Failed to initialize,BCA_CreateSymmKeyObj");
        }
        byte[] beDecryptBuf = base64Util.BJS_DecodeBase64(beDecryptedBlob);
        byte[] outData = new byte[beDecryptedBlob.length()];
        long[] outDataLen = new long[1];
        try {
            execflag = apiengine.BCA_SymmDecrypt(SymmKeyObj[0], beDecryptBuf, beDecryptBuf.length, outData, outDataLen);
        }
        catch (Exception e) {
            this.errorlog("Exception in dynamic link libraries,BCA_SymmDecrypt", e);
            this.debuglog("Exception in dynamic link libraries,BCA_SymmDecrypt");
            throw new DecryptDataException("Exception in dynamic link libraries,BCA_SymmDecrypt");
        }
        if (execflag != 0) {
            this.errorlog("Failed to decrypt,BCA_SymmDecrypt");
            this.debuglog("Failed to decrypt,BCA_SymmDecrypt");
            throw new DecryptDataException("Failed to decrypt,BCA_SymmDecrypt");
        }
        sdata = new byte[(int)outDataLen[0]];
        System.arraycopy(outData, 0, sdata, 0, (int)outDataLen[0]);
        try {
            apiengine.BCA_DestroySymmKeyObj(SymmKeyObj[0]);
        }
        catch (Exception e) {
            this.errorlog("Exception in BJS_SymmDecrypt", e);
            this.debuglog("Exception in BJS_SymmDecrypt");
        }
        return sdata;
    }

    public void BJS_SymmDecryptInit(BjcaApiEngine apiengine, long ALGID, long cryptoMode, byte[] key, int keylen, byte[] iv) throws DecryptDataException {
        int rv = 0;
        try {
            rv = apiengine.BCA_CreateSymmKeyObj(this.SymmKeyObj, ALGID, 0L, cryptoMode, key, keylen, iv);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,,BCA_CreateSymmKeyObj", see);
            this.debuglog("Exception in dynamic link libraries,,BCA_CreateSymmKeyObj");
            throw new DecryptDataException("Exception in dynamic link libraries,,BCA_CreateSymmKeyObj");
        }
        if (rv != 0) {
            this.errorlog("Failed to decrypt,BCA_CreateSymmKeyObj");
            this.debuglog("Failed to decrypt,BCA_CreateSymmKeyObj");
            throw new DecryptDataException("Failed to decrypt,BCA_CreateSymmKeyObj");
        }
    }

    public byte[] BJS_SymmDecryptUpdata(BjcaApiEngine apiengine, byte[] indata, int len) throws DecryptDataException {
        byte[] outdata = new byte[len + 64];
        long[] outlen = new long[1];
        if (this.SymmKeyObj[0] == 0L) {
            this.errorlog("Failed to initialize,BJS_SymmDecryptUpdata");
            this.debuglog("Failed to initialize,BJS_SymmDecryptUpdata");
            throw new DecryptDataException("Failed to initialize,BJS_SymmDecryptUpdata");
        }
        int rv = 0;
        try {
            rv = apiengine.BCA_SymmDecryptUpdate(this.SymmKeyObj[0], indata, len, outdata, outlen);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BCA_SymmDecryptUpdate", see);
            this.debuglog("Exception in dynamic link libraries,BCA_SymmDecryptUpdate");
            throw new DecryptDataException("Exception in dynamic link libraries,BCA_SymmDecryptUpdate");
        }
        if (rv == 0) {
            byte[] sdata = new byte[(int)outlen[0]];
            System.arraycopy(outdata, 0, sdata, 0, sdata.length);
            return sdata;
        }
        this.errorlog("Failed to decrypt,BCA_SymmDecryptUpdate");
        this.debuglog("Failed to decrypt,BCA_SymmDecryptUpdate");
        throw new DecryptDataException("Failed to decrypt,BCA_SymmDecryptUpdate");
    }

    public byte[] BJS_SymmDecryptFinal(BjcaApiEngine apiengine) throws DecryptDataException {
        byte[] outdata = new byte[64];
        long[] outlen = new long[1];
        if (this.SymmKeyObj[0] == 0L) {
            this.errorlog("Failed to initialize,BJS_SymmDecryptFinal");
            this.debuglog("Failed to initialize,BJS_SymmDecryptFinal");
            throw new DecryptDataException("Failed to initialize,BJS_SymmDecryptFinal");
        }
        int rv = 0;
        try {
            rv = apiengine.BCA_SymmDecryptFinal(this.SymmKeyObj[0], outdata, outlen);
        }
        catch (Exception see) {
            this.errorlog("Exception in dynamic link libraries,BCA_SymmDecryptFinal", see);
            this.debuglog("Exception in dynamic link libraries,BCA_SymmDecryptFinal");
            throw new DecryptDataException("Exception in dynamic link libraries,BCA_SymmDecryptFinal");
        }
        finally {
            apiengine.BCA_DestroySymmKeyObj(this.SymmKeyObj[0]);
            this.SymmKeyObj[0] = 0L;
        }
        if (rv == 0) {
            byte[] sdata = new byte[(int)outlen[0]];
            System.arraycopy(outdata, 0, sdata, 0, sdata.length);
            return sdata;
        }
        this.errorlog("Failed to decrypt,BCA_SymmDecryptFinal");
        this.debuglog("Failed to decrypt,BCA_SymmDecryptFinal");
        throw new DecryptDataException("Failed to decrypt,BCA_SymmDecryptFinal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean BJS_SymmDecFile(BjcaApiEngine apiengine, String srcfile, String destfile, byte[] key, long EncAlg, long mode) throws DecryptDataException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            File fin = new File(srcfile);
            fis = new FileInputStream(fin);
            fos = new FileOutputStream(destfile);
            long filelen = fin.length();
            byte[] iv = new byte[8];
            for (i = 0; i < 8; ++i) {
                iv[i] = (byte)(i + 2);
            }
            this.BJS_SymmDecryptInit(apiengine, EncAlg, mode, key, key.length, iv);
            long count = filelen / 1024L;
            byte[] inbuf = new byte[1024];
            byte[] outbuf = null;
            i = 0;
            while ((long)i <= count) {
                int rlen = fis.read(inbuf);
                outbuf = this.BJS_SymmDecryptUpdata(apiengine, inbuf, rlen);
                fos.write(outbuf);
                ++i;
            }
            outbuf = this.BJS_SymmDecryptFinal(apiengine);
            fos.write(outbuf);
            fos.close();
            fis.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.errorlog("Exception in BJS_SymmDecFile", e);
            this.debuglog("Exception in BJS_SymmDecFile");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fos.close();
                fis.close();
            }
            catch (IOException e) {}
        }
    }
}

