/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.jce.CNTimeStamp;
import xjyb.org.bjca.jce.TimeStamp;
import xjyb.org.bjca.jce.interfaces.P11Interface;

public class TimeStampUtil
extends SuperUtil {
    public TimeStampUtil(String appName) {
        super(appName);
    }

    public byte[] createTimeStampRequest(byte[] originalData, int m_Iinitmodel, boolean isAttachCert) throws HashException {
        try {
            byte[] tsRequest = null;
            if (m_Iinitmodel == 7 || m_Iinitmodel == 8) {
                WrapCard wCard = new WrapCard();
                byte[] hashedData = wCard.sm3(originalData, null, null);
                CNTimeStamp ts = new CNTimeStamp();
                tsRequest = ts.createRequest(hashedData, isAttachCert);
            } else {
                HashUtil hashUtil = new HashUtil(this.applicationName);
                byte[] hashBytes = hashUtil.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), originalData);
                TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
                tsqGenerator.setCertReq(isAttachCert);
                BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
                ASN1ObjectIdentifier hashAlg = TSPAlgorithms.SHA1;
                if (HashUtil.getHashAlg(this.applicationName).equals("SHA256")) {
                    hashAlg = TSPAlgorithms.SHA256;
                }
                TimeStampRequest request = tsqGenerator.generate(hashAlg, hashBytes, nonce);
                tsRequest = request.getEncoded();
            }
            return tsRequest;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorlog("Exception in create time stamp request!", e);
            this.debuglog("Exception in create time stamp request!");
            return null;
        }
    }

    public byte[] timeStampResponseByRequest(byte[] request, int m_Iinitmodel, X509CertificateStructure strcSignCert, PrivateKey privateKey, byte[] privateKeyByte) throws TsException {
        try {
            byte[] p7SignedData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(strcSignCert.getEncoded());
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                certList.add(oCert);
                JcaCertStore certStore = new JcaCertStore(certList);
                JcaSimpleSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder();
                SignerInfoGenerator signerInfoGenerator = null;
                String hashType = HashUtil.getHashAlg(this.applicationName);
                signerInfoGenerator = "SHA1".equals(hashType) ? signerInfoGeneratorBuilder.build("SHA1withRSA", privateKey, (X509Certificate)certs[0]) : signerInfoGeneratorBuilder.build("SHA256withRSA", privateKey, (X509Certificate)certs[0]);
                TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(signerInfoGenerator, new ASN1ObjectIdentifier("1.2"));
                tsTokenGen.addCertificates(certStore);
                TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
                TimeStampRequest tsRequest = new TimeStampRequest(request);
                TimeStampResponse tsResp = tsRespGen.generate(tsRequest, new BigInteger("100000001"), new Date());
                TimeStampToken tsToken = tsResp.getTimeStampToken();
                p7SignedData = tsToken.toCMSSignedData().toASN1Structure().getEncoded("DER");
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                X509CertificateStructure[] certs = new X509CertificateStructure[]{strcSignCert};
                CNTimeStamp cnTs = new CNTimeStamp(certs);
                cnTs.updateRequest(request);
                p7SignedData = cnTs.getEncoded(privateKeyByte, true);
            }
            return p7SignedData;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in signing data by pkcs7!", e);
            this.debuglog("Exception in signing data by pkcs7!");
            throw new TsException("Exception in signing data by pkcs7!");
        }
    }

    public byte[] timeStampResponseByRequest0033(byte[] request, int m_Iinitmodel, X509CertificateStructure strcSignCert, PrivateKey privateKey, byte[] privateKeyByte) throws TsException {
        try {
            byte[] p7SignedData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(strcSignCert.getEncoded());
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                certList.add(oCert);
                JcaCertStore certStore = new JcaCertStore(certList);
                JcaSimpleSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder();
                SignerInfoGenerator signerInfoGenerator = null;
                String hashType = HashUtil.getHashAlg(this.applicationName);
                signerInfoGenerator = "SHA1".equals(hashType) ? signerInfoGeneratorBuilder.build("SHA1withRSA", privateKey, (X509Certificate)certs[0]) : signerInfoGeneratorBuilder.build("SHA256withRSA", privateKey, (X509Certificate)certs[0]);
                TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(signerInfoGenerator, new ASN1ObjectIdentifier("1.2"));
                tsTokenGen.addCertificates(certStore);
                TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
                TimeStampRequest tsRequest = new TimeStampRequest(request);
                TimeStampResponse tsResp = tsRespGen.generate(tsRequest, new BigInteger("100000001"), new Date());
                TimeStampToken tsToken = tsResp.getTimeStampToken();
                p7SignedData = tsResp.getEncoded();
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                X509CertificateStructure[] certs = new X509CertificateStructure[]{strcSignCert};
                CNTimeStamp cnTs = new CNTimeStamp(certs);
                cnTs.updateRequest0033(request);
                p7SignedData = cnTs.getEncoded0033(privateKeyByte, true);
            }
            return p7SignedData;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in signing data by pkcs7!", e);
            this.debuglog("Exception in signing data by pkcs7!");
            throw new TsException("Exception in signing data by pkcs7!");
        }
    }

    public boolean verifyTimeStamp(byte[] beSignedBlob, byte[] cert, int m_Iinitmodel) throws TsException {
        try {
            boolean verified = false;
            String hashAlg = TimeStampUtil.getTimeStampHash(beSignedBlob);
            if (hashAlg.equals("SM3")) {
                CNTimeStamp ts = new CNTimeStamp(beSignedBlob);
                verified = ts.verify(cert);
            } else {
                ContentInfo tsContentInfo = ContentInfo.getInstance(beSignedBlob);
                TimeStampToken timeStampToken = new TimeStampToken(tsContentInfo);
                try {
                    X509CertificateHolder certificate = null;
                    certificate = cert == null ? timeStampToken.getCertificates().getMatches(null).iterator().next() : new X509CertificateHolder(cert);
                    timeStampToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certificate));
                    verified = true;
                }
                catch (Exception e) {
                    this.errorlog("Exception in verify time stamp!", e);
                    this.debuglog("Exception in verify time stamp!");
                    verified = false;
                }
            }
            return verified;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in verify time stamp!", e);
            this.debuglog("Exception in verify time stamp!");
            throw new TsException("Exception in verify sign data by pkcs7!");
        }
    }

    public static String getTimeStampHash(byte[] beSignedBlob) throws TsException {
        try {
            ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(beSignedBlob));
            ASN1Sequence whole = (ASN1Sequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            ASN1Sequence body = (ASN1Sequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            ASN1Set signerinfos = (ASN1Set)body.getObjectAt(1);
            if (signerinfos == null) {
                return null;
            }
            ASN1Sequence signerinfo = (ASN1Sequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DERObjectIdentifier digest = (DERObjectIdentifier)signerinfo.getObjectAt(0);
            if (digest == null) {
                return null;
            }
            String hashAlgIdentifier = digest.toString();
            String hashAlg = "SHA1";
            if (hashAlgIdentifier.equals("1.3.14.3.2.26")) {
                hashAlg = "SHA1";
            } else if (hashAlgIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
                hashAlg = "SHA256";
            } else if (hashAlgIdentifier.contains("1.2.156.10197.1.401")) {
                hashAlg = "SM3";
            } else {
                return null;
            }
            return hashAlg;
        }
        catch (Exception e) {
            throw new TsException("Exception in decoding TimeStamp!", e);
        }
    }

    public ArrayList getTimeStampInfo(byte[] beSignedBlob, int m_Iinitmodel) throws TsException {
        try {
            ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(beSignedBlob));
            ASN1Sequence whole = (ASN1Sequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            ASN1Sequence body = (ASN1Sequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            ASN1Set signerinfos = (ASN1Set)body.getObjectAt(1);
            if (signerinfos == null) {
                return null;
            }
            ASN1Sequence signerinfo = (ASN1Sequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DERObjectIdentifier digest = (DERObjectIdentifier)signerinfo.getObjectAt(0);
            if (digest == null) {
                return null;
            }
            String hashAlgIdentifier = digest.toString();
            String hashAlg = "SHA1";
            if (hashAlgIdentifier.equals("1.3.14.3.2.26")) {
                hashAlg = "SHA1";
            } else if (hashAlgIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
                hashAlg = "SHA256";
            } else if (hashAlgIdentifier.contains("1.2.156.10197.1.401")) {
                hashAlg = "SM3";
            } else {
                return null;
            }
            Base64Util base64Util = new Base64Util(this.applicationName);
            ArrayList<String> infoList = new ArrayList<String>();
            CNTimeStamp ts = null;
            if (hashAlg.equals("SM3")) {
                ts = new CNTimeStamp(beSignedBlob);
                byte[] timeByte = ts.getTimeByte();
                String time = new String(timeByte);
                String formateTime = time.substring(0, 14);
                TimeZone defaultTZ = TimeZone.getDefault();
                TimeZone.setDefault(TimeZone.getTimeZone("Zulu"));
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                Date date = dateformat.parse(formateTime);
                dateformat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                String conversionTime = dateformat.format(date);
                TimeZone.setDefault(defaultTZ);
                infoList.add(conversionTime);
                byte[] originalHashByte = ts.getOriginalHashByte();
                String base64HashValue = base64Util.BJS_EncodeBase64(originalHashByte);
                infoList.add(base64HashValue);
                byte[] cert = ts.getSignCertByte();
                if (cert != null) {
                    String base64Cert = base64Util.BJS_EncodeBase64(cert);
                    infoList.add(base64Cert);
                } else {
                    infoList.add(null);
                }
                String serialNumber = ts.getSerialNumber();
                infoList.add(serialNumber);
                infoList.add(hashAlg);
                return infoList;
            }
            ContentInfo tsContentInfo = ContentInfo.getInstance(beSignedBlob);
            TimeStampToken timeStampToken = new TimeStampToken(tsContentInfo);
            Date tsDate = timeStampToken.getTimeStampInfo().getGenTime();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateformat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            String conversionTime = dateformat.format(tsDate);
            infoList.add(conversionTime);
            byte[] messageImprint = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
            String messageImprintStr = base64Util.BJS_EncodeBase64(messageImprint);
            infoList.add(messageImprintStr);
            Collection<X509CertificateHolder> certCollection = timeStampToken.getCertificates().getMatches(null);
            String certSerialNumber = null;
            String certBase64 = null;
            if (certCollection.size() != 0) {
                X509CertificateHolder certificate = certCollection.iterator().next();
                certBase64 = base64Util.BJS_EncodeBase64(certificate.getEncoded());
            }
            certSerialNumber = timeStampToken.getSID().getSerialNumber().toString(16);
            infoList.add(certBase64);
            infoList.add(certSerialNumber);
            infoList.add(hashAlg);
            return infoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in decoding time stamp data!", e);
            this.debuglog("Exception in decoding time stamp data!");
            throw new TsException("Exception in decoding TimeStamp!");
        }
    }

    public ArrayList getTimeStampInfo0033(byte[] beSignedBlob, int m_Iinitmodel) throws TsException {
        try {
            ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(beSignedBlob));
            ASN1Sequence whole = (ASN1Sequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            ASN1Sequence body = (ASN1Sequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            ASN1Set signerinfos = (ASN1Set)body.getObjectAt(1);
            if (signerinfos == null) {
                return null;
            }
            ASN1Sequence signerinfo = (ASN1Sequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DERObjectIdentifier digest = (DERObjectIdentifier)signerinfo.getObjectAt(0);
            if (digest == null) {
                return null;
            }
            String hashAlgIdentifier = digest.toString();
            String hashAlg = "SHA1";
            if (hashAlgIdentifier.equals("1.3.14.3.2.26")) {
                hashAlg = "SHA1";
            } else if (hashAlgIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
                hashAlg = "SHA256";
            } else if (hashAlgIdentifier.contains("1.2.156.10197.1.401")) {
                hashAlg = "SM3";
            } else {
                return null;
            }
            Base64Util base64Util = new Base64Util(this.applicationName);
            ArrayList<String> infoList = new ArrayList<String>();
            CNTimeStamp ts = null;
            if (hashAlg.equals("SM3")) {
                ts = new CNTimeStamp(beSignedBlob);
                byte[] timeByte = ts.getTimeByte();
                String time = new String(timeByte);
                String formateTime = time.substring(0, 14);
                TimeZone defaultTZ = TimeZone.getDefault();
                TimeZone.setDefault(TimeZone.getTimeZone("Zulu"));
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                Date date = dateformat.parse(formateTime);
                dateformat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                String conversionTime = dateformat.format(date);
                TimeZone.setDefault(defaultTZ);
                infoList.add(conversionTime);
                byte[] originalHashByte = ts.getOriginalHashByte();
                String base64HashValue = base64Util.BJS_EncodeBase64(originalHashByte);
                infoList.add(base64HashValue);
                byte[] cert = ts.getSignCertByte();
                if (cert != null) {
                    String base64Cert = base64Util.BJS_EncodeBase64(cert);
                    infoList.add(base64Cert);
                } else {
                    infoList.add(null);
                }
                String serialNumber = ts.getSerialNumber();
                infoList.add(serialNumber);
                infoList.add(hashAlg);
                byte[] accuracyByte = ts.getAccuracy();
                String accuracy = base64Util.BJS_EncodeBase64(accuracyByte);
                infoList.add(accuracy);
                return infoList;
            }
            ContentInfo tsContentInfo = ContentInfo.getInstance(beSignedBlob);
            TimeStampToken timeStampToken = new TimeStampToken(tsContentInfo);
            Date tsDate = timeStampToken.getTimeStampInfo().getGenTime();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateformat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            String conversionTime = dateformat.format(tsDate);
            infoList.add(conversionTime);
            byte[] messageImprint = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
            String messageImprintStr = base64Util.BJS_EncodeBase64(messageImprint);
            infoList.add(messageImprintStr);
            Collection<X509CertificateHolder> certCollection = timeStampToken.getCertificates().getMatches(null);
            String certSerialNumber = null;
            String certBase64 = null;
            if (certCollection.size() != 0) {
                X509CertificateHolder certificate = certCollection.iterator().next();
                certBase64 = base64Util.BJS_EncodeBase64(certificate.getEncoded());
            }
            certSerialNumber = timeStampToken.getSID().getSerialNumber().toString(16);
            infoList.add(certBase64);
            infoList.add(certSerialNumber);
            infoList.add(hashAlg);
            return infoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in decoding time stamp data!", e);
            this.debuglog("Exception in decoding time stamp data!");
            throw new TsException("Exception in decoding TimeStamp!");
        }
    }

    public byte[] createTimeStampRequest(byte[] originalData, int m_Iinitmodel) throws HashException {
        try {
            byte[] tsRequest = null;
            if (m_Iinitmodel == 7 || m_Iinitmodel == 8) {
                WrapCard wCard = new WrapCard();
                byte[] hashedData = wCard.sm3(originalData, null, null);
                CNTimeStamp ts = new CNTimeStamp();
                tsRequest = ts.createRequest(hashedData, true);
            } else {
                HashUtil hashUtil = new HashUtil(this.applicationName);
                byte[] hashBytes = hashUtil.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), originalData);
                TimeStamp ts = new TimeStamp();
                tsRequest = ts.createRequest(hashBytes, HashUtil.getHashAlgLong(this.applicationName));
            }
            return tsRequest;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorlog("Exception in create time stamp request!", e);
            this.debuglog("Exception in create time stamp request!");
            return null;
        }
    }

    public byte[] timeStampResponseByRequest(byte[] request, boolean isAttachCert, int m_Iinitmodel, X509CertificateStructure strcSignCert, PrivateKey privateKey, byte[] privatekeyByte, P11Interface p11Impl) throws TsException {
        try {
            byte[] p7SignedData = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(strcSignCert.getEncoded());
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                HashUtil hashUtil = new HashUtil(this.applicationName);
                TimeStamp ts = new TimeStamp(privateKey, certs, HashUtil.getHashAlg(this.applicationName));
                ts.updateRequest(request);
                p7SignedData = ts.getEncoded(isAttachCert);
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                X509CertificateStructure[] certs = new X509CertificateStructure[]{strcSignCert};
                CNTimeStamp cnTs = new CNTimeStamp(certs);
                cnTs.updateRequest(request);
                p7SignedData = cnTs.getEncoded(privatekeyByte, isAttachCert);
            }
            return p7SignedData;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            this.debuglog("Exception in signing data by pkcs7!");
            throw new TsException("Exception in signing data by pkcs7!");
        }
    }

    public String timeStampResponse(byte[] toBeSignedBlob, boolean isAttachCert, long signMethod, int m_Iinitmodel, X509CertificateStructure strcSignCert, byte[] m_signPfx, byte[] m_signCertBytes, String m_keyType, String m_container, PrivateKey privateKey, byte[] privatekeyByte, P11Interface p11Impl) throws TsException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            HashUtil hashUtil = new HashUtil(this.applicationName);
            String base64P7Sign = null;
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(m_signCertBytes);
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                Certificate[] certs = new Certificate[]{oCert};
                TimeStamp ts = new TimeStamp(privateKey, certs, HashUtil.getHashAlg(this.applicationName));
                byte[] hashData = hashUtil.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), toBeSignedBlob);
                ts.update(hashData, 0, hashData.length);
                byte[] p7SignData = ts.getEncoded(isAttachCert);
                base64P7Sign = base64Util.BJS_EncodeBase64(p7SignData);
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                WrapCard wCard = new WrapCard();
                byte[] hashedData = wCard.sm3(toBeSignedBlob, null, null);
                X509CertificateStructure[] certs = new X509CertificateStructure[]{strcSignCert};
                CNTimeStamp cnTs = new CNTimeStamp(certs);
                cnTs.update(hashedData);
                byte[] p7SignedData = cnTs.getEncoded(privatekeyByte, isAttachCert);
                base64P7Sign = base64Util.BJS_EncodeBase64(p7SignedData);
            }
            return base64P7Sign;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing data by pkcs7!", e);
            this.debuglog("Exception in signing data by pkcs7!");
            throw new TsException("Exception in signing data by pkcs7!");
        }
    }

    public boolean verifyTimeStamp(String originalData, String beSignedBlob, byte[] cert, int m_Iinitmodel) throws TsException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] signData = base64Util.BJS_DecodeBase64(beSignedBlob);
            boolean verified = false;
            String hashAlg = TimeStampUtil.getTimeStampHash(signData);
            if (hashAlg.equals("SM3")) {
                CNTimeStamp ts = new CNTimeStamp(signData);
                verified = ts.verify(cert);
            } else {
                TimeStamp ts = new TimeStamp(signData);
                verified = ts.verify(cert);
            }
            return verified;
        }
        catch (Exception e) {
            this.errorlog("Exception in verify time stamp!", e);
            this.debuglog("Exception in verify time stamp!");
            throw new TsException("Exception in verify sign data by pkcs7!");
        }
    }

    public ArrayList getTimeStampInfo(String beSignedBlob, int m_Iinitmodel) throws Pkcs7DecodeException {
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] beSignedBlobByte = base64Util.BJS_DecodeBase64(beSignedBlob);
            ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(beSignedBlobByte));
            ASN1Sequence whole = (ASN1Sequence)derInputStream.readObject();
            if (whole == null) {
                return null;
            }
            DERTaggedObject tagObj = (DERTaggedObject)whole.getObjectAt(1);
            if (tagObj == null) {
                return null;
            }
            ASN1Sequence body = (ASN1Sequence)tagObj.getObject();
            if (body == null) {
                return null;
            }
            ASN1Set signerinfos = (ASN1Set)body.getObjectAt(1);
            if (signerinfos == null) {
                return null;
            }
            ASN1Sequence signerinfo = (ASN1Sequence)signerinfos.getObjectAt(0);
            if (signerinfo == null) {
                return null;
            }
            DERObjectIdentifier digest = (DERObjectIdentifier)signerinfo.getObjectAt(0);
            if (digest == null) {
                return null;
            }
            String hashAlgIdentifier = digest.toString();
            String hashAlg = "SHA1";
            if (hashAlgIdentifier.equals("1.3.14.3.2.26")) {
                hashAlg = "SHA1";
            } else if (hashAlgIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
                hashAlg = "SHA256";
            } else if (hashAlgIdentifier.contains("1.2.156.10197.1.401")) {
                hashAlg = "SM3";
            } else {
                return null;
            }
            ArrayList<String> infoList = new ArrayList<String>();
            byte[] p7signData = base64Util.BJS_DecodeBase64(beSignedBlob);
            PKCSObjectIdentifiers ts = null;
            ts = hashAlg.equals("SM3") ? new CNTimeStamp(p7signData) : new TimeStamp(p7signData);
            byte[] timeByte = ts.getTimeByte();
            String time = new String(timeByte);
            String formateTime = time.substring(0, 14);
            TimeZone defaultTZ = TimeZone.getDefault();
            TimeZone.setDefault(TimeZone.getTimeZone("Zulu"));
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = dateformat.parse(formateTime);
            dateformat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            String conversionTime = dateformat.format(date);
            TimeZone.setDefault(defaultTZ);
            infoList.add(conversionTime);
            byte[] originalHashByte = ts.getOriginalHashByte();
            String base64HashValue = base64Util.BJS_EncodeBase64(originalHashByte);
            infoList.add(base64HashValue);
            byte[] cert = ts.getSignCertByte();
            if (cert != null) {
                String base64Cert = base64Util.BJS_EncodeBase64(cert);
                infoList.add(base64Cert);
            } else {
                infoList.add(null);
            }
            String serialNumber = ts.getSerialNumber();
            infoList.add(serialNumber);
            infoList.add(hashAlg);
            return infoList;
        }
        catch (Exception e) {
            this.errorlog("Exception in decoding time stamp data!", e);
            this.debuglog("Exception in decoding time stamp data!");
            throw new Pkcs7DecodeException("Exception in decoding sign data by pkcs7!");
        }
    }

    public byte[] createTimeStampRequestByHashedData(byte[] originalData, int m_Iinitmodel, boolean isAttachCert) throws TsException {
        try {
            byte[] tsRequest = null;
            if (m_Iinitmodel == 7 || m_Iinitmodel == 8) {
                CNTimeStamp ts = new CNTimeStamp();
                tsRequest = ts.createRequest(originalData, isAttachCert);
            } else {
                TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
                tsqGenerator.setCertReq(isAttachCert);
                BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
                ASN1ObjectIdentifier hashAlg = TSPAlgorithms.SHA1;
                if (HashUtil.getHashAlg(this.applicationName).equals("SHA256")) {
                    hashAlg = TSPAlgorithms.SHA256;
                }
                TimeStampRequest request = tsqGenerator.generate(hashAlg, originalData, nonce);
                tsRequest = request.getEncoded();
            }
            return tsRequest;
        }
        catch (IOException e) {
            this.errorlog("Exception in create TimeStamp Request sign data By HashedData!", e);
            this.debuglog("Exception in create TimeStamp Request sign data By HashedData!");
            throw new TsException("Exception in create TimeStamp Request sign data By HashedData!");
        }
    }

    public byte[] getOriDateByTsRequest(byte[] tsRequest, int m_Iinitmodel) throws TsException {
        byte[] oriData = null;
        try {
            if (m_Iinitmodel == 4 || m_Iinitmodel == 6) {
                TimeStampRequest request = new TimeStampRequest(tsRequest);
                oriData = request.getMessageImprintDigest();
            } else if (m_Iinitmodel != 5 && (m_Iinitmodel == 7 || m_Iinitmodel == 8)) {
                ASN1InputStream requestStream = new ASN1InputStream(tsRequest);
                DERObject requestObj = requestStream.readObject();
                ASN1Sequence requestSeq = (ASN1Sequence)requestObj;
                ASN1Sequence originalHashDataContent = (ASN1Sequence)requestSeq.getObjectAt(1);
                DEROctetString oriString = (DEROctetString)originalHashDataContent.getObjectAt(1);
                oriData = oriString.getEncoded();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in getOriDateByTsRequest!", e);
            this.debuglog("Exception in getOriDateByTsRequest!");
            throw new TsException("Exception in getOriDateByTsRequest!");
        }
        return oriData;
    }

    public byte[] getTsResp(byte[] tsResp) {
        ASN1InputStream derInputStream = new ASN1InputStream(new ByteArrayInputStream(tsResp));
        ASN1Sequence whole = null;
        try {
            whole = (ASN1Sequence)derInputStream.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (whole == null) {
            return null;
        }
        ASN1Sequence tagObj = (ASN1Sequence)whole.getObjectAt(1);
        if (tagObj == null) {
            return null;
        }
        byte[] ts = null;
        try {
            ts = tagObj.getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static void main(String[] args) throws TsException {
        TimeStampUtil tUtil = new TimeStampUtil("");
        FileUtil fileUtil = new FileUtil("");
        byte[] req = fileUtil.readFile("C:\\Users\\wct\\Desktop\\tsssm2req");
        tUtil.getOriDateByTsRequest(req, 7);
        System.out.println("");
    }
}

