/*
 * Decompiled with CFR 0.152.
 */
package xjyb.bjca.org.multi.util.log;

import xjyb.bjca.org.apache.log4j.Layout;
import xjyb.bjca.org.apache.log4j.Level;
import xjyb.bjca.org.apache.log4j.Logger;
import xjyb.bjca.org.multi.util.exceptions.LoggerException;
import xjyb.bjca.org.multi.util.log.AbstractLogger;
import xjyb.bjca.org.multi.util.log.LoggerRes;
import xjyb.bjca.org.multi.util.log.MyPatternLayout;
import xjyb.bjca.org.multi.util.log.MyRollingFileAppender;

public class ErrorLogger
extends AbstractLogger {
    public ErrorLogger(LoggerRes p) throws LoggerException {
        this.createAccesslogger(p);
    }

    private void createAccesslogger(LoggerRes loggerres) throws LoggerException {
        if (loggerres.IsUseRemoteLogger()) {
            throw new LoggerException("Now We Can not Implement The Remote Logger");
        }
        this.logger = Logger.getLogger(loggerres.getLoggerName());
        this.logger.removeAllAppenders();
        MyPatternLayout layout = new MyPatternLayout();
        layout.SetHeader(loggerres.getHeader());
        layout.setConversionPattern("%-5p  [%d{yyyy-MM-dd HH:mm:ss S}] %m%n");
        MyRollingFileAppender da = null;
        try {
            da = new MyRollingFileAppender((Layout)layout, loggerres.getLogFile());
            da.setMaxBackupIndex(loggerres.getMaxBackUpIndex());
            da.setMaxFileSize(loggerres.getMaxFileSize());
            this.logger.addAppender(da);
            this.logger.setLevel(Level.INFO);
        }
        catch (Exception ex) {
            throw new LoggerException(ex);
        }
    }

    public void Log(String msg) {
        this.logger.info(msg);
    }

    public static void main(String[] args) throws Exception {
        LoggerRes res = new LoggerRes();
        res.setLogFile("errorLog.log");
        res.setMaxFileSize("1kb");
        res.setLoggerName("error");
        res.setMaxBackupIndex(3);
        res.setMaxFileSize("1kb");
        res.setHeader("#hytest");
        ErrorLogger logger = new ErrorLogger(res);
        int i = 0;
        while (i < 1000) {
            logger.Log("Sign  ok");
            ++i;
        }
    }
}

