/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.DigestUtil;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import org.bouncycastle.pqc.crypto.lms.LMOtsPublicKey;
import org.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import org.bouncycastle.pqc.crypto.lms.LMSException;
import org.bouncycastle.pqc.crypto.lms.LmsUtils;
import org.bouncycastle.pqc.crypto.lms.SeedDerive;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class LM_OTS {
    private static final short D_PBLC = -32640;
    private static final int ITER_K = 20;
    private static final int ITER_PREV = 23;
    private static final int ITER_J = 22;
    private static final int SEED_RANDOMISER_INDEX = -3;
    private static final int SEED_LEN = 32;
    private static final int MAX_HASH = 32;
    private static final short D_MESG = -32383;

    LM_OTS() {
    }

    public static int coef(byte[] byArray, int n, int n2) {
        int n3 = n * n2 / 8;
        int n4 = 8 / n2;
        int n5 = n2 * (~n & n4 - 1);
        int n6 = (1 << n2) - 1;
        return byArray[n3] >>> n5 & n6;
    }

    public static int cksm(byte[] byArray, int n, LMOtsParameters lMOtsParameters) {
        int n2 = 0;
        int n3 = lMOtsParameters.getW();
        int n4 = (1 << n3) - 1;
        for (int i = 0; i < n * 8 / lMOtsParameters.getW(); ++i) {
            n2 = n2 + n4 - LM_OTS.coef(byArray, i, lMOtsParameters.getW());
        }
        return n2 << lMOtsParameters.getLs();
    }

    public static LMOtsPublicKey lms_ots_generatePublicKey(LMOtsPrivateKey lMOtsPrivateKey) {
        byte[] byArray = LM_OTS.lms_ots_generatePublicKey(lMOtsPrivateKey.getParameter(), lMOtsPrivateKey.getI(), lMOtsPrivateKey.getQ(), lMOtsPrivateKey.getMasterSecret());
        return new LMOtsPublicKey(lMOtsPrivateKey.getParameter(), lMOtsPrivateKey.getI(), lMOtsPrivateKey.getQ(), byArray);
    }

    static byte[] lms_ots_generatePublicKey(LMOtsParameters lMOtsParameters, byte[] byArray, int n, byte[] byArray2) {
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        byte[] byArray3 = Composer.compose().bytes(byArray).u32str(n).u16str(-32640).padUntil(0, 22).build();
        digest.update(byArray3, 0, byArray3.length);
        Digest digest2 = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        byte[] byArray4 = Composer.compose().bytes(byArray).u32str(n).padUntil(0, 23 + digest2.getDigestSize()).build();
        SeedDerive seedDerive = new SeedDerive(byArray, byArray2, DigestUtil.getDigest(lMOtsParameters.getDigestOID()));
        seedDerive.setQ(n);
        seedDerive.setJ(0);
        int n2 = lMOtsParameters.getP();
        int n3 = lMOtsParameters.getN();
        int n4 = (1 << lMOtsParameters.getW()) - 1;
        for (int i = 0; i < n2; ++i) {
            seedDerive.deriveSeed(byArray4, i < n2 - 1, 23);
            Pack.shortToBigEndian((short)((short)i), (byte[])byArray4, (int)20);
            for (int j = 0; j < n4; ++j) {
                byArray4[22] = (byte)j;
                digest2.update(byArray4, 0, byArray4.length);
                digest2.doFinal(byArray4, 23);
            }
            digest.update(byArray4, 23, n3);
        }
        byte[] byArray5 = new byte[digest.getDigestSize()];
        digest.doFinal(byArray5, 0);
        return byArray5;
    }

    public static LMOtsSignature lm_ots_generate_signature(LMOtsPrivateKey lMOtsPrivateKey, byte[] byArray, boolean bl) {
        SeedDerive seedDerive;
        LMOtsParameters lMOtsParameters = lMOtsPrivateKey.getParameter();
        int n = lMOtsParameters.getN();
        int n2 = lMOtsParameters.getP();
        int n3 = lMOtsParameters.getW();
        byte[] byArray2 = new byte[n2 * n];
        byte[] byArray3 = new byte[32];
        if (!bl) {
            seedDerive = lMOtsPrivateKey.getDerivationFunction();
            seedDerive.setJ(-3);
            seedDerive.deriveSeed(byArray3, false);
        }
        seedDerive = lMOtsPrivateKey.getDerivationFunction();
        byte[] byArray4 = new byte[34];
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        if (!bl) {
            LmsUtils.byteArray(lMOtsPrivateKey.getI(), digest);
            LmsUtils.u32str(lMOtsPrivateKey.getQ(), digest);
            LmsUtils.u16str((short)-32383, digest);
            LmsUtils.byteArray(byArray3, digest);
            LmsUtils.byteArray(byArray, 0, byArray.length, digest);
            digest.doFinal(byArray4, 0);
        } else {
            System.arraycopy(byArray, 0, byArray4, 0, n);
        }
        int n4 = LM_OTS.cksm(byArray4, n, lMOtsParameters);
        byArray4[n] = (byte)(n4 >>> 8 & 0xFF);
        byArray4[n + 1] = (byte)n4;
        byte[] byArray5 = Composer.compose().bytes(lMOtsPrivateKey.getI()).u32str(lMOtsPrivateKey.getQ()).padUntil(0, 23 + n).build();
        seedDerive.setJ(0);
        for (int i = 0; i < n2; ++i) {
            Pack.shortToBigEndian((short)((short)i), (byte[])byArray5, (int)20);
            seedDerive.deriveSeed(byArray5, i < n2 - 1, 23);
            int n5 = LM_OTS.coef(byArray4, i, n3);
            for (int j = 0; j < n5; ++j) {
                byArray5[22] = (byte)j;
                digest.update(byArray5, 0, 23 + n);
                digest.doFinal(byArray5, 23);
            }
            System.arraycopy(byArray5, 23, byArray2, n * i, n);
        }
        return new LMOtsSignature(lMOtsParameters, byArray3, byArray2);
    }

    public static boolean lm_ots_validate_signature(LMOtsPublicKey lMOtsPublicKey, LMOtsSignature lMOtsSignature, byte[] byArray, boolean bl) throws LMSException {
        if (!lMOtsSignature.getType().equals(lMOtsPublicKey.getParameter())) {
            throw new LMSException("public key and signature ots types do not match");
        }
        return Arrays.areEqual(LM_OTS.lm_ots_validate_signature_calculate(lMOtsPublicKey.getParameter(), lMOtsPublicKey.getI(), lMOtsPublicKey.getQ(), lMOtsSignature, byArray, bl), lMOtsPublicKey.getK());
    }

    public static byte[] lm_ots_validate_signature_calculate(LMOtsParameters lMOtsParameters, byte[] byArray, int n, LMOtsSignature lMOtsSignature, byte[] byArray2, boolean bl) {
        byte[] byArray3 = lMOtsSignature.getC();
        byte[] byArray4 = lMOtsSignature.getY();
        byte[] byArray5 = new byte[34];
        if (bl) {
            System.arraycopy(byArray2, 0, byArray5, 0, lMOtsParameters.getN());
        } else {
            Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
            LmsUtils.byteArray(byArray, digest);
            LmsUtils.u32str(n, digest);
            LmsUtils.u16str((short)-32383, digest);
            LmsUtils.byteArray(byArray3, digest);
            LmsUtils.byteArray(byArray2, digest);
            digest.doFinal(byArray5, 0);
        }
        int n2 = lMOtsParameters.getN();
        int n3 = lMOtsParameters.getW();
        int n4 = lMOtsParameters.getP();
        int n5 = LM_OTS.cksm(byArray5, n2, lMOtsParameters);
        byArray5[n2] = (byte)(n5 >>> 8 & 0xFF);
        byArray5[n2 + 1] = (byte)n5;
        Digest digest = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        LmsUtils.byteArray(byArray, digest);
        LmsUtils.u32str(n, digest);
        LmsUtils.u16str((short)-32640, digest);
        byte[] byArray6 = Composer.compose().bytes(byArray).u32str(n).padUntil(0, 23 + n2).build();
        int n6 = (1 << n3) - 1;
        Digest digest2 = DigestUtil.getDigest(lMOtsParameters.getDigestOID());
        for (int i = 0; i < n4; ++i) {
            int n7;
            Pack.shortToBigEndian((short)((short)i), (byte[])byArray6, (int)20);
            System.arraycopy(byArray4, i * n2, byArray6, 23, n2);
            for (int j = n7 = LM_OTS.coef(byArray5, i, n3); j < n6; ++j) {
                byArray6[22] = (byte)j;
                digest2.update(byArray6, 0, 23 + n2);
                digest2.doFinal(byArray6, 23);
            }
            digest.update(byArray6, 23, n2);
        }
        byte[] byArray7 = new byte[n2];
        digest.doFinal(byArray7, 0);
        return byArray7;
    }
}

