/*
 * Decompiled with CFR 0.152.
 */
package com.hc.util;

import com.hc.pojo.CertParser;
import com.hc.util.Cipher;
import com.hc.util.HashUtil;
import com.hc.util.SM2;
import com.hc.util.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;
import sun.misc.BASE64Encoder;

public class SM2Utils {
    static {
        Provider _provider = Security.getProvider("BC");
        if (_provider == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static void generateKeyPair() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        System.out.println("\u516c\u94a5: " + Util.byteToHex(publicKey.getEncoded()));
        System.out.println("\u79c1\u94a5: " + Util.byteToHex(privateKey.toByteArray()));
        byte[] signdata = SM2Utils.Sm2Sign("123".getBytes(), key);
        System.out.println("\u5bc6\u6587: " + Base64.toBase64String(signdata));
        long res = SM2Utils.VerifybyPubKey("123".getBytes(), signdata, publicKey.getEncoded());
        if (res == 0L) {
            System.out.println("\u9a8c\u7b7e\u6210\u529f");
        } else {
            System.out.println("\u9a8c\u7b7e\u5931\u8d25");
        }
    }

    public static String encrypt(byte[] publicKey, byte[] data) throws IOException {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return String.valueOf(Util.byteToHex(c1.getEncoded())) + Util.byteToHex(source) + Util.byteToHex(c3);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        String data = Util.byteToHex(encryptedData);
        byte[] c1Bytes = Util.hexToByte(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = Util.hexToByte(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = Util.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }

    public static byte[] SM3digest(byte[] msg) {
        SM3Digest sm3step1 = new SM3Digest();
        sm3step1.update(msg, 0, msg.length);
        byte[] z = new byte[32];
        sm3step1.doFinal(z, 0);
        return z;
    }

    public static byte[] SM3digest(byte[] msg, byte[] sm2publickey) {
        String ID = "1234567812345678";
        int ENTL = 128;
        byte[] targets = new byte[4];
        targets[3] = (byte)(ENTL & 0xFF);
        targets[2] = (byte)(ENTL >> 8 & 0xFF);
        targets[1] = (byte)(ENTL >> 16 & 0xFF);
        targets[0] = (byte)(ENTL >>> 24);
        int bzlen = 210;
        byte[] bZ = new byte[bzlen];
        System.arraycopy(targets, 2, bZ, 0, 2);
        System.arraycopy(ID.getBytes(), 0, bZ, 2, ID.getBytes().length);
        System.arraycopy(SM2.Instance().ecc_a.toByteArray(), 1, bZ, 18, 32);
        System.arraycopy(SM2.Instance().ecc_b.toByteArray(), 0, bZ, 50, 32);
        System.arraycopy(SM2.Instance().ecc_gx.toByteArray(), 0, bZ, 82, 32);
        System.arraycopy(SM2.Instance().ecc_gy.toByteArray(), 1, bZ, 114, 32);
        System.arraycopy(sm2publickey, 0, bZ, 146, 64);
        SM3Digest sm3step1 = new SM3Digest();
        sm3step1.update(bZ, 0, bZ.length);
        byte[] z = new byte[32];
        sm3step1.doFinal(z, 0);
        SM3Digest sm3step2 = new SM3Digest();
        sm3step2.update(z, 0, z.length);
        byte[] p = msg;
        sm3step2.update(p, 0, p.length);
        byte[] md = new byte[32];
        sm3step2.doFinal(md, 0);
        return md;
    }

    public static long VerifybyPubKey(byte[] msg, byte[] signData, byte[] certPK) {
        BigInteger R;
        ECPoint x3y3;
        ECPoint x2y2;
        BigInteger t;
        BigInteger e;
        BigInteger s;
        BigInteger r;
        SM2 sm2ecp;
        ECPoint.Fp userKey;
        block9: {
            block8: {
                try {
                    byte[] certPKX = new byte[32];
                    byte[] certPKY = new byte[32];
                    System.out.println("VerifybyPubKey certPK " + Util.getHexString(certPK));
                    System.arraycopy(certPK, 0, certPKX, 0, 32);
                    System.arraycopy(certPK, 32, certPKY, 0, 32);
                    String strcertPKX = Util.byteToHex(certPKX);
                    String strcertPKY = Util.byteToHex(certPKY);
                    BigInteger biX = new BigInteger(strcertPKX, 16);
                    BigInteger biY = new BigInteger(strcertPKY, 16);
                    ECFieldElement.Fp x = new ECFieldElement.Fp(SM2.Instance().ecc_p, biX);
                    ECFieldElement.Fp y = new ECFieldElement.Fp(SM2.Instance().ecc_p, biY);
                    userKey = new ECPoint.Fp(SM2.Instance().ecc_curve, (ECFieldElement)x, (ECFieldElement)y, false);
                    if (userKey != null) break block8;
                    return -22L;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return -4L;
                }
            }
            byte[] md = SM2Utils.SM3digest(msg, certPK);
            System.out.println("VerifybyPubKey hash " + Util.getHexString(md));
            sm2ecp = SM2.Instance();
            byte[] btR = new byte[32];
            byte[] btS = new byte[32];
            System.arraycopy(signData, 32, btR, 0, 32);
            System.arraycopy(signData, 96, btS, 0, 32);
            String strR = Util.byteToHex(btR);
            String strS = Util.byteToHex(btS);
            System.out.println("VerifybyPubKey btR " + strR);
            System.out.println("VerifybyPubKey btS " + strS);
            r = new BigInteger(strR, 16);
            s = new BigInteger(strS, 16);
            e = new BigInteger(1, md);
            t = r.add(s).mod(sm2ecp.ecc_n);
            if (!t.equals(BigInteger.ZERO)) break block9;
            return -2L;
        }
        ECPoint x1y1 = sm2ecp.ecc_point_g.multiply(s);
        if (!x1y1.isNormalized()) {
            x1y1 = x1y1.normalize();
        }
        if (!(x2y2 = userKey.multiply(t)).isNormalized()) {
            x2y2 = x2y2.normalize();
        }
        if (!(x3y3 = x1y1.add(x2y2)).isNormalized()) {
            x3y3 = x3y3.normalize();
        }
        if (r.equals(R = e.add(x3y3.getXCoord().toBigInteger()).mod(sm2ecp.ecc_n))) {
            return 0L;
        }
        return -1L;
    }

    public static long Verify(byte[] msg, byte[] signData, byte[] certData) {
        BigInteger R;
        ECPoint x3y3;
        ECPoint x2y2;
        BigInteger t;
        BigInteger e;
        BigInteger s;
        BigInteger r;
        SM2 sm2ecp;
        ECPoint.Fp userKey;
        block12: {
            byte[] certPK;
            block11: {
                String strcertPKY;
                BigInteger biY;
                ECFieldElement.Fp y;
                String strcertPKX;
                BigInteger biX;
                ECFieldElement.Fp x;
                ASN1Encodable[] pubkeyrootarray;
                ASN1Sequence pubkeyrootSequence;
                CertParser cert;
                byte[] certPKY;
                byte[] certPKX;
                block10: {
                    try {
                        certPK = new byte[64];
                        certPKX = new byte[32];
                        certPKY = new byte[32];
                        cert = CertParser.getInstance(certData);
                        if (cert != null) break block10;
                        return -21L;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return -4L;
                    }
                }
                PublicKey pubkey = cert.getCert().getPublicKey();
                if (pubkey instanceof BCECPublicKey && (pubkeyrootSequence = (ASN1Sequence)ASN1Sequence.fromByteArray(pubkey.getEncoded())) != null && (pubkeyrootarray = pubkeyrootSequence.toArray()).length == 2) {
                    DERBitString key = (DERBitString)pubkeyrootarray[1];
                    System.arraycopy(key.getBytes(), 1, certPK, 0, 64);
                    System.arraycopy(certPK, 0, certPKX, 0, 32);
                    System.arraycopy(certPK, 32, certPKY, 0, 32);
                }
                if ((userKey = new ECPoint.Fp(SM2.Instance().ecc_curve, (ECFieldElement)(x = new ECFieldElement.Fp(SM2.Instance().ecc_p, biX = new BigInteger(strcertPKX = Util.byteToHex(certPKX), 16))), (ECFieldElement)(y = new ECFieldElement.Fp(SM2.Instance().ecc_p, biY = new BigInteger(strcertPKY = Util.byteToHex(certPKY), 16))), false)) != null) break block11;
                return -22L;
            }
            byte[] md = HashUtil.hashCert(msg, certPK);
            sm2ecp = SM2.Instance();
            byte[] btR = new byte[32];
            byte[] btS = new byte[32];
            System.arraycopy(signData, 32, btR, 0, 32);
            System.arraycopy(signData, 96, btS, 0, 32);
            String strR = Util.byteToHex(btR);
            String strS = Util.byteToHex(btS);
            r = new BigInteger(strR, 16);
            s = new BigInteger(strS, 16);
            e = new BigInteger(1, md);
            t = r.add(s).mod(sm2ecp.ecc_n);
            if (!t.equals(BigInteger.ZERO)) break block12;
            return -2L;
        }
        ECPoint x1y1 = sm2ecp.ecc_point_g.multiply(s);
        if (!x1y1.isNormalized()) {
            x1y1 = x1y1.normalize();
        }
        if (!(x2y2 = userKey.multiply(t)).isNormalized()) {
            x2y2 = x2y2.normalize();
        }
        if (!(x3y3 = x1y1.add(x2y2)).isNormalized()) {
            x3y3 = x3y3.normalize();
        }
        if (r.equals(R = e.add(x3y3.getXCoord().toBigInteger()).mod(sm2ecp.ecc_n))) {
            return 0L;
        }
        return -1L;
    }

    public static String subSignature(byte[] signature) {
        byte[] si;
        if (signature == null) {
            return null;
        }
        byte[] s = signature;
        if (signature.length != 70) {
            si = new byte[70];
            if (s[4] == 0 && s[39] == 0) {
                System.arraycopy(s, 0, si, 0, 4);
                System.arraycopy(s, 5, si, 4, 34);
                System.arraycopy(s, 40, si, 38, 32);
            } else if (s[4] == 0 && s[39] != 0) {
                System.arraycopy(s, 0, si, 0, 4);
                System.arraycopy(s, 5, si, 4, 66);
            } else if (s[4] != 0 && s[38] == 0) {
                System.arraycopy(s, 0, si, 0, 38);
                System.arraycopy(s, 39, si, 38, 32);
            } else if (s[2] == 2 && s[3] == 32 && s[36] == 2 && s[37] == 32) {
                System.arraycopy(s, 0, si, 0, 70);
            }
            signature = si;
        } else if (s[3] == 31) {
            si = new byte[70];
            System.arraycopy(s, 0, si, 0, 4);
            System.arraycopy(s, 4, si, 5, 31);
            System.arraycopy(s, 35, si, 36, 2);
            System.arraycopy(s, 38, si, 38, 32);
            signature = si;
        }
        byte[] b = new byte[128];
        Arrays.fill(b, 0, 31, (byte)0);
        System.arraycopy(signature, 4, b, 32, 32);
        Arrays.fill(b, 64, 95, (byte)0);
        System.arraycopy(signature, 38, b, 96, 32);
        BASE64Encoder base = new BASE64Encoder();
        String signBase = base.encode(b);
        return signBase;
    }

    public static String HNCASMP1toSM2P1(String hncasm2p1) {
        String res = "";
        byte[] signature = Base64.decode(hncasm2p1);
        if (signature == null) {
            return "";
        }
        byte[] br = new byte[32];
        byte[] bs = new byte[32];
        System.arraycopy(signature, 4, br, 0, 32);
        System.arraycopy(signature, 38, bs, 0, 32);
        ASN1Integer asn1r = new ASN1Integer(br);
        ASN1Integer asn1S = new ASN1Integer(bs);
        DLSequence rootSequence = new DLSequence(new ASN1Encodable[]{asn1r, asn1S});
        try {
            res = Base64.toBase64String(rootSequence.getEncoded());
        }
        catch (IOException e) {
            e.printStackTrace();
            res = "";
        }
        return res;
    }

    public static byte[] subSignatureEx(byte[] signature) {
        block11: {
            try {
                if (signature != null) break block11;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        byte[] s = signature;
        if (signature.length != 70) {
            byte[] si = new byte[70];
            if (s[4] == 0 && s[39] == 0) {
                System.arraycopy(s, 0, si, 0, 4);
                System.arraycopy(s, 5, si, 4, 34);
                System.arraycopy(s, 40, si, 38, 32);
            } else if (s[4] == 0 && s[39] != 0) {
                System.arraycopy(s, 0, si, 0, 4);
                System.arraycopy(s, 5, si, 4, 66);
            } else if (s[4] != 0 && s[38] == 0) {
                System.arraycopy(s, 0, si, 0, 38);
                System.arraycopy(s, 39, si, 38, 32);
            } else if (s[2] == 2 && s[3] == 32 && s[36] == 2 && s[37] == 32) {
                System.arraycopy(s, 0, si, 0, 70);
            }
            signature = si;
        }
        byte[] br = new byte[32];
        byte[] bs = new byte[32];
        System.arraycopy(signature, 4, br, 0, 32);
        System.arraycopy(signature, 38, bs, 0, 32);
        ASN1Integer asn1r = new ASN1Integer(br);
        ASN1Integer asn1S = new ASN1Integer(bs);
        DLSequence rootSequence = new DLSequence(new ASN1Encodable[]{asn1r, asn1S});
        return rootSequence.getEncoded();
    }

    public static byte[] Sm2Sign(byte[] md, AsymmetricCipherKeyPair keypair) {
        BigInteger da_1;
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        byte[] hashData = SM2Utils.SM3digest(md, publicKey.getEncoded());
        System.out.println("sign hash " + Util.getHexString(hashData));
        BigInteger e = new BigInteger(1, hashData);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger userD = null;
        BigInteger r = null;
        BigInteger s = null;
        Object temp = null;
        Object xy1 = null;
        SM2 sm2Info = new SM2();
        while (true) {
            k = ecpriv.getD();
            kp = ecpub.getQ();
            userD = ecpriv.getD();
            r = e.add(kp.getXCoord().toBigInteger());
            if ((r = r.mod(sm2Info.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(sm2Info.ecc_n)) continue;
            da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(sm2Info.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(sm2Info.ecc_n);
            if (!(s = da_1.multiply(s).mod(sm2Info.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        while (true) {
            k = ecpriv.getD();
            kp = ecpub.getQ();
            userD = ecpriv.getD();
            r = e.add(kp.getXCoord().toBigInteger());
            if ((r = r.mod(sm2Info.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(sm2Info.ecc_n)) continue;
            da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(sm2Info.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(sm2Info.ecc_n);
            if (!(s = da_1.multiply(s).mod(sm2Info.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        byte[] btRS = new byte[128];
        byte[] btR = r.toByteArray();
        byte[] btS = s.toByteArray();
        int i = 0;
        while (i < 32) {
            btRS[i] = 0;
            btRS[i + 32] = btR[btR.length - 32 + i];
            btRS[i + 64] = 0;
            btRS[i + 96] = btS[btS.length - 32 + i];
            ++i;
        }
        System.out.println("sign btRS " + Util.getHexString(btRS));
        System.out.println("sign btR " + Util.getHexString(btR));
        System.out.println("sign btS " + Util.getHexString(btS));
        return btRS;
    }

    public static void main(String[] args) throws Exception {
        String strSrc = "123";
        String strSignBase64 = "MEYCIQAi+Hq8UoBtZzI2/XV4uKcPVVMpCagNMSEPU9ym+w8V6AIhAGZakfjb0+Fy1XRURKpj9Aviuey+0atj3Nd7rOR2B1cH";
        strSignBase64 = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACCndd/eTocwcsUJ0DNvUb32yTzsYPOz3BAloxBu/J6yQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAnOImPSf62FkBoAYEqIVuEPCnAZ+IHbcJz+ztmBMEf7Q=";
        String strSignCertBase64 = "MIIDFDCCAregAwIBAgIQaPZ4g/9Rot0ay1GAHXu/ljAMBggqgRzPVQGDdQUAMGYxCzAJBgNVBAYTAkNOMQ4wDAYDVQQIDAVIZU5hbjESMBAGA1UEBwwJWmhlbmdaaG91MSQwIgYDVQQKDBtIZU5hbiBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxDTALBgNVBAMMBEhOQ0EwHhcNMTgxMTE1MDMwMjA3WhcNMTkxMTE0MDczMjQzWjB6MQswCQYDVQQGEwJDTjESMBAGA1UECAwJ5rKz5Y2X55yBMRIwEAYDVQQHDAnpg5Hlt57luIIxEjAQBgNVBAoMCeWNjua1izAwMTEPMA0GA1UECwwG56iO5YqhMR4wHAYDVQQDDBXmtYvor5XkuIvovb3ml7bop6Pnu5EwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT4trnyk8dggbHSeZk4N6SYsvUS1uvLRhoFMtefuZAV2af567iNAj2DadcOpgSAKnfd7cg3ISID7Tz7ErdK/qcxo4IBLzCCASswDgYDVR0PAQH/BAQDAgbAMB0GA1UdDgQWBBSR0YDj+QGK7bNCC1eEsZ4tCIELYzCBvQYDVR0fBIG1MIGyMDegNaAzpDEwLzELMAkGA1UEBhMCQ04xDzANBgNVBAsMBnNtMkNSTDEPMA0GA1UEAwwGY3JsMTMyMHegdaBzhnFsZGFwOi8vMjE4LjI4LjE2LjEwMTozODcvQ049Y3JsMTMyLE9VPXNtMkNSTCxDPUNOP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludDAZBggqgRzQFAQBAQQNMQugCRMHS9ULffbj0TAfBgNVHSMEGDAWgBR6pj/3IVLgM2jwQEoDNb90fRmwHjAMBggqgRzPVQGDdQUAA0kAMEYCIQDr++vZceAup25qCVQ2VF5hYUhFXqSE6nr/6eRll6x/6gIhANW1jjkO3CPQ+6khEzGJj8UBZdOuN/BaFvmjoHpba1kl";
        strSignBase64 = "MEUCIQCCMAVqFMF/WewUtPIshQVIkTXhgD1uLtimDg0JVwZvRQIgc2niy39y1xsNLpTIIPp8oYEQRxB1kurfmJACKN0wdl0=";
        strSignBase64 = SM2Utils.subSignature(Base64.decode(strSignBase64));
        strSignCertBase64 = "MIIC+jCCAp6gAwIBAgIQJTSx0A5FQ7LLkSzexh8XezAMBggqgRzPVQGDdQUAMGYxCzAJBgNVBAYTAkNOMQ4wDAYDVQQIDAVIZU5hbjESMBAGA1UEBwwJWmhlbmdaaG91MSQwIgYDVQQKDBtIZU5hbiBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxDTALBgNVBAMMBEhOQ0EwHhcNMjMwNDA0MDkxNDM3WhcNMjMxMDAzMTYwMDAwWjB+MQswCQYDVQQGEwJDTjESMBAGA1UECAwJ5rKz5Y2X55yBMRIwEAYDVQQHDAnlvIDlsIHluIIxEDAOBgNVBAoMB+a1i+ivlU8xETAPBgNVBAsMCOa1i+ivlU9VMSIwIAYDVQQDDBnmtYvor5Xnrb7lkI3pqoznrb4wNDA0MDAxMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE9qc56NrWOs0njpwdQQF8Z57r2PI6T9eBqpfFvwRBs7HxBY/7vVD9A7NiHfTWlXV0cqDK0ns0ULbaz4VFE7pRuqOCARIwggEOMAsGA1UdDwQEAwIGwDAfBgNVHSMEGDAWgBSF6SJCjmIZ2wSWAxIx3BGQ3w7GtTCBvgYDVR0fBIG2MIGzMDagNKAypDAwLjELMAkGA1UEBhMCQ04xDDAKBgNVBAsMA0NSTDERMA8GA1UEAwwIY3JsNTkxMjUweaB3oHWGc2xkYXA6Ly9sZGFwLmhuY2EuY29tLmNuOjM4Ny9DTj1jcmw1OTEyNSxPVT1DUkwsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwHQYDVR0OBBYEFPsiN1O3OMqn5gVMwVgWIv5OhezuMAwGCCqBHM9VAYN1BQADSAAwRQIgHQfRo6JbbK1Hk1nVZKgf9/hlHKJdaaMWLUIuSN8s8hECIQCvvh397vSNiF/WCPaVxb2YL3CV4BkVRkCXKoV1cR7+dg==";
        strSignBase64 = "MEQCICqrJmYb+9NF6GWhG1bsVmIa4w0++kMOENvQXEYYlTVPAiBxRxwVyNLhIt+m4ZV1HzRJBL135tFoHgMUYfmATGL6dQ==";
        strSignBase64 = SM2Utils.subSignature(Base64.decode(strSignBase64));
        strSignCertBase64 = "MIIDHzCCAsOgAwIBAgIQPl772iwJcbFrYo2OLIaxWTAMBggqgRzPVQGDdQUAMGYxCzAJBgNVBAYTAkNOMQ4wDAYDVQQIDAVIZU5hbjESMBAGA1UEBwwJWmhlbmdaaG91MSQwIgYDVQQKDBtIZU5hbiBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxDTALBgNVBAMMBEhOQ0EwHhcNMjMwMjI4MDIyMDAwWhcNMjQwMjI4MDIyMDAwWjCBojELMAkGA1UEBhMCQ04xEjAQBgNVBAgMCeaxn+iLj+ecgTESMBAGA1UEBwwJ5peg6ZSh5biCMSEwHwYDVQQKDBh0ZXN0KOeOr+Wig+ebkeaOp+S4reW/gykxKzApBgNVBAsMInRlc3Qo546v5aKD55uR5o6n5Lit5b+DKS0yMDIyMDMzNzgxGzAZBgNVBAMMEjEyMzIwNTgxNDY3MTI3MDA1SjBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABJY85mju5trok0Y+GZkP4GFsVN5yQrF9J3rdfG5TKFv2bTppUSH6wUV6PGF7S/i2jZ2WUN/OHevesFLz8q8Pm+KjggESMIIBDjALBgNVHQ8EBAMCBsAwHwYDVR0jBBgwFoAUhekiQo5iGdsElgMSMdwRkN8OxrUwgb4GA1UdHwSBtjCBszA2oDSgMqQwMC4xCzAJBgNVBAYTAkNOMQwwCgYDVQQLDANDUkwxETAPBgNVBAMMCGNybDU2NzAxMHmgd6B1hnNsZGFwOi8vbGRhcC5obmNhLmNvbS5jbjozODcvQ049Y3JsNTY3MDEsT1U9Q1JMLEM9Q04/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdD9iYXNlP29iamVjdGNsYXNzPWNSTERpc3RyaWJ1dGlvblBvaW50MB0GA1UdDgQWBBT84doGXdWAKk8640MEA/rVFs/d8jAMBggqgRzPVQGDdQUAA0gAMEUCIE/Adv63swoTsXsTDhxHVqJ/pHGAmx4havmp1in8Zo9oAiEA+nbTy1Q1CSTm9F+cL3f5J99pw39tLsLWt38tNYjxwOk=";
        strSignBase64 = "MEYCIQDeZ6JzBjWHMeQKMBN0OrME/yiBY2/yxLd4+CpbhJ460AIhALzL2Q1WS9x9SvCC8rPS+uDOkemR+6NSCzChM8h8kWhZ";
        strSignBase64 = SM2Utils.subSignature(Base64.decode(strSignBase64));
        strSignCertBase64 = "MIIDXTCCAwCgAwIBAgIQaoAASdNW8FmkY0Q35Ndx2TAMBggqgRzPVQGDdQUAMGYxCzAJBgNVBAYTAkNOMQ4wDAYDVQQIDAVIZU5hbjESMBAGA1UEBwwJWmhlbmdaaG91MSQwIgYDVQQKDBtIZU5hbiBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxDTALBgNVBAMMBEhOQ0EwHhcNMjMwMTMxMDYxNDI0WhcNMjQwMTMxMDYxNDI0WjCB2zELMAkGA1UEBhMCQ04xEjAQBgNVBAgMCeays+WNl+ecgTESMBAGA1UEBwwJ5byA5bCB5biCMUcwRQYDVQQKDD45MTQxMDEwMk1BOUgxNU5ZMjnkuK3np5Hog5zmjbco6YOR5beeKeWMu+eWl+aKgOacr+aciemZkOWFrOWPuDFCMEAGA1UECww55rKz5Y2X55yB5aSn5pWw5o2u5bGA55S15a2Q5Y2w56ug5pWw5a2X6K+B5Lmm6aG555uuNjg3MDIzMRcwFQYDVQQDDA40MTAyMDA2NDY3MjQwNTBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABAUvqQ/a9QFjsc2LpKL6xdw/bY8UGIX7lOviQJxBa77RJPfJApRSyIkqsTI7W2RJo5Y6S3eLNmGop4dOAhuTgImjggEWMIIBEjAOBgNVHQ8BAf8EBAMCBsAwHwYDVR0jBBgwFoAUeqY/9yFS4DNo8EBKAzW/dH0ZsB4wgb8GA1UdHwSBtzCBtDA4oDagNKQyMDAxCzAJBgNVBAYTAkNOMQ8wDQYDVQQLDAZzbTJDUkwxEDAOBgNVBAMMB2NybDQ2NzcweKB2oHSGcmxkYXA6Ly8yMTguMjguMTYuMTAxOjM4Ny9DTj1jcmw0Njc3LE9VPXNtMkNSTCxDPUNOP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludDAdBgNVHQ4EFgQUafWQBmwlJ2pj9qMiVrzJpt/YfG0wDAYIKoEcz1UBg3UFAANJADBGAiEAuFRdBYxdQinTsUAal+PYo4XdmQ66Wm48fz1WPVoieXQCIQC5n8pQoDNwpEn9CfAPFhAKRvkV3NqkYd/0QZ0YSEiC0g==";
        long res = SM2Utils.Verify(strSrc.getBytes(), Base64.decode(strSignBase64), Base64.decode(strSignCertBase64));
        if (res == 0L) {
            System.out.println("\u9a8c\u7b7e\u6210\u529f");
        } else {
            System.out.println("\u9a8c\u7b7e\u5931\u8d25");
        }
    }
}

