/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.operator.bc;

import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.Wrapper;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.operator.GenericKey;
import cn.org.bjca.gaia.operator.OperatorException;
import cn.org.bjca.gaia.operator.SymmetricKeyWrapper;
import cn.org.bjca.gaia.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        byte[] contentEncryptionKeySpec = OperatorUtils.getKeyBytes(encryptionKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(contentEncryptionKeySpec, 0, contentEncryptionKeySpec.length);
    }
}

