/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.operator.bc;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.crypto.params.KeyParameter;

class AESUtil {
    AESUtil() {
    }

    static AlgorithmIdentifier determineKeyEncAlg(KeyParameter key) {
        ASN1ObjectIdentifier wrapOid;
        int length = key.getKey().length * 8;
        if (length == 128) {
            wrapOid = NISTObjectIdentifiers.id_aes128_wrap;
        } else if (length == 192) {
            wrapOid = NISTObjectIdentifiers.id_aes192_wrap;
        } else if (length == 256) {
            wrapOid = NISTObjectIdentifiers.id_aes256_wrap;
        } else {
            throw new IllegalArgumentException("illegal keysize in AES");
        }
        return new AlgorithmIdentifier(wrapOid);
    }
}

