/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.provider.symmetric;

import cn.org.bjca.gaia.asn1.misc.MiscObjectIdentifiers;
import cn.org.bjca.gaia.crypto.PasswordConverter;
import cn.org.bjca.gaia.crypto.generators.SCrypt;
import cn.org.bjca.gaia.crypto.params.KeyParameter;
import cn.org.bjca.gaia.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BCPBEKey;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import cn.org.bjca.gaia.jcajce.provider.util.AlgorithmProvider;
import cn.org.bjca.gaia.jcajce.spec.ScryptKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SCRYPT {
    private SCRYPT() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = SCRYPT.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecretKeyFactory.SCRYPT", PREFIX + "$ScryptWithUTF8");
            provider.addAlgorithm("SecretKeyFactory", MiscObjectIdentifiers.id_scrypt, PREFIX + "$ScryptWithUTF8");
        }
    }

    public static class ScryptWithUTF8
    extends BasePBKDF2 {
        public ScryptWithUTF8() {
            super("SCRYPT", 5);
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;

        public BasePBKDF2(String name, int scheme) {
            super(name, MiscObjectIdentifiers.id_scrypt);
            this.scheme = scheme;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ScryptKeySpec) {
                ScryptKeySpec pbeSpec = (ScryptKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new IllegalArgumentException("Salt S must be provided.");
                }
                if (pbeSpec.getCostParameter() <= 1) {
                    throw new IllegalArgumentException("Cost parameter N must be > 1.");
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                KeyParameter param = new KeyParameter(SCrypt.generate(PasswordConverter.UTF8.convert(pbeSpec.getPassword()), pbeSpec.getSalt(), pbeSpec.getCostParameter(), pbeSpec.getBlockSize(), pbeSpec.getParallelizationParameter(), pbeSpec.getKeyLength() / 8));
                return new BCPBEKey(this.algName, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }
}

