/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.util;

import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.org.bjca.gaia.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import cn.org.bjca.gaia.asn1.edec.EdECObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.RSAPublicKey;
import cn.org.bjca.gaia.asn1.rosstandart.RosstandartObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.DSAParameter;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.asn1.x9.X962Parameters;
import cn.org.bjca.gaia.asn1.x9.X9ECParameters;
import cn.org.bjca.gaia.asn1.x9.X9ECPoint;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.DSAParameters;
import cn.org.bjca.gaia.crypto.params.DSAPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECGOST3410Parameters;
import cn.org.bjca.gaia.crypto.params.ECNamedDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.Ed25519PublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.Ed448PublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.RSAKeyParameters;
import cn.org.bjca.gaia.crypto.params.X25519PublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.X448PublicKeyParameters;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class SubjectPublicKeyInfoFactory {
    private static Set cryptoProOids = new HashSet(5);

    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof RSAKeyParameters) {
            RSAKeyParameters pub = (RSAKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(pub.getModulus(), pub.getExponent()));
        }
        if (publicKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)publicKey;
            DSAParameter params = null;
            DSAParameters dsaParams = pub.getParameters();
            if (dsaParams != null) {
                params = new DSAParameter(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, params), new ASN1Integer(pub.getY()));
        }
        if (publicKey instanceof ECPublicKeyParameters) {
            X962Parameters params;
            ECPublicKeyParameters pub = (ECPublicKeyParameters)publicKey;
            ECDomainParameters domainParams = pub.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                if (domainParams instanceof ECGOST3410Parameters) {
                    ASN1ObjectIdentifier algIdentifier;
                    int offset;
                    int encKeySize;
                    ECGOST3410Parameters gostParams = (ECGOST3410Parameters)domainParams;
                    BigInteger bX = pub.getQ().getAffineXCoord().toBigInteger();
                    BigInteger bY = pub.getQ().getAffineYCoord().toBigInteger();
                    GOST3410PublicKeyAlgParameters params2 = new GOST3410PublicKeyAlgParameters(gostParams.getPublicKeyParamSet(), gostParams.getDigestParamSet());
                    if (cryptoProOids.contains(gostParams.getPublicKeyParamSet())) {
                        encKeySize = 64;
                        offset = 32;
                        algIdentifier = CryptoProObjectIdentifiers.gostR3410_2001;
                    } else {
                        boolean is512;
                        boolean bl = is512 = bX.bitLength() > 256;
                        if (is512) {
                            encKeySize = 128;
                            offset = 64;
                            algIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512;
                        } else {
                            encKeySize = 64;
                            offset = 32;
                            algIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
                        }
                    }
                    byte[] encKey = new byte[encKeySize];
                    SubjectPublicKeyInfoFactory.extractBytes(encKey, encKeySize / 2, 0, bX);
                    SubjectPublicKeyInfoFactory.extractBytes(encKey, encKeySize / 2, offset, bY);
                    try {
                        return new SubjectPublicKeyInfo(new AlgorithmIdentifier(algIdentifier, params2), new DEROctetString(encKey));
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                if (domainParams instanceof ECNamedDomainParameters) {
                    params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
                } else {
                    X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                    params = new X962Parameters(ecP);
                }
            }
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(pub.getQ()).toASN1Primitive();
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        }
        if (publicKey instanceof X448PublicKeyParameters) {
            X448PublicKeyParameters key = (X448PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), key.getEncoded());
        }
        if (publicKey instanceof X25519PublicKeyParameters) {
            X25519PublicKeyParameters key = (X25519PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), key.getEncoded());
        }
        if (publicKey instanceof Ed448PublicKeyParameters) {
            Ed448PublicKeyParameters key = (Ed448PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), key.getEncoded());
        }
        if (publicKey instanceof Ed25519PublicKeyParameters) {
            Ed25519PublicKeyParameters key = (Ed25519PublicKeyParameters)publicKey;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), key.getEncoded());
        }
        throw new IOException("key parameters not recognized");
    }

    private static void extractBytes(byte[] encKey, int size, int offSet, BigInteger bI) {
        byte[] val2 = bI.toByteArray();
        if (val2.length < size) {
            byte[] tmp = new byte[size];
            System.arraycopy(val2, 0, tmp, tmp.length - val2.length, val2.length);
            val2 = tmp;
        }
        for (int i = 0; i != size; ++i) {
            encKey[offSet + i] = val2[val2.length - 1 - i];
        }
    }

    static {
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

