/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.crypto.tls;

import cn.org.bjca.gaia.crypto.agreement.DHStandardGroups;
import cn.org.bjca.gaia.crypto.params.DHParameters;
import cn.org.bjca.gaia.crypto.tls.AbstractTlsServer;
import cn.org.bjca.gaia.crypto.tls.TlsCipherFactory;
import cn.org.bjca.gaia.crypto.tls.TlsCredentials;
import cn.org.bjca.gaia.crypto.tls.TlsDHEKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsDHKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsECDHEKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsECDHKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsEncryptionCredentials;
import cn.org.bjca.gaia.crypto.tls.TlsFatalAlert;
import cn.org.bjca.gaia.crypto.tls.TlsKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsRSAKeyExchange;
import cn.org.bjca.gaia.crypto.tls.TlsSignerCredentials;
import cn.org.bjca.gaia.crypto.tls.TlsUtils;
import java.io.IOException;

public abstract class DefaultTlsServer
extends AbstractTlsServer {
    public DefaultTlsServer() {
    }

    public DefaultTlsServer(TlsCipherFactory cipherFactory) {
        super(cipherFactory);
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49200, 49199, 49192, 49191, 49172, 49171, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47};
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 3: {
                return this.getDSASignerCredentials();
            }
            case 11: 
            case 20: {
                return null;
            }
            case 17: {
                return this.getECDSASignerCredentials();
            }
            case 5: 
            case 19: {
                return this.getRSASignerCredentials();
            }
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(keyExchangeAlgorithm);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(keyExchangeAlgorithm);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) {
        return new TlsDHKeyExchange(keyExchange, this.supportedSignatureAlgorithms, null, this.getDHParameters());
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) {
        return new TlsDHEKeyExchange(keyExchange, this.supportedSignatureAlgorithms, null, this.getDHParameters());
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) {
        return new TlsECDHKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) {
        return new TlsECDHEKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

