/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cert.jcajce;

import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cert.X509ContentVerifierProviderBuilder;
import cn.org.bjca.gaia.operator.ContentVerifierProvider;
import cn.org.bjca.gaia.operator.OperatorCreationException;
import cn.org.bjca.gaia.operator.jcajce.JcaContentVerifierProviderBuilder;
import java.security.Provider;
import java.security.cert.CertificateException;

public class JcaX509ContentVerifierProviderBuilder
implements X509ContentVerifierProviderBuilder {
    private JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();

    public JcaX509ContentVerifierProviderBuilder setProvider(Provider provider) {
        this.builder.setProvider(provider);
        return this;
    }

    public JcaX509ContentVerifierProviderBuilder setProvider(String providerName) {
        this.builder.setProvider(providerName);
        return this;
    }

    @Override
    public ContentVerifierProvider build(SubjectPublicKeyInfo validatingKeyInfo) throws OperatorCreationException {
        return this.builder.build(validatingKeyInfo);
    }

    @Override
    public ContentVerifierProvider build(X509CertificateHolder validatingKeyInfo) throws OperatorCreationException {
        try {
            return this.builder.build(validatingKeyInfo);
        }
        catch (CertificateException e) {
            throw new OperatorCreationException("Unable to process certificate: " + e.getMessage(), e);
        }
    }
}

