/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.structure;

import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DLSequence;
import cn.org.bjca.gaia.util.encoders.Hex;
import java.io.IOException;

public class SM2Cipher
extends ASN1Object {
    private final ASN1Sequence seq;
    private final ASN1Integer x;
    private final ASN1Integer y;
    private final DEROctetString hash;
    private final DEROctetString cipherText;

    public SM2Cipher(byte[] encoded) throws IOException {
        DLSequence sm2Cipher = (DLSequence)ASN1Primitive.fromByteArray(encoded);
        this.x = (ASN1Integer)sm2Cipher.getObjectAt(0);
        this.y = (ASN1Integer)sm2Cipher.getObjectAt(1);
        this.hash = (DEROctetString)sm2Cipher.getObjectAt(2);
        this.cipherText = (DEROctetString)sm2Cipher.getObjectAt(3);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.x);
        v.add(this.y);
        v.add(this.hash);
        v.add(this.cipherText);
        this.seq = new DERSequence(v);
    }

    public SM2Cipher(ASN1Integer x, ASN1Integer y, DEROctetString hash, DEROctetString cipherText) {
        if (hash.getOctets().length != 32) {
            throw new IllegalArgumentException("hash length must be 32");
        }
        this.x = x;
        this.y = y;
        this.hash = hash;
        this.cipherText = cipherText;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(x);
        v.add(y);
        v.add(hash);
        v.add(cipherText);
        this.seq = new DERSequence(v);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.seq.getEncoded();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }

    public ASN1Integer getX() {
        return this.x;
    }

    public ASN1Integer getY() {
        return this.y;
    }

    public DEROctetString getHash() {
        return this.hash;
    }

    public DEROctetString getCipherText() {
        return this.cipherText;
    }

    public String toString() {
        return "SM2Cipher{x=" + Hex.toHexString(this.x.getValue().toByteArray()) + ", y=" + Hex.toHexString(this.y.getValue().toByteArray()) + ", hash=" + Hex.toHexString(this.hash.getOctets()) + ", cipherText=" + Hex.toHexString(this.cipherText.getOctets()) + '}';
    }

    public static void main(String[] args) throws IOException {
        String sm2Cipher = "307A022100A753C74705C3968F98F614BF99ACE2E8F2103B1CBDBA3728AA8912AF96AA5309022100CD0D6D27D5DB916C4FCBA3E3A5E5A9AA14746811DEAF5DF5FAD7670948C87C910420410DBD2F30AF21FE094285B557D95695864949E0D4DA7EE7BD2B82EEB00BC3A90410B25E0A4673E51B5C998D76D0566B4A24";
        SM2Cipher sm2Cipher1 = new SM2Cipher(Hex.decode(sm2Cipher));
        System.out.println(sm2Cipher.equalsIgnoreCase(Hex.toHexString(sm2Cipher1.seq.getEncoded()).toUpperCase()));
        System.out.println(Hex.toHexString(sm2Cipher1.seq.getEncoded()).toUpperCase());
    }
}

