/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.asn1.cmc;

import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERUTF8String;
import cn.org.bjca.gaia.asn1.cmc.BodyPartID;
import cn.org.bjca.gaia.asn1.cmc.CMCFailInfo;
import cn.org.bjca.gaia.asn1.cmc.CMCStatus;
import cn.org.bjca.gaia.asn1.cmc.CMCStatusInfo;
import cn.org.bjca.gaia.asn1.cmc.PendInfo;

public class CMCStatusInfoBuilder {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private DERUTF8String statusString;
    private CMCStatusInfo.OtherInfo otherInfo;

    public CMCStatusInfoBuilder(CMCStatus cMCStatus, BodyPartID bodyPartID) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence(bodyPartID);
    }

    public CMCStatusInfoBuilder(CMCStatus cMCStatus, BodyPartID[] bodyList) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence(bodyList);
    }

    public CMCStatusInfoBuilder setStatusString(String statusString) {
        this.statusString = new DERUTF8String(statusString);
        return this;
    }

    public CMCStatusInfoBuilder setOtherInfo(CMCFailInfo failInfo) {
        this.otherInfo = new CMCStatusInfo.OtherInfo(failInfo);
        return this;
    }

    public CMCStatusInfoBuilder setOtherInfo(PendInfo pendInfo) {
        this.otherInfo = new CMCStatusInfo.OtherInfo(pendInfo);
        return this;
    }

    public CMCStatusInfo build() {
        return new CMCStatusInfo(this.cMCStatus, this.bodyList, this.statusString, this.otherInfo);
    }
}

