/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.alibaba.fastjson.JSONObject;
import com.dianju.cz.api.EVoucherFileUtil;
import com.dianju.cz.base.Response;
import com.dianju.cz.entity.VerifyVO;
import com.dianju.cz.entity.VoucherFileInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class TestJar {
    private static final Logger log = Logger.getLogger(TestJar.class.toString());
    private static Map<Integer, String> map = new HashMap(){
        {
            this.put(1, "inv_ord_issuer");
            this.put(2, "inv_ord_receiver");
            this.put(3, "inv_spcl_issuer");
            this.put(4, "inv_spcl_receiver");
            this.put(5, "inv_tlf_issuer");
            this.put(6, "inv_tlf_receiver");
            this.put(7, "ntrev_gpm_issuer");
            this.put(8, "ntrev_gpm_receiver");
            this.put(9, "rai_issuer");
            this.put(10, "rai_receiver");
            this.put(11, "atr_issuer");
            this.put(12, "atr_receiver");
            this.put(13, "bker_issuer");
            this.put(14, "bker_receiver");
            this.put(15, "bkrs");
            this.put(16, "efi");
            this.put(17, "einv_ord_receiver");
            this.put(18, "einv_spcl_receiver");
        }
    };

    public static void main(String[] args) throws IOException {
        String dir = "/data/verifyFile";
        String soPath = "/data/libautoseal.so";
        EVoucherFileUtil.setSrvSealUtil(soPath);
        TestJar.test(dir);
    }

    public static void test(String dir) throws IOException {
        File[] files;
        for (File f : files = new File(dir).listFiles()) {
            if (!f.getAbsolutePath().endsWith(".pdf") && !f.getAbsolutePath().endsWith(".ofd")) continue;
            String fileName = f.getName();
            log.info("=====BEGIN=====================" + fileName + "============================");
            Response<String> verifyFileRet = EVoucherFileUtil.verifyFile(f.getAbsolutePath());
            if (verifyFileRet.getCode() == 1) {
                log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010verifyFile\u3011:" + verifyFileRet);
            } else {
                log.info("\u3010" + fileName + "\u3011 \u3010 Error \u3011 \u3010verifyFile\u3011:" + verifyFileRet);
            }
            VerifyVO verifyVO = EVoucherFileUtil.djVerifyFileWithInfo(f.getAbsolutePath());
            if (verifyVO.getAllPass()) {
                log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010verifyFileWithInfo\u3011:" + verifyVO.getVerifyInfos() + "===>" + JSONObject.toJSONString(verifyVO));
            } else {
                log.info("\u3010" + fileName + "\u3011 \u3010 Error \u3011 \u3010verifyFileWithInfo\u3011:" + JSONObject.toJSONString(verifyVO));
            }
            String xbrl = "";
            String voucherType = "";
            Response<?> getXbrlRet = EVoucherFileUtil.getXbrlFromFile(f.getAbsolutePath());
            if (getXbrlRet.getCode() == 1) {
                VoucherFileInfo info = (VoucherFileInfo)getXbrlRet.getData();
                voucherType = info.getVoucherType();
                xbrl = info.getXbrlData();
                log.info("xbrlVoucherType:" + voucherType);
                log.info("GetXbrlSize:" + info.getXbrlDataSize());
                for (int i = 0; i < info.getXbrlList().size(); ++i) {
                    String xbrlData = info.getXbrlList().get(i);
                    if (!xbrlData.startsWith("<")) {
                        log.info("GetXbrl {}" + getXbrlRet.getData());
                        throw new RuntimeException("error");
                    }
                    log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010getXbrlFromFile\u3011\u3010" + i + "\u3011:" + xbrlData.replace("\r", "").replace("\n", ""));
                }
            } else {
                log.info("\u3010" + fileName + "\u3011 \u3010 Error \u3011 \u3010getXbrlFromFile\u3011: " + getXbrlRet);
                log.info("=====END========================" + fileName + "===========================");
                continue;
            }
            Response<String> stringResponse = EVoucherFileUtil.exportXbrlFromFile(f.getAbsolutePath(), f.getAbsolutePath() + "_xbrl");
            if (stringResponse.getCode() == 1) {
                log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010export xbrl\u3011 ok! " + stringResponse.getData());
            } else {
                log.info("\u3010" + fileName + "\u3011 \u3010Error\u3011 \u3010export xbrl\u3011" + stringResponse);
            }
            String json = "";
            try {
                json = EVoucherFileUtil.xbrl2Json(xbrl, voucherType).toJSONString();
                if ("{}".equals(json)) {
                    log.info("\u3010" + fileName + "\u3011 type: " + voucherType + " not match");
                } else {
                    log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010xbrl => json\u3011 ok! type is " + voucherType);
                }
            }
            catch (Exception e) {
                int type = 0;
                while (type <= 18) {
                    try {
                        json = EVoucherFileUtil.xbrl2Json(xbrl, map.get(++type)).toJSONString();
                        if ("{}".equals(json)) {
                            throw new RuntimeException("\u3010" + fileName + "\u3011 type: " + map.get(type) + " not match");
                        }
                        log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010xbrl => json\u3011 ok! type is " + map.get(type));
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                log.info("=====END========================" + fileName + "===========================");
                continue;
            }
            if ("{}".equals(json)) {
                log.info("\u3010" + fileName + "\u3011 \u3010Error\u3011type: " + voucherType + " not match , to JSON Failed");
            } else {
                log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010xml => json\u3011 ok " + json);
            }
            try {
                String s = EVoucherFileUtil.json2Xbrl(json, voucherType);
                if (s.startsWith("<")) {
                    log.info("\u3010" + fileName + "\u3011 \u3010Success\u3011 \u3010json => xbrl\u3011 ok!");
                }
            }
            catch (Exception e) {
                log.info("\u3010" + fileName + "\u3011  \u3010Error\u3011 \u3010json => xml\u3011 error!");
            }
            log.info("=====END========================" + fileName + "===========================");
        }
        boolean xmlAndSign = EVoucherFileUtil.verifyXmlAndSign("MIIKBgYKKoEcz1UGAQQCAqCCCfYwggnyAgEBMQ8wDQYJKoEcz1UBgxECBQAwDAYKKoEcz1UGAQQCAaCCAuAwggLcMIICgKADAgECAhIgBx6kZOONc2JlcVwSD1mMOCUwDAYIKoEcz1UBg3UFADBBMQswCQYDVQQGEwJDTjENMAsGA1UECwwEU0dDQzEjMCEGA1UEAwwaU00yLVNFQ09ORC1URVNUKOWklua1i+ivlSkwHhcNMjIwNDA3MDIyNjM3WhcNMjMwNDA3MDIyNjM3WjARMQ8wDQYDVQQDDAblm73nvZEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARlZ/ze9A2cnPGuN3Uk+pY0frhDzBE89DkKYOXQPq+gb1Mi96BSJNEwtRbKxb9qI3mEUotb4jqjdZAsdoZUEelCo4IBhDCCAYAwCwYDVR0PBAQDAgbAMAkGA1UdEwQCMAAwgZ8GA1UdHwSBlzCBlDBEoEKgQIY+aHR0cDovLzE3Mi4xNy4yNi4xNjo5MDkwL2NybC9TTTJTRUNPTkRURVNUL1NNMlNFQ09ORFRFU1RfMC5jcmwwTKBKoEiGRmh0dHA6Ly8xNzIuMTcuMjYuMTY6OTA5MC9jcmwvU00yU0VDT05EVEVTVC9pbmMvU00yU0VDT05EVEVTVF9pbmNfMC5jcmwwHQYDVR0OBBYEFKeU6Vz5yf3onTMFH4tXZ6rlxhf9MB8GA1UdIwQYMBaAFJpG/+tGphIETUVyj2mj3ZvpGLmDMFoGA1UdIARTMFEwTwYKKoEchu8yBgQBATBBMD8GCCsGAQUFBwIBFjNodHRwOi8vMTcyLjE3LjI2LjE2OjkwOTAvY3BzL1NNMlNFQ09ORFRFU1QvY3BzLmh0bWwwEgYKKoEchu8yAgEBDAQEaG9zdDAUBgoqgRyG7zICAQENBAYwMDAxMDAwDAYIKoEcz1UBg3UFAANIADBFAiBwyUdC1tqHrpl6sSWTYFewsAjPmpgQBpVcn0YLkXwy3wIhAMEZf8NN8ne5XSTeKXqUOwsB8R7bEKtggbnlIbdvQc9WMYIG6DCCBuQCAQEwVzBBMQswCQYDVQQGEwJDTjENMAsGA1UECwwEU0dDQzEjMCEGA1UEAwwaU00yLVNFQ09ORC1URVNUKOWklua1i+ivlSkCEiAHHqRk441zYmVxXBIPWYw4JTANBgkqgRzPVQGDEQIFADANBgkqgRzPVQGCLQEFAARHMEUCIGK/q9+hQYFddIr6k3kQwh9o2iJL8mTUcVwErChSayyuAiEA28Go/IbXDK8h4LBsl6UP+kT2I7WaSFiUDc3eV7qej3ChggYdMIIGGQYLKoZIhvcNAQkQAg4xggYIMIIGBAYKKoEcz1UGAQQCAqCCBfQwggXwAgEBMQ8wDQYJKoEcz1UBgxEBBQAwZgYLKoZIhvcNAQkQAQSgVwRVMFMCAQEGCCsGAQUFBwMIMC0GCSqBHM9VAYMRAQQgfv9E/oZ7fyqlX7lDhTXWJs7x0dHDFjnAzcnJpmzQqAICBAX14QEYDzIwMjIwNDA3MTMyMjU0WqCCBD4wggQ6MIID4KADAgECAgoaEAAAAAAAyOHaMAoGCCqBHM9VAYN1MEQxCzAJBgNVBAYTAkNOMQ0wCwYDVQQKDARCSkNBMQ0wCwYDVQQLDARCSkNBMRcwFQYDVQQDDA5CZWlqaW5nIFNNMiBDQTAeFw0xODA5MjcxNjAwMDBaFw0yODA5MjgxNTU5NTlaMIGPMQwwCgYDVQQpDAPml6AxGzAZBgNVBAMMEuiuvuWkh+m7mOiupOivgeS5pjENMAsGA1UECwwERFNWUzENMAsGA1UECgwEQkpDQTESMBAGA1UECgwJQkpDQUNsb3VkMREwDwYDVQQHDAggQmVpSmluZzEQMA4GA1UECAwHQmVpSmluZzELMAkGA1UEBgwCQ04wWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARZMVg6rv5zrZK+3HuZRZceUt9kjfBhSkm7viqYOIuaOORQc2Addfb4Lze1Ed75OjjG4k6oMNBnwTdgOjhYHk4Oo4ICbDCCAmgwHwYDVR0jBBgwFoAUH+bP1I/FIiqXSimKFecWyZI0xLYwHQYDVR0OBBYEFJSL1w7VKflV+pEIC5CPVgEWZuU9MAsGA1UdDwQEAwIGwDCBnQYDVR0fBIGVMIGSMGCgXqBcpFowWDELMAkGA1UEBhMCQ04xDTALBgNVBAoMBEJKQ0ExDTALBgNVBAsMBEJKQ0ExFzAVBgNVBAMMDkJlaWppbmcgU00yIENBMRIwEAYDVQQDEwljYTIxY3JsNjcwLqAsoCqGKGh0dHA6Ly9jcmwuYmpjYS5vcmcuY24vY3JsL2NhMjFjcmw2Ny5jcmwwFQYKKoEchu8yAgEBAQQHDAVKSuaXoDBgBggrBgEFBQcBAQRUMFIwIwYIKwYBBQUHMAGGF09DU1A6Ly9vY3NwLmJqY2Eub3JnLmNuMCsGCCsGAQUFBzAChh9odHRwOi8vY3JsLmJqY2Eub3JnLmNuL2NhaXNzdWVyMEAGA1UdIAQ5MDcwNQYJKoEchu8yAgIBMCgwJgYIKwYBBQUHAgEWGmh0dHA6Ly93d3cuYmpjYS5vcmcuY24vY3BzMBEGCWCGSAGG+EIBAQQEAwIA/zATBgoqgRyG7zICAQEIBAUMA+aXoDAVBgoqgRyG7zICAQICBAcMBUpK5pegMB8GCiqBHIbvMgIBAQ4EEQwPMTAyMDAwMDEyMTc0Njk5MBUGCiqBHIbvMgIBAQQEBwwFSkrml6AwHwYKKoEchu8yAgEBFwQRDA81N0AyMTUwMDlKSjDml6AwEQYIKoEc0BQEAQQEBQwD5pegMBMGCiqBHIbvMgIBAR4EBQwDNjU0MAoGCCqBHM9VAYN1A0gAMEUCICR06BoIYcsHbdUwq0gpPDPGL68HH6MF4lwwVrx77yqxAiEA6R/KW3RfOFgqKISuWNAKGLBiczxMg4R4KSOcLSUUVCQxggEuMIIBKgIBATBSMEQxCzAJBgNVBAYTAkNOMQ0wCwYDVQQKDARCSkNBMQ0wCwYDVQQLDARCSkNBMRcwFQYDVQQDDA5CZWlqaW5nIFNNMiBDQQIKGhAAAAAAAMjh2jAMBggqgRzPVQGDEQUAoGswGgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMjA0MDcxMzIyNTRaMC8GCSqGSIb3DQEJBDEiBCADpXy2Lsa3ZI8K7g0fIbNy2SxPCUQPeORf55CNLJ1hyzANBgkqgRzPVQGCLQEFAARHMEUCIQD9/aPcWgXzYniI2mvdG4qf6SqU0DrOxfex+w4mqJSr2QIgJfujQukTQ816kqWKzcAo+iN8y9AotNLNxVbfIB9LrQg=", "<xbrl xmlns=\"http://www.xbrl.org/2003/instance\" xmlns:num=\"http://www.xbrl.org/dtr/type/numeric\" xmlns:link=\"http://www.xbrl.org/2003/linkbase\" xmlns:iso4217=\"http://www.xbrl.org/2003/iso4217\" xmlns:xbrldt=\"http://xbrl.org/2005/xbrldt\" xmlns:label=\"http://xbrl.org/2008/label\" xmlns:xbrli=\"http://www.xbrl.org/2003/instance\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:inv=\"http://xbrl.mof.gov.cn/taxonomy/2021-09-30/inv\" xmlns:gen=\"http://xbrl.org/2008/generic\" xmlns:xl=\"http://www.xbrl.org/2003/XLink\" xmlns:xbrldi=\"http://xbrl.org/2006/xbrldi\" xmlns:nonnum=\"http://www.xbrl.org/dtr/type/non-numeric\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.xbrl.org/2003/linkbase http://www.xbrl.org/2003/xbrl-linkbase-2003-12-31.xsd\"><link:schemaRef xlink:type=\"simple\" xlink:href=\"inv_issuer_entry_point_2021-09-30.xsd\"/><context id=\"As_Of_2022_03_18\"><entity><identifier scheme=\"http://xbrl.mof.gov.cn\">91440478707956364B</identifier></entity><period><instant>2022-03-18</instant></period></context><unit id=\"CNY\"><measure>iso4217:CNY</measure></unit><inv:TypeOfInvoice contextRef=\"As_Of_2022_03_18\">\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968</inv:TypeOfInvoice><inv:UniqueCodeOfInvoice contextRef=\"As_Of_2022_03_18\">03300210061651919106</inv:UniqueCodeOfInvoice><inv:LocationOfInvoice contextRef=\"As_Of_2022_03_18\">\u6d59\u6c5f</inv:LocationOfInvoice><inv:CodeOfInvoice contextRef=\"As_Of_2022_03_18\">033002100616</inv:CodeOfInvoice><inv:NumberOfInvoice contextRef=\"As_Of_2022_03_18\">51919106</inv:NumberOfInvoice><inv:DateOfIssue contextRef=\"As_Of_2022_03_18\">2022-03-18</inv:DateOfIssue><inv:IdentifyingCode contextRef=\"As_Of_2022_03_18\">03943706890551280313</inv:IdentifyingCode><inv:NumberOfInvoiceMachine contextRef=\"As_Of_2022_03_18\">499099261999</inv:NumberOfInvoiceMachine><inv:NameOfPurchaser contextRef=\"As_Of_2022_03_18\">\u6d59\u6c5fXX\u8d2d\u4e70\u4eba</inv:NameOfPurchaser><inv:AddressPhoneNumberOfPurchaser contextRef=\"As_Of_2022_03_18\">\u676d\u5dde\u5e02xx\u533axx\u8defxxx\u53f70571-8888888</inv:AddressPhoneNumberOfPurchaser><inv:DepositBankAndAccountNumberOfPurchaser contextRef=\"As_Of_2022_03_18\">\u519c\u884c\u676d\u5dde\u5e02xx\u652f\u884cxx\u5206\u7406\u5904</inv:DepositBankAndAccountNumberOfPurchaser><inv:SecurityCode contextRef=\"As_Of_2022_03_18\">13&lt;68449*+96//12978219&gt;2+9-&gt;09+23&lt;-09&lt;1*&lt;&lt;88044227+\u201474&lt;2*102+*088-4-583999690785/0/1-&lt;4//&gt;8015/&gt;5194*008*6+6*</inv:SecurityCode><inv:TotalAmountExcludingTax contextRef=\"As_Of_2022_03_18\" unitRef=\"CNY\" decimals=\"2\">11066.73</inv:TotalAmountExcludingTax><inv:TotalTaxAmount contextRef=\"As_Of_2022_03_18\" unitRef=\"CNY\" decimals=\"2\">1438.68</inv:TotalTaxAmount><inv:TaxIncludedAmountInWords contextRef=\"As_Of_2022_03_18\">\u58f9\u4e07\u8d30\u4edf\u4f0d\u4f70\u96f6\u4f0d\u5143\u8086\u89d2\u58f9\u5206</inv:TaxIncludedAmountInWords><inv:TaxIncludedAmountInFigures contextRef=\"As_Of_2022_03_18\" unitRef=\"CNY\" decimals=\"2\">12505.41</inv:TaxIncludedAmountInFigures><inv:NameOfSeller contextRef=\"As_Of_2022_03_18\">\u6d4b\u8bd5\u8bc1\u4e66</inv:NameOfSeller><inv:AddressPhoneNumberOfSeller contextRef=\"As_Of_2022_03_18\">\u6d59\u6c5f\u7701\u676d\u5dde\u5e02xx\u533axx\u8857\u9053xx\u8defxx\u53f70571-8888888</inv:AddressPhoneNumberOfSeller><inv:DepositBankAndAccountNumberOfSeller contextRef=\"As_Of_2022_03_18\">\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8xx\u652f\u884c\u8425\u4e1a\u90e8</inv:DepositBankAndAccountNumberOfSeller><inv:Payee contextRef=\"As_Of_2022_03_18\">\u6d59\u6c5fXX</inv:Payee><inv:Reviewer contextRef=\"As_Of_2022_03_18\">\u6d59\u6c5fXX</inv:Reviewer><inv:Issuer contextRef=\"As_Of_2022_03_18\">\u6d59\u6c5fXX</inv:Issuer><inv:InformationOfTaxableGoodsOrServicesDetailItemsTuple><inv:NatureOfInvoiceLine contextRef=\"As_Of_2022_03_18\">\u666e\u901a\u884c</inv:NatureOfInvoiceLine><inv:NameOfTaxableGoodsOrServices contextRef=\"As_Of_2022_03_18\">*\u4f9b\u7535*\u7535\u8d39</inv:NameOfTaxableGoodsOrServices><inv:UnitPriceOfGoodsOrServices contextRef=\"As_Of_2022_03_18\" unitRef=\"CNY\" decimals=\"2\">0.57729421</inv:UnitPriceOfGoodsOrServices><inv:AmountExcludingTax contextRef=\"As_Of_2022_03_18\" unitRef=\"CNY\" decimals=\"2\">11066.73</inv:AmountExcludingTax><inv:TaxRate contextRef=\"As_Of_2022_03_18\">13%</inv:TaxRate><inv:TaxAmount contextRef=\"As_Of_2022_03_18\" unitRef=\"CNY\" decimals=\"2\">1438.68</inv:TaxAmount></inv:InformationOfTaxableGoodsOrServicesDetailItemsTuple><inv:TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser contextRef=\"As_Of_2022_03_18\">121000004700950166</inv:TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser><inv:TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller contextRef=\"As_Of_2022_03_18\">91440478707956364B</inv:TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller><inv:BeginningOfIncomePeriodUnderAccrualBasis contextRef=\"As_Of_2022_03_18\">2022-03</inv:BeginningOfIncomePeriodUnderAccrualBasis><inv:EndOfIncomePeriodUnderAccrualBasis contextRef=\"As_Of_2022_03_18\">2022-03</inv:EndOfIncomePeriodUnderAccrualBasis></xbrl>");
        if (xmlAndSign) {
            log.info(" \u3010Success\u3011 verifyXmlAndSign ok!");
        } else {
            log.info(" \u3010Error\u3011 verifyXmlAndSign!");
        }
    }
}

