/**存储事件（T_ABC_STORED_EVENT）**/
DROP TABLE IF EXISTS T_ABC_STORED_EVENT;
CREATE TABLE T_ABC_STORED_EVENT ( 
	GID NUMBER(19) PRIMARY KEY not null,
	OWNERID VARCHAR2(36) DEFAULT NULL,
	EVENT_BODY CLOB NOT NULL, 
	OCCURRED_ON TIMESTAMP NOT NULL,
	TYPE_NAME VARCHAR2(200) NOT NULL
);
comment on column T_ABC_STORED_EVENT.GID is '主键';
comment on column T_ABC_STORED_EVENT.OWNERID is '拥有者ID';
comment on column T_ABC_STORED_EVENT.EVENT_BODY is '事件体';
comment on column T_ABC_STORED_EVENT.OCCURRED_ON is '发生时间';
comment on column T_ABC_STORED_EVENT.TYPE_NAME is '事件类型';


/**方法调用跟踪（T_STD_CALL_METHOD_TRACE）**/
DROP TABLE IF EXISTS T_STD_CALL_METHOD_TRACE;
CREATE TABLE T_STD_CALL_METHOD_TRACE (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	METHOD_NAME 			VARCHAR2(200) NOT NULL, 
	METHOD_ARGUMENT 		CLOB DEFAULT NULL, 
	RETURN_DATA 			CLOB DEFAULT NULL, 
	BEGIN_TIME 				TIMESTAMP NOT NULL, 
	END_TIME  				TIMESTAMP DEFAULT NULL, 
	COST 					INTEGER DEFAULT NULL, 
	VALID_STATE 			INTEGER NOT NULL, 
	FAIL_CAUSE 				VARCHAR2(4000) DEFAULT NULL, 
	IP_ADDRESS 				VARCHAR2(60) DEFAULT NULL
);
comment on table "T_STD_CALL_METHOD_TRACE" is '方法调用跟踪';
comment on column "T_STD_CALL_METHOD_TRACE"."GID" is '主键';
comment on column "T_STD_CALL_METHOD_TRACE"."OWNERID" is '拥有者ID';
comment on column "T_STD_CALL_METHOD_TRACE"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_CALL_METHOD_TRACE"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_CALL_METHOD_TRACE"."S_CREATOR" is '创建者';
comment on column "T_STD_CALL_METHOD_TRACE"."METHOD_NAME" is '方法名称';
comment on column "T_STD_CALL_METHOD_TRACE"."METHOD_ARGUMENT" is '调用参数';
comment on column "T_STD_CALL_METHOD_TRACE"."RETURN_DATA" is '返回结果';
comment on column "T_STD_CALL_METHOD_TRACE"."BEGIN_TIME" is '开始时间';
comment on column "T_STD_CALL_METHOD_TRACE"."END_TIME" is '结束时间';
comment on column "T_STD_CALL_METHOD_TRACE"."COST" is '执行耗时ms';
comment on column "T_STD_CALL_METHOD_TRACE"."VALID_STATE" is '方法是否成功执行';
comment on column "T_STD_CALL_METHOD_TRACE"."FAIL_CAUSE" is '失败原因';
comment on column "T_STD_CALL_METHOD_TRACE"."IP_ADDRESS" is 'ip地址';



/**转发跟踪表**/
DROP TABLE IF EXISTS T_STD_DISPATCH;
CREATE TABLE T_STD_DISPATCH (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36),
	SOURCE_TABLE 			VARCHAR2(50) DEFAULT NULL, 
	SOURCE_ID 				VARCHAR2(500) DEFAULT NULL,
	SOURCE_DATA 			CLOB NOT NULL, 
	TRY_COUNT 				INTEGER DEFAULT '0', 
	MAX_COUNT 				INTEGER DEFAULT '0', 
	COMPLETED 				INTEGER NOT NULL, 
	DEST_NAME 				VARCHAR2(100) NOT NULL,
	TXID 					VARCHAR2(100) DEFAULT NULL, 
	REMARK 					VARCHAR2(1000) DEFAULT NULL
);
comment on table "T_STD_DISPATCH" is '转发跟踪表';
comment on column "T_STD_DISPATCH"."GID" is '主键';
comment on column "T_STD_DISPATCH"."OWNERID" is '拥有者ID';
comment on column "T_STD_DISPATCH"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_DISPATCH"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_DISPATCH"."S_CREATOR" is '创建者';
comment on column "T_STD_DISPATCH"."S_LAST_TIME" is '最后修改时间';
comment on column "T_STD_DISPATCH"."S_MODIFIER" is '修改者';
comment on column "T_STD_DISPATCH"."SOURCE_TABLE" is '来源表';
comment on column "T_STD_DISPATCH"."SOURCE_ID" is '来源ID';
comment on column "T_STD_DISPATCH"."SOURCE_DATA" is '来源数据';
comment on column "T_STD_DISPATCH"."TRY_COUNT" is '尝试次数';
comment on column "T_STD_DISPATCH"."MAX_COUNT" is '最大次数';
comment on column "T_STD_DISPATCH"."COMPLETED" is '是否完成(0：否;1：是)';
comment on column "T_STD_DISPATCH"."DEST_NAME" is '目的地名称';
comment on column "T_STD_DISPATCH"."TXID" is '交易ID';
comment on column "T_STD_DISPATCH"."REMARK" is '备注';


/**转发跟踪历史表**/
DROP TABLE IF EXISTS T_STD_DISPATCH_HISTORY;
CREATE TABLE T_STD_DISPATCH_HISTORY (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36),
	SOURCE_TABLE 			VARCHAR2(50) DEFAULT NULL, 
	SOURCE_ID 				VARCHAR2(500) DEFAULT NULL,
	SOURCE_DATA 			CLOB NOT NULL, 
	TRY_COUNT 				INTEGER DEFAULT '0', 
	MAX_COUNT 				INTEGER DEFAULT '0', 
	COMPLETED 				INTEGER NOT NULL, 
	DEST_NAME 				VARCHAR2(100) NOT NULL,
	TXID 					VARCHAR2(100) DEFAULT NULL, 
	REMARK 					VARCHAR2(1000) DEFAULT NULL
);
comment on table "T_STD_DISPATCH_HISTORY" is '转发跟踪历史表';
comment on column "T_STD_DISPATCH_HISTORY"."GID" is '主键';
comment on column "T_STD_DISPATCH_HISTORY"."OWNERID" is '拥有者ID';
comment on column "T_STD_DISPATCH_HISTORY"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_DISPATCH_HISTORY"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_DISPATCH_HISTORY"."S_CREATOR" is '创建者';
comment on column "T_STD_DISPATCH_HISTORY"."S_LAST_TIME" is '最后修改时间';
comment on column "T_STD_DISPATCH_HISTORY"."S_MODIFIER" is '修改者';
comment on column "T_STD_DISPATCH_HISTORY"."SOURCE_TABLE" is '来源表';
comment on column "T_STD_DISPATCH_HISTORY"."SOURCE_ID" is '来源ID';
comment on column "T_STD_DISPATCH_HISTORY"."SOURCE_DATA" is '来源数据';
comment on column "T_STD_DISPATCH_HISTORY"."TRY_COUNT" is '尝试次数';
comment on column "T_STD_DISPATCH_HISTORY"."MAX_COUNT" is '最大次数';
comment on column "T_STD_DISPATCH_HISTORY"."COMPLETED" is '是否完成(0：否;1：是)';
comment on column "T_STD_DISPATCH_HISTORY"."DEST_NAME" is '目的地名称';
comment on column "T_STD_DISPATCH_HISTORY"."TXID" is '交易ID';
comment on column "T_STD_DISPATCH_HISTORY"."REMARK" is '备注';


/**转发消费表**/
DROP TABLE IF EXISTS T_STD_CONSUME;
CREATE TABLE T_STD_CONSUME (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36),
	SOURCE_TABLE 			VARCHAR2(50) DEFAULT NULL, 
	SOURCE_ID 				VARCHAR2(500) DEFAULT NULL,
	SOURCE_DATA 			CLOB NOT NULL, 
	TRY_COUNT 				INTEGER DEFAULT '0', 
	MAX_COUNT 				INTEGER DEFAULT '0', 
	COMPLETED 				INTEGER NOT NULL, 
	DEST_NAME 				VARCHAR2(100) NOT NULL,
	TXID 					VARCHAR2(100) DEFAULT NULL, 
	REMARK 					VARCHAR2(1000) DEFAULT NULL
);
comment on table "T_STD_CONSUME" is '转发消费表';
comment on column "T_STD_CONSUME"."GID" is '主键';
comment on column "T_STD_CONSUME"."OWNERID" is '拥有者ID';
comment on column "T_STD_CONSUME"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_CONSUME"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_CONSUME"."S_CREATOR" is '创建者';
comment on column "T_STD_CONSUME"."S_LAST_TIME" is '最后修改时间';
comment on column "T_STD_CONSUME"."S_MODIFIER" is '修改者';
comment on column "T_STD_CONSUME"."SOURCE_TABLE" is '来源表';
comment on column "T_STD_CONSUME"."SOURCE_ID" is '来源ID';
comment on column "T_STD_CONSUME"."SOURCE_DATA" is '来源数据';
comment on column "T_STD_CONSUME"."TRY_COUNT" is '尝试次数';
comment on column "T_STD_CONSUME"."MAX_COUNT" is '最大次数';
comment on column "T_STD_CONSUME"."COMPLETED" is '是否完成(0：否;1：是)';
comment on column "T_STD_CONSUME"."DEST_NAME" is '目的地名称';
comment on column "T_STD_CONSUME"."TXID" is '交易ID';
comment on column "T_STD_CONSUME"."REMARK" is '备注';


/**转发消费历史表**/
DROP TABLE IF EXISTS T_STD_CONSUME_HISTORY;
CREATE TABLE T_STD_CONSUME_HISTORY (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36),
	SOURCE_TABLE 			VARCHAR2(50) DEFAULT NULL, 
	SOURCE_ID 				VARCHAR2(500) DEFAULT NULL,
	SOURCE_DATA 			CLOB NOT NULL, 
	TRY_COUNT 				INTEGER DEFAULT '0', 
	MAX_COUNT 				INTEGER DEFAULT '0', 
	COMPLETED 				INTEGER NOT NULL, 
	DEST_NAME 				VARCHAR2(100) NOT NULL,
	TXID 					VARCHAR2(100) DEFAULT NULL, 
	REMARK 					VARCHAR2(1000) DEFAULT NULL
);
comment on table "T_STD_CONSUME_HISTORY" is '转发消费历史表';
comment on column "T_STD_CONSUME_HISTORY"."GID" is '主键';
comment on column "T_STD_CONSUME_HISTORY"."OWNERID" is '拥有者ID';
comment on column "T_STD_CONSUME_HISTORY"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_CONSUME_HISTORY"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_CONSUME_HISTORY"."S_CREATOR" is '创建者';
comment on column "T_STD_CONSUME_HISTORY"."S_LAST_TIME" is '最后修改时间';
comment on column "T_STD_CONSUME_HISTORY"."S_MODIFIER" is '修改者';
comment on column "T_STD_CONSUME_HISTORY"."SOURCE_TABLE" is '来源表';
comment on column "T_STD_CONSUME_HISTORY"."SOURCE_ID" is '来源ID';
comment on column "T_STD_CONSUME_HISTORY"."SOURCE_DATA" is '来源数据';
comment on column "T_STD_CONSUME_HISTORY"."TRY_COUNT" is '尝试次数';
comment on column "T_STD_CONSUME_HISTORY"."MAX_COUNT" is '最大次数';
comment on column "T_STD_CONSUME_HISTORY"."COMPLETED" is '是否完成(0：否;1：是)';
comment on column "T_STD_CONSUME_HISTORY"."DEST_NAME" is '目的地名称';
comment on column "T_STD_CONSUME_HISTORY"."TXID" is '交易ID';
comment on column "T_STD_CONSUME_HISTORY"."REMARK" is '备注';


/**业务序号表（T_STD_SEQUENCE_NUMBER）**/
DROP TABLE IF EXISTS T_STD_SEQUENCE_NUMBER;
CREATE TABLE T_STD_SEQUENCE_NUMBER (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36),
	S_VERSION               NUMBER(20) default 0,
	TYPE_NAME				VARCHAR2(30),
	SEQ_NUMBER				INTEGER
);
comment on table "T_STD_SEQUENCE_NUMBER" is '业务序号表';
comment on column "T_STD_SEQUENCE_NUMBER"."GID" is '主键';
comment on column "T_STD_SEQUENCE_NUMBER"."OWNERID" is '拥有者ID';
comment on column "T_STD_SEQUENCE_NUMBER"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_SEQUENCE_NUMBER"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_SEQUENCE_NUMBER"."S_CREATOR" is '创建者';
comment on column "T_STD_SEQUENCE_NUMBER"."S_LAST_TIME" is '最后修改时间';
comment on column "T_STD_SEQUENCE_NUMBER"."S_MODIFIER" is '修改者';
comment on column "T_STD_SEQUENCE_NUMBER"."S_VERSION" is '版本号';
comment on column "T_STD_SEQUENCE_NUMBER"."TYPE_NAME" is '类型名称';
comment on column "T_STD_SEQUENCE_NUMBER"."SEQ_NUMBER" is '序号值';


/* 系统参数配置 */
DROP TABLE IF EXISTS T_STD_SYSTEMCONFIG;
CREATE TABLE T_STD_SYSTEMCONFIG (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	PROPERTY_NAME 			VARCHAR2(100) NOT NULL,
	PROPERTY_VALUE 			VARCHAR2(100) NOT NULL,
	REMARK 					VARCHAR2(200) NOT NULL
);
comment on table "T_STD_SYSTEMCONFIG" is '系统参数配置';
comment on column "T_STD_SYSTEMCONFIG"."GID" is '主键';
comment on column "T_STD_SYSTEMCONFIG"."OWNERID" is '拥有者ID';
comment on column "T_STD_SYSTEMCONFIG"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_SYSTEMCONFIG"."PROPERTY_NAME" is '属性名称';
comment on column "T_STD_SYSTEMCONFIG"."PROPERTY_VALUE" is '属性值';
comment on column "T_STD_SYSTEMCONFIG"."REMARK" is '备注';




/*创建附件临时表*/
DROP TABLE IF EXISTS T_STD_ATTACT_TEMP;
create table T_STD_ATTACT_TEMP
(
  GID               NUMBER(19) primary key not null,
  OWNERID           VARCHAR2(36),
  F_BIZSTATE        INTEGER default 0 not null,
  S_CREATE_TIME     TIMESTAMP,
  S_CREATOR         VARCHAR2(128),
  S_LAST_TIME       TIMESTAMP,
  S_MODIFIER        VARCHAR2(128),
  USER_GID          VARCHAR2(36),
  ATTACH_GID		VARCHAR2(36),
  RELATION_TABLE	VARCHAR2(50),
  VALID_STATE 		INTEGER DEFAULT NULL
);
comment on table "T_STD_ATTACT_TEMP" is '创建附件临时表';
comment on column T_STD_ATTACT_TEMP.GID is '主键';
comment on column T_STD_ATTACT_TEMP.OWNERID is '拥有者ID';
comment on column T_STD_ATTACT_TEMP.S_CREATE_TIME is '创建时间';
comment on column T_STD_ATTACT_TEMP.S_CREATOR is '创建人';
comment on column T_STD_ATTACT_TEMP.S_LAST_TIME is '最后修改时间';
comment on column T_STD_ATTACT_TEMP.S_MODIFIER is '最后修改人';
comment on column T_STD_ATTACT_TEMP.USER_GID is '用户gid';
comment on column T_STD_ATTACT_TEMP.ATTACH_GID is '附件gid';
comment on column T_STD_ATTACT_TEMP.RELATION_TABLE is '关联实体表';
comment on column T_STD_ATTACT_TEMP.VALID_STATE is '有效状态';



/*创建附件跟踪表*/
DROP TABLE IF EXISTS T_STD_ATTACT_TRACE;
create table T_STD_ATTACT_TRACE
(
  GID               NUMBER(19) primary key not null,
  OWNERID           VARCHAR2(36),
  F_BIZSTATE        INTEGER default 0 not null,
  S_CREATE_TIME     TIMESTAMP,
  S_CREATOR         VARCHAR2(128),
  S_LAST_TIME       TIMESTAMP,
  S_MODIFIER        VARCHAR2(128),
  TENANT_GID        VARCHAR2(36) not null,
  ORG_GID           VARCHAR2(36) not null,
  USER_GID          VARCHAR2(36),
  ATTACH_GID		VARCHAR2(36),
  RELATION_TABLE	VARCHAR2(50),
  RELATION_GID		NUMBER(19) not null
);
CREATE UNIQUE INDEX UNI_ATTACH_GID ON T_STD_ATTACT_TRACE(ATTACH_GID);
comment on table "T_STD_ATTACT_TRACE" is '创建附件临时表';
comment on column T_STD_ATTACT_TRACE.GID is '主键';
comment on column T_STD_ATTACT_TRACE.OWNERID is '拥有者ID';
comment on column T_STD_ATTACT_TRACE.S_CREATE_TIME is '创建时间';
comment on column T_STD_ATTACT_TRACE.S_CREATOR is '创建人';
comment on column T_STD_ATTACT_TRACE.S_LAST_TIME is '最后修改时间';
comment on column T_STD_ATTACT_TRACE.S_MODIFIER is '最后修改人';
comment on column T_STD_ATTACT_TRACE.TENANT_GID is '租户gid';
comment on column T_STD_ATTACT_TRACE.ORG_GID is '组织gid';
comment on column T_STD_ATTACT_TRACE.USER_GID is '用户gid';
comment on column T_STD_ATTACT_TRACE.ATTACH_GID is '附件gid';
comment on column T_STD_ATTACT_TRACE.RELATION_TABLE is '关联实体表';
comment on column T_STD_ATTACT_TRACE.RELATION_GID is '关联gid';


/*附件单据关联表（T_STD_ATTACT_BILL_RELATION）*/
DROP TABLE IF EXISTS T_STD_ATTACT_BILL_RELATION;
CREATE TABLE  T_STD_ATTACT_BILL_RELATION (
	GID                     NUMBER(19) PRIMARY KEY NOT NULL,
	BILL_GID                NUMBER(19) NOT NULL,
	RESOURCE_GID            VARCHAR2(36) NOT NULL,
	ATTACH_TYPE             INTEGER DEFAULT NULL,
	REMARK                  VARCHAR2(200) DEFAULT NULL,
	OWNERID                 VARCHAR2(36) DEFAULT NULL,
	F_BIZSTATE              INTEGER DEFAULT 0 NOT NULL,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36)
);
comment on table T_STD_ATTACT_BILL_RELATION is '附件单据关联表';
comment on column T_STD_ATTACT_BILL_RELATION.GID is '主键';
comment on column T_STD_ATTACT_BILL_RELATION.BILL_GID is '单据gid';
comment on column T_STD_ATTACT_BILL_RELATION.RESOURCE_GID is '资源gid';
comment on column T_STD_ATTACT_BILL_RELATION.ATTACH_TYPE is '附件类型';
comment on column T_STD_ATTACT_BILL_RELATION.REMARK is '备注';
comment on column T_STD_ATTACT_BILL_RELATION.OWNERID is '拥有者ID';
comment on column T_STD_ATTACT_BILL_RELATION.F_BIZSTATE is '业务状态';
comment on column T_STD_ATTACT_BILL_RELATION.S_CREATE_TIME is '创建时间';
comment on column T_STD_ATTACT_BILL_RELATION.S_CREATOR is '创建人';
comment on column T_STD_ATTACT_BILL_RELATION.S_LAST_TIME is '最后修改时间';
comment on column T_STD_ATTACT_BILL_RELATION.S_MODIFIER is '最后修改人';


/**定时任务跟踪表**/
DROP TABLE IF EXISTS T_STD_TIMED_TASK_TRACE;
CREATE TABLE T_STD_TIMED_TASK_TRACE(
	GID NUMBER(19) PRIMARY KEY NOT NULL,
	TASK_NAME VARCHAR2(100) NOT NULL, 
	TASK_ARGUMENT VARCHAR2(1000) NOT NULL,
	COMPLETED INTEGER NOT NULL, 
	DEAD_TIME TIMESTAMP NOT NULL, 
	S_VERSION INTEGER default 0,
	OWNERID VARCHAR2(36) DEFAULT NULL,
	F_BIZSTATE INTEGER DEFAULT 0 NOT NULL,
	S_CREATOR VARCHAR2(36) NOT NULL, 
	S_CREATE_TIME TIMESTAMP NOT NULL,
	S_MODIFIER VARCHAR2(36) NOT NULL, 
	S_LAST_TIME TIMESTAMP NOT NULL
);
comment on table T_STD_TIMED_TASK_TRACE is '定时任务跟踪表';
comment on column T_STD_TIMED_TASK_TRACE.GID is '主键';
comment on column T_STD_TIMED_TASK_TRACE.TASK_NAME is '任务名称';
comment on column T_STD_TIMED_TASK_TRACE.TASK_ARGUMENT is '任务参数';
comment on column T_STD_TIMED_TASK_TRACE.COMPLETED is '否完成(0：否;1：是)';
comment on column T_STD_TIMED_TASK_TRACE.DEAD_TIME is '截止时间';
comment on column T_STD_TIMED_TASK_TRACE.S_VERSION is '版本号';
comment on column T_STD_TIMED_TASK_TRACE.OWNERID is '拥有者ID';
comment on column T_STD_TIMED_TASK_TRACE.F_BIZSTATE is '业务状态';
comment on column T_STD_TIMED_TASK_TRACE.S_CREATE_TIME is '创建时间';
comment on column T_STD_TIMED_TASK_TRACE.S_CREATOR is '创建人';
comment on column T_STD_TIMED_TASK_TRACE.S_LAST_TIME is '最后修改时间';
comment on column T_STD_TIMED_TASK_TRACE.S_MODIFIER is '最后修改人';


/**定时任务历史表**/
DROP TABLE IF EXISTS T_STD_TIMED_TASK_HISTORY;
CREATE TABLE T_STD_TIMED_TASK_HISTORY(
	GID NUMBER(19) PRIMARY KEY NOT NULL,
	TASK_NAME VARCHAR2(100) NOT NULL, 
	TASK_ARGUMENT VARCHAR2(1000) NOT NULL,
	COMPLETED INTEGER NOT NULL, 
	DEAD_TIME TIMESTAMP NOT NULL, 
	S_VERSION INTEGER default 0,
	OWNERID VARCHAR2(36) DEFAULT NULL,
	F_BIZSTATE INTEGER DEFAULT 0 NOT NULL,
	S_CREATOR VARCHAR2(36) NOT NULL, 
	S_CREATE_TIME TIMESTAMP NOT NULL,
	S_MODIFIER VARCHAR2(36) NOT NULL, 
	S_LAST_TIME TIMESTAMP NOT NULL
);
comment on table T_STD_TIMED_TASK_HISTORY is '定时任务历史表';
comment on column T_STD_TIMED_TASK_HISTORY.GID is '主键';
comment on column T_STD_TIMED_TASK_HISTORY.TASK_NAME is '任务名称';
comment on column T_STD_TIMED_TASK_HISTORY.TASK_ARGUMENT is '任务参数';
comment on column T_STD_TIMED_TASK_HISTORY.COMPLETED is '否完成(0：否;1：是)';
comment on column T_STD_TIMED_TASK_TRACE.DEAD_TIME is '截止时间';
comment on column T_STD_TIMED_TASK_HISTORY.S_VERSION is '版本号';
comment on column T_STD_TIMED_TASK_HISTORY.OWNERID is '拥有者ID';
comment on column T_STD_TIMED_TASK_HISTORY.F_BIZSTATE is '业务状态';
comment on column T_STD_TIMED_TASK_HISTORY.S_CREATE_TIME is '创建时间';
comment on column T_STD_TIMED_TASK_HISTORY.S_CREATOR is '创建人';
comment on column T_STD_TIMED_TASK_HISTORY.S_LAST_TIME is '最后修改时间';
comment on column T_STD_TIMED_TASK_HISTORY.S_MODIFIER is '最后修改人';

/**印章表**/
DROP TABLE IF EXISTS T_STD_SEAL;
create table T_STD_SEAL (
	GID           NUMBER(19) not null,
	OWNERID       VARCHAR2(36),
	F_BIZSTATE    INTEGER default 0 not null,
	S_CREATE_TIME TIMESTAMP,
	S_CREATOR     VARCHAR2(36),
	S_LAST_TIME   TIMESTAMP,
	S_MODIFIER    VARCHAR2(36),
	S_VERSION     NUMBER(20),
	DPI           NUMBER(19),
	SERIAL_NUMBER VARCHAR2(64),
	RES_ID        VARCHAR2(64),
	SEAL_NAME     VARCHAR2(100),
	SUBJECT_DN    VARCHAR2(200),
	CERT_VALID    DATE
);
comment on table T_STD_SEAL is '印章表';
comment on column T_STD_SEAL.DPI is '印章图片的dpi';
comment on column T_STD_SEAL.SERIAL_NUMBER is '证书序列号';
comment on column T_STD_SEAL.RES_ID is '印章图片对应的资源id';
comment on column T_STD_SEAL.SEAL_NAME is '印章名称';
comment on column T_STD_SEAL.SUBJECT_DN is '证书主题dn';
comment on column T_STD_SEAL.CERT_VALID is '证书有效期';

/**REST调用跟踪（T_STD_REST_TRACE）**/
DROP TABLE IF EXISTS T_STD_REST_TRACE;
CREATE TABLE T_STD_REST_TRACE (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	REQUEST_URL 			VARCHAR2(2000) NOT NULL, 
	REQUEST_METHOD 			VARCHAR2(20) NOT NULL, 
	REQUEST_HEADER 			VARCHAR2(2000) DEFAULT NULL, 
	REQUEST_BODY 			CLOB DEFAULT NULL,
	RESPONSE_STATUS 		VARCHAR2(50) DEFAULT NULL, 
	RESPONSE_HEADER 		VARCHAR2(2000) DEFAULT NULL, 
	RESPONSE_DATA 			CLOB DEFAULT NULL, 
	BEGIN_TIME 				TIMESTAMP NOT NULL, 
	END_TIME  				TIMESTAMP DEFAULT NULL, 
	COST 					INTEGER DEFAULT NULL, 
	VALID_STATE 			INTEGER NOT NULL, 
	FAIL_CAUSE 				CLOB DEFAULT NULL, 
	IP_ADDRESS 				VARCHAR2(60) DEFAULT NULL
);
comment on table "T_STD_REST_TRACE" is 'REST调用跟踪';
comment on column "T_STD_REST_TRACE"."GID" is '主键';
comment on column "T_STD_REST_TRACE"."OWNERID" is '拥有者ID';
comment on column "T_STD_REST_TRACE"."F_BIZSTATE" is '业务状态';
comment on column "T_STD_REST_TRACE"."S_CREATE_TIME" is '创建时间';
comment on column "T_STD_REST_TRACE"."S_CREATOR" is '创建者';
comment on column "T_STD_REST_TRACE"."REQUEST_URL" is '请求url';
comment on column "T_STD_REST_TRACE"."REQUEST_METHOD" is '请求方法';
comment on column "T_STD_REST_TRACE"."REQUEST_HEADER" is '请求头';
comment on column "T_STD_REST_TRACE"."REQUEST_BODY" is '请求体';
comment on column "T_STD_REST_TRACE"."RESPONSE_STATUS" is '响应状态';
comment on column "T_STD_REST_TRACE"."RESPONSE_HEADER" is '响应头';
comment on column "T_STD_REST_TRACE"."RESPONSE_DATA" is '响应数据';
comment on column "T_STD_REST_TRACE"."BEGIN_TIME" is '开始时间';
comment on column "T_STD_REST_TRACE"."END_TIME" is '结束时间';
comment on column "T_STD_REST_TRACE"."COST" is '执行耗时ms';
comment on column "T_STD_REST_TRACE"."VALID_STATE" is '方法是否成功执行';
comment on column "T_STD_REST_TRACE"."FAIL_CAUSE" is '失败原因';
comment on column "T_STD_REST_TRACE"."IP_ADDRESS" is 'ip地址';
/*****************************创建模板（不要执行）***************************
DROP TABLE IF EXISTS T_XXX;
CREATE TABLE T_XXX (
	GID                     NUMBER(20) PRIMARY KEY not null,
	OWNERID                 VARCHAR2(36),
	F_BIZSTATE              INTEGER default 0 not null,
	S_CREATE_TIME           TIMESTAMP NOT NULL,
	S_CREATOR               VARCHAR2(36),
	S_LAST_TIME             TIMESTAMP NOT NULL,
	S_MODIFIER              VARCHAR2(36),
	S_VERSION               NUMBER(20) default 0,
);
comment on table "T_XXX" is '合同草稿';
comment on column "T_XXX"."GID" is '主键';
comment on column "T_XXX"."OWNERID" is '拥有者ID';
comment on column "T_XXX"."F_BIZSTATE" is '业务状态';
comment on column "T_XXX"."S_CREATE_TIME" is '创建时间';
comment on column "T_XXX"."S_CREATOR" is '创建者';
comment on column "T_XXX"."S_LAST_TIME" is '最后修改时间';
comment on column "T_XXX"."S_MODIFIER" is '修改者';
comment on column "T_XXX"."S_VERSION" is '版本号';
comment on column "T_XXX"."XXX" is 'XXX';

*******/
