define(['jquery',
        'ecp.component.loading',
        'abc.basic.util'], function ($, PageLoading, abcUtil) {

	'use strict'; //使用js语法严格模式(提高代码运行效率)
	
	var UploadUtil = function () {};
	UploadUtil.prototype = {
		/**
		 * 附件上传通用方法.
		 * @param target jquery操作对象.
		 * @param uploadUrl 请求url.
		 * @param formData 表单数据.
		 * @param limitObj {'allowFileType': 'doc,docx,xls,xlsx', 'maxFileSize':1024 * 1024 * 10, 'maxCount': 5} 限制对象.
		 * @param option {'success': function(resp){}, 'complete': function(){}, 'error': function(){}}回调函数配置对象.
		 * 
		 */
		upload : function(target, uploadUrl, formData, limitObj, option) {
			var that = this;
			if (!that._checkBeforeUpload(formData, limitObj)) {
				return;
			}
			var loading = that.showTargetBlockUI(target);
			$.ajax({
				url: uploadUrl,
				type: 'POST',
				cache: false,
				data: formData,
				processData: false,//不需要对数据做任何预处理
				contentType: false,//不设置数据格式
				success: function (resp) {
					if (option.success) {
						option.success(resp);
					}
				},
				complete: function () {
					that.hideTargetBlockUI(loading);
					if (option.complete) {
						option.complete();
					}
				},
				error: function () {
					if (option.error) {
						option.error();
					}
				}
			});
		},
        /**
         * 显示指定ID的遮罩.
         * @param jqueryTarget 目标对象.
         */
        showTargetBlockUI: function (jqueryTarget) {
            var opt = {
                container: jqueryTarget,
                timeout: 10*1000
            };
            var loading = new PageLoading(opt);
            loading.show();
            return loading;
        },
        /**
         * 隐藏指定ID的遮罩.
         */
        hideTargetBlockUI: function (loading) {
            if (abcUtil.isEmpty(loading)) {
                throw new Error("参数错误：target为空。");
            }
            loading.hide();
        },
		/**
		 * 上传文件前检查.
		 * @param formData
		 * @param limitObj
		 */
		_checkBeforeUpload : function(formData, limitObj) {
			var files = formData.getAll('file');
			if (files == null || files.length == 0) {
				return false;
			}
			// 单词允许上传文件上限.
			if (limitObj.maxCount && files.length > limitObj.maxCount) {
				abcUtil.notify("上传文件过多。");
				return false;
			}
			// 文件大小.
			if (limitObj.maxFileSize) {
				for (var i=0, j=files.length; i<j; i++) {
					var file = files[i];
					if (file.size > limitObj.maxFileSize) {
						abcUtil.notify("上传文件过大。");
						return false;
					}
				}
			}
			// 文件类型.
			if (limitObj.allowFileType) {
				var types = limitObj.allowFileType.split(',');
				for (var i=0, j=files.length; i<j; i++) {
					var file = files[i];
					var name = file.name;
					var extName = name.slice(name.lastIndexOf('.') + 1, name.length);
					if (!abcUtil.inArray(extName, types)) {
						abcUtil.notify("上传文件类型不支持。");
						return false;
					}
				}
			}
			return true;
		}
	};
	
	return new UploadUtil();
});
