/**
 * 简单工具类.
 */
define(["jquery",
    "ecp.service",
    "ecp.utils",
    "ecp.utils.des",
    "ecp.component.loading"], function ($, ecp, ecpUtils, $des, PageLoading) {
	
	'use strict'; //使用js语法严格模式(提高代码运行效率)
	var LOGIN_CONTEXT_KEY = "_login_context_key";
	
    /**
     * html特殊字符.
     */
    var REGX_HTML_ENCODE = /"|&|'|<|>|[\x00-\x20]|[\x7F-\xFF]|[\u0100-\u2700]/g;
    /**
     * html特殊字符.
     */
    var REGX_HTML_DECODE = /&\w+;|&#(\d+);/g;
    
    var HTML_DECODE = {
            "<" : "<", 
            ">" : ">", 
            "&" : "&", 
            " ": " ", 
            '"': "\"", 
            "©": ""
     
            // Add more
        };
    // 本地浏览器存储生命周期一天（毫秒）
    var LOCAL_STORAGE_TIME = 24 * 3600 * 1000;
	var loading = new PageLoading();
	
	var PureTool = function () {};
	PureTool.prototype = {
        /**
         * 对象深度克隆.
         */
        clone: function (obj) {
            var that = this;
            // Handle the 3 simple types, and null or undefined
            if (null == obj || "object" != typeof obj) return obj;

            // Handle Date
            if (obj instanceof Date) {
                var copy = new Date();
                copy.setTime(obj.getTime());
                return copy;
            }

            // Handle Array
            if (obj instanceof Array) {
                var copy = [];
                for (var i = 0, len = obj.length; i < len; ++i) {
                    copy[i] = that.clone(obj[i]);
                }
                return copy;
            }

            // Handle Object
            if (obj instanceof Object) {
                var copy = {};
                for (var attr in obj) {
                    if (obj.hasOwnProperty(attr)) copy[attr] = that.clone(obj[attr]);
                }
                return copy;
            }
            throw new Error("Unable to copy obj! Its type isn't supported.");
        },
        /**
         * 检查参数是否为空
         * 数值0：true
         * 字符串'0'：false
         */
        isEmpty: function (v) {
            return ecpUtils.isEmpty(v);
        },
        /**
         * 检查参数是否为空
         * 数值0: false
         */
        isEmptyNumber: function (v) {
            if (null == v) {
                return true;
            }
            if (this.trim(v + '') == '') {
                return true;
            }
            return false;
        },
        /**
         * 去掉前后空格后为空串
         */
        isTrimEmpty: function (str) {
            if (this.isEmpty(str)) {
                return true;
            }

            str = this.trim(str);
            if (this.isEmpty(str)) {
                return true;
            }

            return false;
        },
        /**
         * $("#id")---未找到--->[]
         * 是否为空jQuery对象（即，空数组）
         */
        isEmptyJQuery: function (jqObj) {
            return jqObj.length == 0;
        },
	    /**
	     * 脱敏处理.
	     * @param str 待脱敏字符串.
	     * @param index 开始脱敏的index.
	     * @param length 脱敏字符个数.
	     */
        desensitive : function(str, index, length) {
	    	if (this.isEmpty(str)) {
	    		return str;
	    	}
	    	var result = [];
	    	var arr = str.split('');
	    	for(var i=0,j=arr.length; i<j; i++) {
	    		if (i < index) {
	    			result.push(arr[i]);
	    		} else if(i >= index + length) {
	    			result.push(arr[i]);
	    		} else{
	    			result.push("*");
	    		}
	    	}
	    	return result.join('');
	    },
	    /**
	     * 脱敏姓名.
	     */
	    desensitiveName : function(name) {
	    	return this.desensitive(name, 1, 1);
	    },
	    /**
	     * 脱敏手机号.
	     */
	    desensitiveMovetel : function(movetel) {
	    	return this.desensitive(movetel, 3, 4);
	    },
	    /**
	     * 脱敏身份证.
	     */
	    desensitiveCardId : function(cardId) {
	    	return this.desensitive(cardId, 10, 6);
	    },
        /**
         * 解析成json对象.
         */
        parseJSON: function(val) {
        	if (null == val) {
        		return null;
        	}
        	var _type = $.type(val);
        	if (_type == "string") {
        		return JSON.parse(val);
        	}
        	
        	return val;
        },
        /**
         * 生成uuid.
         * @param length 字符串长度.
         * @param unit 二进制/十进制/十六进制?
         */
        uuid: function (length, unit) {
            //参数都为空.
            if (this.isEmpty(length) && this.isEmpty(unit)) {
                return Math.uuid();
            }

            //unit为空
            if (!this.isEmpty(length) && this.isEmpty(unit)) {
                //Math.uuid(10);
                return Math.uuid(length);
            }

            //都有值
            if (!this.isEmpty(length) && !this.isEmpty(unit)) {
                //Math.uuid(10, 10);
                return Math.uuid(length, unit);
            }
        },
        /**
         * 是否原始类型（boolean,string,number）
         * @param val
         * @returns
         */
        isPrimitive : function(val) {
        	var _type = $.type(val);
        	if (_type === "boolean") {
        		return true;
        	}
        	if (_type === "number") {
        		return true;
        	}
        	if (_type === "string") {
        		return true;
        	}
        	return false;
        },
        /**
         * 将data对象所有字段统一小写
         */
        field2Lowercase: function (data) {
            if (this.isEmpty(data)) {
                return data;
            }
            var newData = {};
            for (var field in data) {
                newData[field.toLowerCase()] = data[field];
            }
            return newData;
        },
        /**
         * 去掉前后空格
         */
        trim: function (str) {
            if (this.isEmpty(str)) {
                return str;
            }
            str = str.replace(/(^\s*)|(\s*$)/g, '');

            return str;
        },
        /**
         * 编码html特殊字符.
         */
        encodeHtml : function (str) {
        	if (this.isEmpty(str)) {
                return str;
            }
        	return str.replace(REGX_HTML_ENCODE, 
                    function($0){
                        var c = $0.charCodeAt(0), r = ["&#"];
                        c = (c == 0x20) ? 0xA0 : c;
                        r.push(c); 
                        r.push(";");
                        return r.join("");
        	});
        },
        /**
         * 解密html特殊字符.
         */
        decodeHtml : function (str) {
        	if (this.isEmpty(str)) {
                return str;
            }
        	
        	return str.replace(REGX_HTML_DECODE,
                    function($0, $1){
                        var c = HTML_DECODE[$0];
                        if(c == undefined){
                            // Maybe is Entity Number
                            if(!isNaN($1)){
                                c = String.fromCharCode(($1 == 160) ? 32:$1);
                            }else{
                                c = $0;
                            }
                        }
                        return c;
                    });
        },
        
        /**
         * 解密用户VO关键信息.
         *  配合CommonUtil  中的 encodeUserVO方法使用
         */
        decryptUserVO : function(userVO) {
        	// 身份证
        	if (!ecpUtils.isEmpty(userVO.cardId)) {
				userVO.cardId = $des.doDecrypt(userVO.cardId);
			}
        	
        	// email
			if (!ecpUtils.isEmpty(userVO.email)) {
				userVO.email = $des.doDecrypt(userVO.email);
			}
			
			// 电话
        	if (!ecpUtils.isEmpty(userVO.movetel)) {
        		userVO.movetel = $des.doDecrypt(userVO.movetel);
			}
        },
        /**
         * 删除对象空属性
         */
        deleteEmptyField: function (obj) {
            if (this.isEmpty(obj)) {
                return null;
            }
            for (var key in obj) {
                var value = obj[key];
                if (!value) {
                    delete obj[key];
                }
            }
            return obj;
        },
        /**
         * 是否为【全部】选项
         */
        isAllOpt: function (val) {
            // 【空值】也默认是全部
            if (this.isEmpty(val)) {
                return true;
            }
            if ('-1' == val) {
                return true;
            }
            return false;
        },
        /**
         * 字符串是否包含指定串
         * @param str 原字符串
         * @param search 搜索字符串
         */
        containStr: function (str, search) {
            if (this.isEmpty(str) || this.isEmpty(search)) {
                throw new Error("参数错误：str or search为空。")
            }
            var idx = str.indexOf(search);
            return idx > -1;
        },
        /**
         * 添加数据到Array，并保证唯一
         */
        addSingle2Array: function (arr, val) {
            if (arr == null) {
                throw new Error("参数错误：arr为null。 ");
            }
            // 当前数组中不包含，则添加
            if (!this.inArray(val, arr)) {
                arr.push(val);
            }
        },
        /**
         * 检查指定的值是否在array
         */
        inArray: function (value, arr) {
            if (arr == null) {
                throw new Error("参数错误：arr为null。 ");
            }
            if ($.inArray(value, arr) > -1) {
                return true;
            }
            return false;
        },
        /**
         * 强制转换字符串
         */
        toString: function (param) {
            if (param == null) {
                return '';
            }

            return '' + param;
        },
        /**
         * 参数转换为数组，如果是数组直接返回
         */
        toArray: function (param) {
            if (this.isEmpty(param)) {
                throw new Error("参数错误：param为空。 ");
            }
            if ($.isArray(param)) {
                return param;
            }
            var arr = param.split(',');
            return arr;
        },
        /**
         * 字符串切割成数组返回（trim）
         * @param str 字符串（如:"abc,kdik,ale"）
         * @param filterBlank 是否过滤空串（默认过滤空串）
         */
        str2Array: function (str, filterBlank) {
            var that = this;
            if (this.isEmpty(str)) {
                return [];
            }
            if (filterBlank == null) {
                filterBlank = true;
            }
            var arr = str.split(",");
            var rst = [];
            $.each(arr, function (i, e) {
                e = $.trim(e);
                if (!that.isEmpty(e)) {
                    rst.push(e);
                }
            });

            return rst;
        },
        /**
         * 将数组转换成Map
         * @param arr
         * @param keyField
         * [{id:'01', text:'AAA'},{id:'02', text:'BBB'},{id:'03', text:'CCC'},...]
         * -->
         * {
         * 	'01':{id:'01', text:'AAA'},
         *  '02':{id:'02', text:'BBB'},
         *  '03':{id:'03', text:'CCC'},
         * }
         */
        array2Map: function (arr, keyField) {
            var that = this;
            if (this.isEmpty(keyField)) {
                this.dialog('参数错误：keyField为空。');
                return null;
            }
            if (GldxUtil.isEmpty(arr)) {
                return {};
            }
            var map = {};
            $.each(arr, function (i, e) {
                var key = e[keyField];
                if (that.isEmpty(key)) {
                    this.dialog('数据错误：key为空。');
                    return null;
                }
                map[key] = e;
            });
            return map;
        },
        /**
         * 过滤数组里的空值
         * @param arr 数组（如['12544524','12544523']）
         *
         */
        filterArrayBlank: function (arr) {
            var that = this;
            if (arr == null) {
                this.dialog("参数错误:dxids为空。");
                return;
            }

            var newArr = [];
            $.each(arr, function (i, v) {
                if (!that.isEmpty(v)) {
                    newArr.push(v);
                }
            });

            return newArr;
        },
        /**
         * 将指定列对应的值'null'转换为空串
         * @param datas
         * @param fields 需要检查的字段（数组）
         */
        nullStr2Blank: function (datas, fields) {
            var that = this;
            if (this.isEmpty(datas)) {
                return;
            }
            $.each(datas, function (i, v) {
                // 指定要检查的字段
                $.each(fields, function (j, field) {
                    var val = '' + v[field];
                    if (!that.isEmpty(val)) {
                        if ("NULL" === val.toUpperCase()) {
                            v[field] = '';
                        }
                    }
                });
            });
        },
        /**
         * 计算指定下个天数的日期对象
         * @param date（日期对象）
         * @param days 间隔天数（允许负数）
         */
        nextDay: function (date, days) {
            if (this.isEmpty(date)) {
                throw new Error("参数错误：dateVal为空。 ");
            }
            if (this.isEmpty(days)) {
                throw new Error("参数错误：days为空。 ");
            }

            var that = this;
            var cons = 24 * 60 * 60 * 1000;
            var valType = $.type(date);
            date = this.parseDate(date);
            var time = date.getTime();
            time = time + (days * cons);
            return new Date(time);
        },
        /**
         * 简单日期格式化（yyyy-MM-dd）
         * @param date JS原生Date类
         */
        simpleFormatDate: function (date) {
            return ecpUtils.formatDate(date, 'yyyy-MM-dd');
        },
        /**
         * 解析为EcpDate.
         */
        parseEcpDate: function (dateVal) {
            if (this.isEmpty(dateVal)) {
                throw new Error("参数错误：dateVal为空。 ");
            }
            var date = this.parseDate(dateVal);
            return "/Date(" + date.getTime() + "+0800)/"
        },
        /**
         * 解析为jsDate对象.
         * 1、"/Date(1506960000000+0800)/"
         * 2、yyyy-MM-dd
         * 3、yyyy-MM-dd hh:mm:ss
         */
        parseDate: function (dateVal) {
            var that = this;
            if (this.isEmpty(dateVal)) {
                throw new Error("参数错误：dateVal为空。 ");
            }

            var valType = $.type(dateVal);
            //Date对象直接返回.
            if ('date' === valType) {
                return dateVal;
            }
            var date = null;
            //类型为字符串
            if ('string' === valType) {
                //日期json格式："\/Date(1540915200000+0800)\/"
                if (/^\/Date\(\d+\+0800\)\/$/.test(dateVal)) {
                    date = that.jsonStrToDate(dateVal);
                } else if (/^\\\/Date\(\d+\+0800\)\\\/$/.test(dateVal)) {
                    date = that.jsonStrToDate(dateVal);
                } else if (/^\d{4}-\d{2}-\d{2}$/.test(dateVal)) {
                    //日期格式：yyyy-MM-dd
                    dateVal = dateVal.replace(/-/g, "/")
                    date = new Date(Date.parse(dateVal))
                } else if (/^\d{4}-\d{2}-\d{2}\s*\d{2}:\d{2}:\d{2}$/.test(date)) {
                    //日期格式：yyyy-MM-dd hh:mm:ss
                    dateVal = dateVal.replace(/-/g, "/")
                    date = new Date(Date.parse(dateVal))
                } else if (/^\d{4}-\d{2}-\d{2}\s*\d{2}:\d{2}$/.test(dateVal)) {
                    //日期格式：yyyy-MM-dd hh:mm
                    dateVal = dateVal.replace(/-/g, "/")
                    date = new Date(Date.parse(dateVal))
                }
            } else if ('number' === valType) {
                date = new Date(dateVal)
            }

            return date;
        },
        /**
         * 将 Date 转化为指定格式的String
         * 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
         * 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
         * 例子： formatDate(new Date(),"yyyy-MM-dd hh:mm:ss")
         */
        formatDate: function (date, fmt) {
            return ecpUtils.formatDate(date, fmt);
        },
        /**
         * "/Date(1506960000000+0800)/" -> "2017-10-03"
         * json日期转换成（'yyyy-MM-dd'）格式
         */
        jsonDate2Str: function (jsonDate) {
            return ecpUtils.strToDate(jsonDate);
        },

        /**
         * "/Date(1506960000000+0800)/" -> "2017-10-03"
         * json日期转换成（'yyyy-MM-dd hh:ii'）格式
         */
        jsonDate2abStrWithoutSecond: function (jsonDate) {
            return ecpUtils.strToDate(jsonDate, true, null, false);
        },

        /**
         * "/Date(1506960000000+0800)/" -> Fri Feb 03 2012 00:00:00 GMT+0800
         * json日期转换成js Date对象.
         */
        jsonStrToDate: function (jsonDate) {
            return ecpUtils.jsonStrToDate(jsonDate);
        },
        /**
         * 将格式化带千分位的金额转换成数字
         */
        parseNumber: function (p) {
            if (this.isEmpty(p)) {
                return 0;
            }
            if (typeof p === 'string') {
                p = p.replace(/,/g, "");
            }

            return parseFloat(p);
        },
        /**
         * 由于自动带出的金额无法使用numberBox格式化,所以加一个方法格式化数字
         * @param num 待转换数值.
         * @param scale 精度（默认2）
         */
        formatNumber: function (num, scale) {
            if (null == scale) {
                scale = 2;
            }
            if (scale < 0) {
                throw new Error("参数错误：scale必须大于等于0。");
            }
            //小数点占位.
            var decimalPadding = this._buildDecimal(scale);
            if (num === undefined || num == "" || num == 0) {
                return this._addDecimal("0", decimalPadding);
            }
            var result = num;
            num = num + "";
            num = num.replace(new RegExp(",", "g"), "");
            // 正负号处理
            var symble = "";
            if (/^([-+]).*$/.test(num)) {
                symble = num.replace(/^([-+]).*$/, "$1");
                num = num.replace(/^([-+])(.*)$/, "$2");
            }
            if (/^[0-9]+(\.[0-9]+)?$/.test(num)) {
                var num = num.replace(new RegExp("^[0]+", "g"), "");
                if (/^\./.test(num)) {
                    num = "0" + num;
                }
                // 获取小数部分
                var decimal = num.replace(/^[0-9]+(\.[0-9]+)?$/, "$1");
                // 获取整数部分
                var integer = num.replace(/^([0-9]+)(\.[0-9]+)?$/, "$1");
                var re = /(\d+)(\d{3})/;
                // 给传入参数隔三位添加千分位
                while (re.test(integer)) {
                    integer = integer.replace(re, "$1,$2");
                }
                // 拼接
                result = symble + integer + decimal;
            } else {
                result = num;
            }

            return this._addDecimal(result + "", decimalPadding);
        },
        
        /**
         * bit位转换成具体的数字集合.
         * 1,2,4,8... 计数值
         * 3->[1,2]
         * 9->[1,8]
         */
        bitToNumbers : function(n) {
            var r = [];
            var i = 0;
            while (n > 0) {
                if (n & 0x01 === 1) {
                    r.push(Math.pow(2, i));
                }
                i++;
                n = n >> 1;
            }
            return r;
        },
        
        /**
         * 构建小数部分（占位）
         */
        _buildDecimal: function (scale) {
            var arr = [];
            for (var i = 0; i < scale; i++) {
                arr.push("0");
            }
            return arr.join("");
        },
        /**
         * 添加小数部分.
         * @param num 数值.
         * @param decimalPadding 小数填充
         */
        _addDecimal: function (num, decimalPadding) {
            //小数点索引.
            var idx = num.indexOf(".");
            if (idx < 0) {
                if ("" != decimalPadding) {
                    num = num + "." + decimalPadding;
                }
            } else {
                var decimal = num.substring(idx + 1);
                var length = decimal.length;
                //小数位补齐.
                if (length < decimalPadding.length) {
                    num = num + decimalPadding.substring(decimal.length);
                }
            }
            return num;
        },
        /**
         * 检查两个日期控件时，日期大小是否正确
         * @param d1 开始日期
         * @param d2 结算日期
         */
        checkDateRange: function (d1, d2) {
            //两个都有值才检查
            if (!this.isEmpty(d1) && !this.isEmpty(d2)) {
                var date1 = d1;
                var date2 = d2;
                if (typeof d1 == "string") {
                    date1 = Date.parse(d1);
                }
                if (typeof d2 == "string") {
                    date2 = Date.parse(d2);
                }
                return date1 > date2 ? false : true;
            }
            return true;
        },
        /**
         * 根据key获取本地浏览器存储
         * @param key key
         * @returns {*}
         */
        getLocalStorage: function (key) {
            return $.jStorage.get(key) || [];
        },

        /**
         * 设置本地浏览器存储
         * @param key
         * @param value
         * @param liveTime 生命周期（毫秒），可选，
         * 不传默认取LOCAL_STORAGE_TIME：一个星期
         */
        setLocalStorage: function (key, value, liveTime) {
            var liveTime = liveTime || LOCAL_STORAGE_TIME;
            $.jStorage.set(key, value, {TTL: liveTime});
        },
        /**
         * 根据key清楚本地浏览器存储.
         */
        clearLocalStorage: function (key) {
            $.jStorage.deleteKey(key)
        },
        /**
         * 清空缓存
         */
        clearAllLocalStorage: function () {
            $.jStorage.flush();
        },
        /**
         * 等待条件成熟执行回调
         * @param funcObj={sucFunc(成功执行的回调), failFunc(失败的回调), checkFunc(检查回调)} 待执行的函数
         * @param interval 间隔（毫秒）
         * @param curCount 当前执行次数
         * @parma maxCount 最大执行次数
         */
        execFuncByWait: function (funcObj, interval, curCount, maxCount) {
            var that = this;
            setTimeout(function () {
                if (!funcObj.checkFunc()) {
                    //检查不通过
                    if (curCount <= maxCount) {
                        curCount++;
                        that.execFuncByWait(funcObj, interval, curCount, maxCount);
                    } else {
                        //超过最大执行次数，返回。
                        if (funcObj.failFunc) {
                            funcObj.failFunc();
                        }
                        return;
                    }
                } else {
                    //检查通过执行回调
                    funcObj.sucFunc();
                }
            }, interval);
        },
        /**
         * 抛出异常.
         * @param msg 异常提示语句.
         */
        throwException: function (msg) {
            throw new Error(msg);
        },
        /**
         * 从cookie获取系统的token.
         */
        getEcpToken: function() {
        	// 以前的cookie项ecp_token已被弃用
        	return $.cookie("ecpDataContext.tokenId");
        },
        /**
         * 解析组件html
         * @param template 模板html
         * @param resp ajax返回的html页面
         * @param serialID 需要替换的序列号
         */
        parseComponentHtml: function (template, resp, serialID) {
            // 当模板为空时
            if (null == template) {
                var html = resp.replace(/@serialID/g, serialID);
            } else {
                var html = template.replace(/@respHtml/g, resp);
                html = html.replace(/@serialID/g, serialID);
            }
            return html;
        },
		/**
		 * Url参数16进制编码.
		 */
		encodeHexUrlParam : function(str) {
			/*
			if (this.isEmpty(str) || "{}" === str) {
				return "";
			}*/
			return this.toHexString(str);
		},
		/**
		 * 字符串转16进制编码字符串.
		 */
		toHexString: function (utf8Str) {
			var latin1Str = unescape(encodeURIComponent(utf8Str));
			var wordArray = this._toWordArray(latin1Str);
			// Shortcuts
			var words = wordArray.words;
			var sigBytes = wordArray.sigBytes;
			
			// Convert
			var hexChars = [];
			for (var i = 0; i < sigBytes; i++) {
				var bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
				hexChars.push((bite >>> 4).toString(16));
				hexChars.push((bite & 0x0f).toString(16));
			}
			var hexStr = hexChars.join('');
			return hexStr.toUpperCase();
		},
		/**
		 * base64编码的字符串转WordArray.
		 */
		_toWordArray : function(latin1Str) {
            // Shortcut
            var latin1StrLength = latin1Str.length;

            // Convert
            var words = [];
            for (var i = 0; i < latin1StrLength; i++) {
                words[i >>> 2] |= (latin1Str.charCodeAt(i) & 0xff) << (24 - (i % 4) * 8);
            }
			var wordArray = {
				'words': words,
				'sigBytes': latin1StrLength
			};
			return wordArray;
		},
        
	};
	return new PureTool();
});