/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.jcajce.provider.symmetric;

import org.bouncycastle149.crypto.CipherKeyGenerator;
import org.bouncycastle149.crypto.engines.XTEAEngine;
import org.bouncycastle149.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle149.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastle149.jcajce.provider.util.AlgorithmProvider;

public final class XTEA {
    private XTEA() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "XTEA IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new XTEAEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XTEA", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XTEA.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.XTEA", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.XTEA", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.XTEA", PREFIX + "$AlgParams");
        }
    }
}

