/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.modes;

import org.bouncycastle149.crypto.BlockCipher;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.DataLengthException;
import org.bouncycastle149.crypto.params.ParametersWithIV;

public class SICBlockCipher
implements BlockCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private byte[] IV;
    private byte[] counter;
    private byte[] counterOut;

    public SICBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            throw new IllegalArgumentException("SIC mode requires ParametersWithIV");
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        int n3;
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        for (n3 = 0; n3 < this.counterOut.length; ++n3) {
            byArray2[n2 + n3] = (byte)(this.counterOut[n3] ^ byArray[n + n3]);
        }
        n3 = this.counter.length - 1;
        while (n3 >= 0) {
            int n4 = n3--;
            this.counter[n4] = (byte)(this.counter[n4] + 1);
            if (this.counter[n4] == 0) continue;
        }
        return this.counter.length;
    }

    public void reset() {
        System.arraycopy(this.IV, 0, this.counter, 0, this.counter.length);
        this.cipher.reset();
    }
}

