/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle149.crypto.KeyGenerationParameters;
import org.bouncycastle149.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle149.crypto.params.DHParameters;
import org.bouncycastle149.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle149.crypto.params.ElGamalParameters;
import org.bouncycastle149.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

