/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle149.crypto.BasicAgreement;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.DHParameters;
import org.bouncycastle149.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle149.crypto.params.DHPublicKeyParameters;
import org.bouncycastle149.crypto.params.ParametersWithRandom;

public class DHBasicAgreement
implements BasicAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    public void init(CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        if (!(asymmetricKeyParameter instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)asymmetricKeyParameter;
        this.dhParams = this.key.getParameters();
    }

    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)cipherParameters;
        if (!dHPublicKeyParameters.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return dHPublicKeyParameters.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

