/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cert.crmf;

import java.io.IOException;
import org.bouncycastle149.asn1.cms.EnvelopedData;
import org.bouncycastle149.asn1.crmf.CRMFObjectIdentifiers;
import org.bouncycastle149.asn1.crmf.EncKeyWithID;
import org.bouncycastle149.asn1.crmf.EncryptedKey;
import org.bouncycastle149.asn1.crmf.PKIArchiveOptions;
import org.bouncycastle149.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle149.asn1.x509.GeneralName;
import org.bouncycastle149.cert.crmf.PKIArchiveControl;
import org.bouncycastle149.cms.CMSEnvelopedData;
import org.bouncycastle149.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle149.cms.CMSException;
import org.bouncycastle149.cms.CMSProcessableByteArray;
import org.bouncycastle149.cms.RecipientInfoGenerator;
import org.bouncycastle149.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance(cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

