/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool.webservice;

import com.ygsoft.ecp.service.tool.webservice.WebServiceConst;
import com.ygsoft.ecp.service.tool.webservice.XSDType;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceUtil {
    private static Log log = LogFactory.getLog(WebServiceUtil.class);
    private static final Service service = new Service();
    private String url;
    private String soapAction;
    private boolean needPrefid = true;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newurl) {
        this.url = newurl;
    }

    public final void setNeedPrefid(boolean value) {
        this.needPrefid = value;
    }

    public final boolean getNeedPrefid() {
        return this.needPrefid;
    }

    public Object[] callMethod(String methodName, Object[] params) {
        return this.callMethod(methodName, params, null, null, null);
    }

    private String getUri(String nameSpace, String methodName) {
        if (nameSpace.endsWith("/")) {
            return new StringBuffer().append(nameSpace).append(methodName).toString();
        }
        return new StringBuffer().append(nameSpace).append("/").append(methodName).toString();
    }

    public Object[] callMethod(String soapAction, QName operatorName, Object[] params) {
        return this.callMethod(soapAction, operatorName, params, null, null, null);
    }

    public Object[] callMethod(String soapAction, QName operatorName, Object[] params, String[] paramNames, int[] xsdTypes, QName returnType) {
        if (this.url == null || this.url.trim().length() < 1) {
            throw new RuntimeException("\u6307\u5411\u670d\u52a1\u7684URL\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6eURL\u518d\u8c03\u7528\u65b9\u6cd5");
        }
        log.debug((Object)("\u5f53\u524d\u8c03\u7528\u7684WebService URL\uff1a" + this.url));
        log.debug((Object)("\u5f53\u524d\u8c03\u7528\u7684\u65b9\u6cd5\u540d\uff1a" + operatorName));
        log.debug((Object)("\u5f53\u524d\u8c03\u7528\u53c2\u6570\u4e3a\uff1a" + Arrays.toString(params)));
        log.debug((Object)("\u5f53\u524dSOAPACTION\uff1a" + soapAction));
        Call call = null;
        try {
            call = (Call)service.createCall();
        }
        catch (ServiceException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u521b\u5efaCall\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        try {
            call.setTargetEndpointAddress(new URL(this.url));
        }
        catch (MalformedURLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bbe\u7f6eURL\u51fa\u9519\uff0c\u8bf7\u786e\u8ba4URL\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        if (soapAction != null && soapAction.trim().length() > 0) {
            call.setUseSOAPAction(true);
            call.setSOAPActionURI(soapAction);
            call.setOperationName(operatorName);
        } else {
            call.setUseSOAPAction(false);
            call.setOperationName(operatorName);
        }
        if (paramNames != null) {
            if (xsdTypes == null) {
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u53c2\u6570\u540d\u79f0\u548cXsd\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u90fd\u8981\u540c\u65f6\u4f20\u5165\u6216\u4e0d\u4f20");
            }
            for (int i = 0; i < paramNames.length; ++i) {
                call.addParameter(new QName(soapAction, paramNames[i]), new QName("http://www.w3.org/2001/XMLSchema", XSDType.getTypeName(xsdTypes[i])), ParameterMode.IN);
            }
            call.setReturnType(returnType);
        }
        call.setTimeout(WebServiceConst.TIMEOUT);
        Object result = null;
        try {
            result = call.invoke(params);
        }
        catch (RemoteException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u51fa\u9519", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        List list = call.getOutputValues();
        int size = list.size();
        Object[] returnObjects = new Object[size + 1];
        returnObjects[0] = result;
        for (int i = 0; i < list.size(); ++i) {
            returnObjects[i + 1] = list.get(i);
        }
        list = null;
        return returnObjects;
    }

    public Object[] callMethod(String methodName, Object[] params, String[] paramNames, int[] xsdTypes, QName returnType) {
        if (this.url == null || this.url.trim().length() < 1) {
            throw new RuntimeException("\u6307\u5411\u670d\u52a1\u7684URL\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6eURL\u518d\u8c03\u7528\u65b9\u6cd5");
        }
        log.debug((Object)("\u5f53\u524d\u8c03\u7528\u7684WebService URL\uff1a" + this.url));
        log.debug((Object)("\u5f53\u524d\u8c03\u7528\u7684\u65b9\u6cd5\u540d\uff1a" + methodName));
        log.debug((Object)("\u5f53\u524d\u8c03\u7528\u53c2\u6570\u4e3a\uff1a" + Arrays.toString(params)));
        log.debug((Object)("\u5f53\u524dSOAPACTION\uff1a" + this.soapAction));
        Call call = null;
        try {
            call = (Call)service.createCall();
        }
        catch (ServiceException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u521b\u5efaCall\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        try {
            call.setTargetEndpointAddress(new URL(this.url));
        }
        catch (MalformedURLException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8bbe\u7f6eURL\u51fa\u9519\uff0c\u8bf7\u786e\u8ba4URL\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        if (this.soapAction != null && this.soapAction.trim().length() > 0) {
            call.setUseSOAPAction(true);
            call.setSOAPActionURI(this.getUri(this.soapAction, methodName));
            call.setOperationName(new QName(this.soapAction, methodName));
        } else {
            call.setUseSOAPAction(false);
            call.setOperationName(methodName);
        }
        if (paramNames != null) {
            if (xsdTypes == null) {
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u53c2\u6570\u540d\u79f0\u548cXsd\u53c2\u6570\u7c7b\u578b\u5fc5\u987b\u90fd\u8981\u540c\u65f6\u4f20\u5165\u6216\u4e0d\u4f20");
            }
            for (int i = 0; i < paramNames.length; ++i) {
                call.addParameter(new QName(this.soapAction, paramNames[i]), new QName("http://www.w3.org/2001/XMLSchema", XSDType.getTypeName(xsdTypes[i])), ParameterMode.IN);
            }
            call.setReturnType(returnType);
        }
        call.setTimeout(WebServiceConst.TIMEOUT);
        Object result = null;
        try {
            result = call.invoke(params);
        }
        catch (RemoteException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u51fa\u9519", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
        List list = call.getOutputValues();
        int size = list.size();
        Object[] returnObjects = new Object[size + 1];
        returnObjects[0] = result;
        for (int i = 0; i < list.size(); ++i) {
            returnObjects[i + 1] = list.get(i);
        }
        list = null;
        return returnObjects;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String newsoapAction) {
        this.soapAction = newsoapAction;
        if (this.soapAction != null && this.needPrefid && !this.soapAction.endsWith("/")) {
            this.soapAction = new StringBuffer().append(this.soapAction).append("/").toString();
        }
    }
}

