/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.dataaccess.exception.DataaccessException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.ThreadLocalUtil;
import com.ygsoft.ecp.service.tool.ValidatorUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VPDUtil {
    private static boolean gap;
    private static ISQLTemplate sqlTemplate;
    private static final IEcpLog LOG;
    public static final String LOG_SET_VPD_COMPID = "\u542f\u7528vpd_Compid\u7ebf\u7a0b\u53d8\u91cf:{0}\u6210\u529f!";
    public static final String LOG_SET_VPD_ENABLE = "\u542f\u7528VPD_STATE\u7b56\u7565\u7ebf\u7a0b\u53d8\u91cf\u6210\u529f!";
    public static final String GET_VPD_COMPID = "SELECT SYS_CONTEXT('VPD_CONTEXT','COMPID') AS VPD_CONTEXT FROM DUAL";
    public static final String SET_VPD_COMPID = "BEGIN\nvPD_PKG.SET_CONTEXT_COMPID(''{0}'');\nEND;";
    public static final String SET_VPD_COMPID_STATE_ENABLE = "BEGIN\nvPD_PKG.SET_CONTEXT_COMPID(''{0}'');vPD_PKG.SET_VPD_STATE_ENABLE();\nEND;";
    public static final String SET_VPD_COMPID_STATE_DISABLE = "BEGIN\nvPD_PKG.SET_CONTEXT_COMPID(''{0}'');vPD_PKG.SET_VPD_STATE_DISABLE();\nEND;";
    public static final String GET_VPD_STATE = "SELECT SYS_CONTEXT('VPD_CONTEXT','VPD_STATE') AS VPD_STATE FROM DUAL";
    public static final String SET_VPD_ENABLE = "BEGIN\nvPD_PKG.SET_VPD_STATE_ENABLE();\nEND;";
    public static final String SET_VPD_DISABLE = "BEGIN\nvPD_PKG.SET_VPD_STATE_DISABLE();\nEND;";
    public static final String LOG_SET_VPD_YEAR = "\u542f\u7528vpd_Year\u7ebf\u7a0b\u53d8\u91cf:{0}\u6210\u529f!";
    public static final String SET_VPD_YEAR = "BEGIN\nvPD_PKG.SET_CONTEXT_VPD_YEAR(''{0}'');\nEND;";
    public static final String GET_VPD_YEAR = "SELECT DECODE(SYS_CONTEXT('VPD_CONTEXT', 'VPD_YEAR'), '-1', TO_CHAR(SYSDATE, 'YYYYMMDD'), SYS_CONTEXT('VPD_CONTEXT', 'VPD_YEAR')) AS VPD_CONTEXT FROM DUAL";
    public static final String LOG_SET_VPD_ACCBOOKID = "\u542f\u7528vpd_Accbookid\u7ebf\u7a0b\u53d8\u91cf:{0}\u6210\u529f!";
    public static final String SET_VPD_ACCBOOKID = "BEGIN\nVPD_PKG.SET_CONTEXT_ACCBOOKID(''{0}'');\nEND;";
    public static final String GET_VPD_ACCBOOKID = "SELECT DECODE(SYS_CONTEXT('VPD_CONTEXT', 'ACCBOOKID'), '-1', '0', SYS_CONTEXT('VPD_CONTEXT', 'ACCBOOKID')) AS VPD_CONTEXT FROM DUAL";
    public static final String SET_VPD_YEAR_COMPID = "BEGIN\nvPD_PKG.SET_CONTEXT_VPD_YEAR(''{0}'');vPD_PKG.SET_CONTEXT_COMPID(''{1}'');\nEND;";
    public static final String SET_VPD_YEAR_COMPID_ACCBOOKID = "BEGIN\nvPD_PKG.SET_CONTEXT_VPD_YEAR(''{0}'');vPD_PKG.SET_CONTEXT_COMPID(''{1}'');VPD_PKG.SET_CONTEXT_ACCBOOKID(''{2}'');\nEND;";
    public static final String VPD_DISABLE = "-1";
    public static final String VPD_STATE_DISABLE = "0";
    public static final String VPD_STATE_ENABLE = "1";
    public static final String LOG_SET_VPD_COMPID_STATUS = "\u542f\u7528vpd\u7ebf\u7a0b\u53d8\u91cf:{0}\u548c{1}\u6210\u529f!";
    public static final String LOG_SET_VPD_COMPID_YEAR = "\u542f\u7528vpd\u7ebf\u7a0b\u53d8\u91cf:{0}\u548c{1}\u6210\u529f!";
    public static final String LOG_SET_VPD_COMPID_YEAR_ACCBOOKID = "\u542f\u7528vpd\u7ebf\u7a0b\u53d8\u91cf:{0}\u548c{1}\u548c{2}\u6210\u529f!";
    public static final String LOG_DISABLE_VPD = "\u505c\u7528VPD\u7b56\u7565:{0}\u6210\u529f!";
    public static final String LOG_GET_VPD_COMPID = "\u83b7\u53d6VPD_COMPID\u73af\u5883\uff1a{0}\u6210\u529f!";
    public static final String LOG_GET_VPD_STATE = "\u83b7\u53d6VPD_STATE\u73af\u5883\uff1a{0}\u6210\u529f!";
    public static final String LOG_GET_VPD_YEAR = "\u83b7\u53d6VPD_YEAR\u73af\u5883\uff1a{0}\u6210\u529f!";
    public static final String LOG_GET_VPD_ACCBOOKID = "\u83b7\u53d6ACCBOOKID\u73af\u5883\uff1a{0}\u6210\u529f!";
    public static final String KEY_VPDYEAR = "ECP_VPDYEAR";
    public static final String KEY_VPDCOMPID = "ECP_VPDCOMPID";
    public static final String KEY_VPDBOOKID = "ECP_VPDBOOKID";

    private VPDUtil() {
    }

    public static boolean isVPDEnabled() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            List<Object> vpd = VPDUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(GET_VPD_COMPID, Object.class);
            return vpd != null && vpd.size() > 0 && StringUtil.isNotEmptyString(vpd.get(0).toString());
        }
        return false;
    }

    public static void setVPDCompIDEnabledBeginTrancaction(String compId) {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                if (ValidatorUtil.checkSQLInjectionAttack(compId)) {
                    throw new DataaccessException("compId[" + compId + "]\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u653b\u51fb\u98ce\u9669\uff01");
                }
                String sql = MessageFormat.format(SET_VPD_COMPID, compId);
                VPDUtil.getSqlTemplateNotCheckTransaction().executeSQL(sql);
                if (VPDUtil.isOpenBizLog()) {
                    LOG.info(MessageFormat.format(LOG_SET_VPD_COMPID, compId));
                }
            } else {
                ThreadLocalUtil.set(KEY_VPDCOMPID, compId);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    public static void setVPDCompIDEnabled(String compId) {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                if (ValidatorUtil.checkSQLInjectionAttack(compId)) {
                    throw new DataaccessException("compId[" + compId + "]\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u653b\u51fb\u98ce\u9669\uff01");
                }
                String sql = MessageFormat.format(SET_VPD_COMPID, compId);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                LOG.info(MessageFormat.format(LOG_SET_VPD_COMPID, compId));
            } else {
                ThreadLocalUtil.set(KEY_VPDCOMPID, compId);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    public static void setVPDCompIDEnabledInTransaction(String compId) {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                if (ValidatorUtil.checkSQLInjectionAttack(compId)) {
                    throw new DataaccessException("compId[" + compId + "]\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u653b\u51fb\u98ce\u9669\uff01");
                }
                String sql = MessageFormat.format(SET_VPD_COMPID, compId);
                ISQLTemplate sqlTemplate = VPDUtil.getSqlTemplateInTransaction();
                if (sqlTemplate == null) {
                    LOG.info("\u5f53\u524d\u8bf7\u6c42\u65e0\u4e8b\u52a1\uff0c\u4e0d\u8fdb\u884cVPD\u7684\u5207\u6362");
                    return;
                }
                sqlTemplate.executeSQL(sql);
                if (LOG.isDebugEnabled()) {
                    LOG.info(MessageFormat.format(LOG_SET_VPD_COMPID, compId));
                }
            } else {
                ThreadLocalUtil.set(KEY_VPDCOMPID, compId);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static void setVPDStatusEnabled() {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                VPDUtil.getSqlTemplate().executeSQL(SET_VPD_ENABLE);
                LOG.info(LOG_SET_VPD_ENABLE);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static void setVPDStatusDisabled() {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                VPDUtil.getSqlTemplate().executeSQL(SET_VPD_DISABLE);
                LOG.info(LOG_DISABLE_VPD);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static void setVPDStatusAndCompId(String compId, boolean status) {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                String sql = status ? MessageFormat.format(SET_VPD_COMPID_STATE_ENABLE, compId) : MessageFormat.format(SET_VPD_COMPID_STATE_DISABLE, compId);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                if (LOG.isInfoEnabled()) {
                    String statu = status ? VPD_STATE_ENABLE : VPD_STATE_DISABLE;
                    LOG.info(MessageFormat.format("\u542f\u7528vpd\u7ebf\u7a0b\u53d8\u91cf:{0}\u548c{1}\u6210\u529f!", compId, statu));
                }
            } else {
                VPDUtil.setVPDCompIDEnabled(compId);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static String getVPDStatus() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            List<Object> data = VPDUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(GET_VPD_STATE, Object.class);
            String result = data.get(0).toString();
            LOG.info(MessageFormat.format(LOG_GET_VPD_STATE, result));
            return result;
        }
        return null;
    }

    static void setVPDCompIDDisabled() {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                String sql = MessageFormat.format(SET_VPD_COMPID, VPD_DISABLE);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                LOG.info(MessageFormat.format(LOG_DISABLE_VPD, "compid"));
            } else {
                ThreadLocalUtil.set(KEY_VPDCOMPID, VPD_DISABLE);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    public static String getVPDCompID() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            List<Object> data = VPDUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(GET_VPD_COMPID, Object.class);
            String result = data.get(0).toString();
            LOG.info(MessageFormat.format(LOG_GET_VPD_COMPID, result));
            return result;
        }
        String vpdCompid = (String)ThreadLocalUtil.get(KEY_VPDCOMPID);
        if (StringUtil.isEmptyString(vpdCompid)) {
            try {
                Class cls = ClassUtil.getClass("com.ygsoft.ecp.core.service.dataaccess.vpd.VPDCompIDSetter");
                String contextCompid = (String)ClassUtil.callMethod(cls, "getContextCompId", null);
                ThreadLocalUtil.set(KEY_VPDCOMPID, contextCompid);
                return contextCompid;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return vpdCompid;
    }

    public static void setVPDYearEnabled(String year) {
        if (StringUtil.isEmptyString(year)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u4f20\u5165year\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u9000\u51fa");
            }
            return;
        }
        String curyear = year.replaceAll("-", "");
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            if (ValidatorUtil.checkSQLInjectionAttack(curyear)) {
                throw new DataaccessException("\u53c2\u6570year[" + curyear + "]\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u653b\u51fb\u98ce\u9669\uff01");
            }
            String sql = MessageFormat.format(SET_VPD_YEAR, curyear);
            VPDUtil.getSqlTemplate().executeSQL(sql);
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(LOG_SET_VPD_YEAR, curyear));
            }
        } else {
            String vpdYear = null;
            if (year.length() == 4) {
                vpdYear = year + "0101";
            } else if (year.length() == 6) {
                vpdYear = year + "01";
            } else if (year.length() == 8) {
                vpdYear = year;
            }
            ThreadLocalUtil.set(KEY_VPDYEAR, vpdYear);
        }
    }

    public static void setVPDYearDisabled() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            String sql = MessageFormat.format(SET_VPD_YEAR, VPD_DISABLE);
            VPDUtil.getSqlTemplate().executeSQL(sql);
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(LOG_DISABLE_VPD, "year"));
            }
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String vpdYear = sdf.format(new Date());
            ThreadLocalUtil.set(KEY_VPDYEAR, vpdYear);
        }
    }

    public static String getVPDYear() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            List<Object> data = VPDUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(GET_VPD_YEAR, Object.class);
            String result = data.get(0).toString();
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(LOG_GET_VPD_YEAR, result));
            }
            return result;
        }
        String vpdYear = null;
        if (ThreadLocalUtil.get(KEY_VPDYEAR) == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            vpdYear = sdf.format(new Date());
            ThreadLocalUtil.set(KEY_VPDYEAR, vpdYear);
        } else {
            vpdYear = String.valueOf(ThreadLocalUtil.get(KEY_VPDYEAR));
        }
        return vpdYear;
    }

    public static void setVPDACCBOOKIDEnabled(String accBookId) {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            if (ValidatorUtil.checkSQLInjectionAttack(accBookId)) {
                throw new DataaccessException("\u53c2\u6570accBookId[" + accBookId + "]\u8f93\u5165\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5b58\u5728SQL\u6ce8\u5165\u653b\u51fb\u98ce\u9669\uff01");
            }
            String sql = MessageFormat.format(SET_VPD_ACCBOOKID, accBookId);
            VPDUtil.getSqlTemplate().executeSQL(sql);
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(LOG_SET_VPD_ACCBOOKID, accBookId));
            }
        } else {
            ThreadLocalUtil.set(KEY_VPDBOOKID, accBookId);
        }
    }

    public static void setVPDACCBOOKIDDisabled() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            String sql = MessageFormat.format(SET_VPD_ACCBOOKID, VPD_DISABLE);
            VPDUtil.getSqlTemplate().executeSQL(sql);
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(LOG_DISABLE_VPD, "AccBooKID"));
            }
        }
    }

    public static String getVPDACCBOOKID() {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            List<Object> data = VPDUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(GET_VPD_ACCBOOKID, Object.class);
            String result = data.get(0).toString();
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(LOG_GET_VPD_ACCBOOKID, result));
            }
            return result;
        }
        String bookId = (String)ThreadLocalUtil.get(KEY_VPDBOOKID);
        if (StringUtil.isEmptyString(bookId)) {
            bookId = VPD_STATE_DISABLE;
            ThreadLocalUtil.set(KEY_VPDBOOKID, VPD_STATE_DISABLE);
        }
        return bookId;
    }

    static void setVPDCompIDAndYearEnabled(String compId, String year) {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                String sql = MessageFormat.format(SET_VPD_YEAR_COMPID, year, compId);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                if (LOG.isInfoEnabled()) {
                    LOG.info(MessageFormat.format("\u542f\u7528vpd\u7ebf\u7a0b\u53d8\u91cf:{0}\u548c{1}\u6210\u529f!", compId, year));
                }
            } else {
                VPDUtil.setVPDCompIDEnabled(compId);
                VPDUtil.setVPDYearEnabled(year);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static void setVPDCompIDAndYearDisabled() {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                String sql = MessageFormat.format(SET_VPD_YEAR_COMPID, VPD_DISABLE, VPD_DISABLE);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                if (LOG.isInfoEnabled()) {
                    LOG.info(MessageFormat.format(LOG_DISABLE_VPD, "compid and year"));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static void setVPDCompIDAndYearAndAccBookIdEnabled(String compId, String year, String accBookId) {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                String sql = MessageFormat.format(SET_VPD_YEAR_COMPID_ACCBOOKID, year, compId, accBookId);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                if (LOG.isInfoEnabled()) {
                    LOG.info(MessageFormat.format(LOG_SET_VPD_COMPID_YEAR_ACCBOOKID, compId, year, accBookId));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    static void setVPDCompIDAndYearAndAccBookIdDisabled() {
        if (VPDUtil.isGapInited()) {
            DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
            if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
                String sql = MessageFormat.format(SET_VPD_YEAR_COMPID, VPD_DISABLE, VPD_DISABLE);
                VPDUtil.getSqlTemplate().executeSQL(sql);
                if (LOG.isInfoEnabled()) {
                    LOG.info(MessageFormat.format(LOG_DISABLE_VPD, "compid and year and accbookid"));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("GAP\u5e73\u53f0\u8fd8\u672a\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u5ffd\u7565VPD\u5207\u6362\u64cd\u4f5c");
        }
    }

    public static void setSqlTemplate(ISQLTemplate newsqlTemplate) {
        sqlTemplate = newsqlTemplate;
    }

    private static ISQLTemplate getSqlTemplate() {
        sqlTemplate = VPDUtil.getSqlTemplateNotCheckTransaction();
        if (!VPDUtil.isTransactional()) {
            throw new DataaccessException("\u5f53\u524d\u73af\u5883\u4e0d\u5728\u4e8b\u52a1\u73af\u5883\u4e2d,\u4e0d\u80fd\u8fdb\u884cVPD\u5207\u6362!");
        }
        return sqlTemplate;
    }

    private static ISQLTemplate getSqlTemplateNotCheckTransaction() {
        if (sqlTemplate == null) {
            sqlTemplate = DBUitl.getSqlTemplate();
        }
        return sqlTemplate;
    }

    private static ISQLTemplate getSqlTemplateInTransaction() {
        sqlTemplate = VPDUtil.getSqlTemplateNotCheckTransaction();
        if (!VPDUtil.isTransactional()) {
            return null;
        }
        return sqlTemplate;
    }

    static boolean isTransactional() {
        return TransactionSynchronizationManager.isSynchronizationActive();
    }

    private static boolean isGapInited() {
        return !gap || "true".equals(System.getProperty("gapInited"));
    }

    public static String getVDPFilter(String funtion, Map<String, Object> parameters) {
        String compid = String.valueOf(parameters.get("COMPID"));
        if (compid == VPD_DISABLE) {
            return "";
        }
        if ("FILTER_DEPLOY_DWDH".equalsIgnoreCase(funtion)) {
            Object service = OSGiUtil.getService("com.ygsoft.ecp.service.dataaccess.IUnitQuery");
            Boolean isManageUnit = (Boolean)ClassUtil.callMethod(service, "isManageUnit", new Object[]{compid});
            if (RuntimeEnvUtil.INSTANCE.getMainCompID().equals(compid)) {
                return "";
            }
            if (isManageUnit.booleanValue()) {
                return "DWDH IN (SELECT B.COMPID,B.COMP_TREE FROM BASIC_ORGANIZATION A,BASIC_ORGANIZATION B WHERE A.COMPID ='" + compid + "' AND B.COMP_TREE LIKE CONCAT(A.COMP_TREE,'%'))";
            }
            return "DWDH = '" + compid + "'";
        }
        if ("FILTER_DEPLOY_SHARE_DXCOMPID".equalsIgnoreCase(funtion)) {
            List<String> result = VPDUtil.getSqlTemplateNotCheckTransaction().findBySQLWithoutRowNumLimit("SELECT FU_ECP_FILTER_SHARE_OBJ_COMPID(:SCHEMA, :TABLE, :COMPID, :ALIAS, :FILTERVAL) AS VPDFILTER FROM DUAL", parameters, String.class);
            return result.get(0);
        }
        if ("FILTER_COMPID".equalsIgnoreCase(funtion)) {
            return "VPD_COMPID = '" + compid + "' ";
        }
        if ("FILTER_DEPLOY_PMANAGECOMPID".equalsIgnoreCase(funtion)) {
            return " SELECT B.COMPID FROM BASIC_ORGANIZATION A,BASIC_ORGANIZATION  B  WHERE A.COMPID = '" + compid + "' AND INSTR(A.COMP_TREE,B.COMP_TREE)=1 AND B.ORGANFLAG=1";
        }
        if ("FILTER_DEPLOY_FLATTR_COMPID".equalsIgnoreCase(funtion)) {
            return " SELECT B.COMPID FROM BASIC_ORGANIZATION A,BASIC_ORGANIZATION  B  WHERE A.COMPID = '" + compid + "' AND INSTR(A.COMP_TREE,B.COMP_TREE)=1 AND B.ORGANFLAG=1";
        }
        if ("FILTER_COMPID_EXT".equalsIgnoreCase(funtion)) {
            return "COMPID = '" + compid + "' ";
        }
        if ("FILTER_DEPLOY_MENU_EXT_COMPID".equalsIgnoreCase(funtion)) {
            return "COMPID IN (SELECT B.COMPID FROM BASIC_ORGANIZATION A,BASIC_ORGANIZATION  B  WHERE A.COMPID = '" + compid + "' AND INSTR(A.COMP_TREE,B.COMP_TREE)=1 AND B.ORGANFLAG=1)";
        }
        if ("FILTER_ASSIGN_COMPID".equalsIgnoreCase(funtion)) {
            Object service = OSGiUtil.getService("com.ygsoft.ecp.service.dataaccess.IUnitQuery");
            Boolean isManageUnit = (Boolean)ClassUtil.callMethod(service, "isManageUnit", new Object[]{compid});
            if (isManageUnit.booleanValue()) {
                return "COMPID IN (SELECT FU_ECP_GET_CONTROLUNIT('" + compid + "') FROM DUAL)";
            }
            return "DXLXID IN (SELECT DXLXID FROM XTGLDXLXASSIGN WHERE COMPID='" + compid + "')";
        }
        if ("FILTER_DEPLOY_XTCS_COMPID".equalsIgnoreCase(funtion)) {
            return "VPD_COMPID = '" + compid + "' ";
        }
        if ("FILTER_GLDXLXLX".equalsIgnoreCase(funtion)) {
            return "DXLXID IN (SELECT DXLXID FROM T_XTGLDXLX WHERE" + VPDUtil.getVDPFilter("FILTER_ASSIGN_COMPID", parameters);
        }
        return "";
    }

    public static void cleanVpd() {
        ThreadLocalUtil.remove(KEY_VPDBOOKID);
        ThreadLocalUtil.remove(KEY_VPDCOMPID);
        ThreadLocalUtil.remove(KEY_VPDYEAR);
    }

    public static boolean isOpenBizLog() {
        return "true".equals(ServerProps.getProperty((String)"bizlogenabled"));
    }

    static {
        block3: {
            gap = false;
            LOG = EcpLogFactory.getLog(VPDUtil.class);
            try {
                boolean bl = gap = ClassUtil.getClass("com.ygsoft.grm.start.internal.GAPInit") != null;
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u5f53\u524d\u670d\u52a1\u5305\u6709\u4f7f\u7528GAP\u5e73\u53f0,\u9700\u8981\u7b49\u5f85GAP\u5e73\u53f0\u542f\u52a8\u5b8c\u6bd5\u624d\u80fd\u8fdb\u884c\u5355\u4f4d\u7b56\u7565\u51fd\u6570\u5207\u6362\u3002");
                }
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info("\u5f53\u524d\u670d\u52a1\u5305\u6ca1\u6709\u4f7f\u7528GAP\u5e73\u53f0\u3002");
            }
        }
    }
}

