/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SysPropUtil
implements IEcpToolLogic {
    private static final Map<String, String> CACHE = new ConcurrentHashMap<String, String>();

    private SysPropUtil() {
    }

    public static String get(String key) {
        if (!StringUtil.isNullOrTrimEmptyString(key)) {
            String value = CACHE.get(key);
            if (value == null && (value = System.getProperty(key)) != null) {
                CACHE.put(key, value);
            }
            return value;
        }
        return null;
    }

    public static String get(String key, String defaultValue) {
        if (!StringUtil.isNullOrTrimEmptyString(key)) {
            return ServerProps.getProperty((String)key, (String)defaultValue);
        }
        return null;
    }

    public static void set(String key, String value) {
        if (!StringUtil.isNullOrTrimEmptyString(key) && !StringUtil.isNullOrTrimEmptyString(value)) {
            CACHE.put(key, value);
            System.setProperty(key, value);
        }
    }

    public static void set(String prop, boolean flag) {
        if (StringUtil.isNullOrTrimEmptyString(prop)) {
            return;
        }
        SysPropUtil.set(prop, String.valueOf(flag));
    }

    public static boolean isTrue(String key) {
        if (StringUtil.isNullOrTrimEmptyString(key)) {
            return false;
        }
        String value = SysPropUtil.get(key);
        return value != null && Boolean.valueOf(value) != false;
    }
}

