/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.internal.i18n.I18nConfig;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18nUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(I18nUtil.class);
    private static final String FILE_PREFIX = "i18n";
    private static final String FILE_SUFFIX = ".properties";
    private static final String DEFAULT_LANGUAGE = "zh_CN";

    private I18nUtil() {
    }

    public static Map<String, Map<String, Object>> getResource(Bundle bundle, String path) {
        if (bundle == null || StringUtils.isEmpty((Object)path)) {
            return null;
        }
        ConcurrentHashMap<String, Map<String, Object>> map = new ConcurrentHashMap<String, Map<String, Object>>();
        I18nUtil.putOrRemoveResource(map, bundle, path, "", false);
        return map;
    }

    public static void putOrRemoveResource(Map<String, Map<String, Object>> resourceMap, Bundle bundle, String resourcePath, String sperator, boolean isRemove) {
        block5: {
            if (resourceMap == null || bundle == null || StringUtils.isEmpty((Object)resourcePath)) {
                return;
            }
            try {
                Enumeration paths = bundle.getEntryPaths(resourcePath);
                if (paths != null) {
                    while (paths.hasMoreElements()) {
                        Map<String, Object> bundleResource;
                        String path = (String)paths.nextElement();
                        if (!path.endsWith(FILE_SUFFIX) || (bundleResource = I18nUtil.loadBundleResource(bundle, path, sperator)) == null) continue;
                        String localeStr = I18nUtil.getLocaleStr(path);
                        I18nUtil.putOrRemove(resourceMap, localeStr, bundleResource, isRemove);
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error("\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90\u6587\u4ef6\u9519\u8bef", ex);
            }
        }
    }

    private static void putOrRemove(Map<String, Map<String, Object>> map, String localeStr, Map<String, Object> v, boolean isRemove) {
        if (StringUtil.isEmpty(localeStr)) {
            return;
        }
        if (!I18nConfig.getInstance().getLangMap().containsKey(localeStr)) {
            return;
        }
        if (!isRemove) {
            if (v != null) {
                if (map.containsKey(localeStr)) {
                    map.get(localeStr).putAll(v);
                } else {
                    map.put(localeStr, v);
                }
            }
        } else if (map.containsKey(localeStr)) {
            Iterator<String> it = map.keySet().iterator();
            while (it.hasNext()) {
                map.get(localeStr).remove(it.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(Bundle bundle, String path) {
        String string;
        block11: {
            InputStream in;
            block9: {
                String string2;
                block10: {
                    if (bundle == null || path == null) {
                        return null;
                    }
                    in = null;
                    URL url = bundle.getEntry(path);
                    URLConnection connection = url.openConnection();
                    if (connection.getContentType() == null) {
                        ClassUtil.setAttribute(connection, "contentType", "application/text;charset=utf-8");
                    }
                    if ((in = (InputStream)connection.getContent()) == null) break block9;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    StringBuffer sb = new StringBuffer();
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        line = br.readLine();
                    }
                    string2 = sb.toString();
                    Object var10_11 = null;
                    if (in == null) break block10;
                    StreamUtil.closeStream(in);
                }
                return string2;
            }
            try {
                string = null;
                Object var10_12 = null;
                if (in == null) break block11;
            }
            catch (Exception e) {
                String string3;
                block12: {
                    try {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("\u8bfb\u53d6bundle\u4e0b\u7684\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
                        }
                        string3 = null;
                        Object var10_13 = null;
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block13: {
                            Object var10_14 = null;
                            if (in == null) break block13;
                            StreamUtil.closeStream(in);
                        }
                        throw throwable;
                    }
                    StreamUtil.closeStream(in);
                }
                return string3;
            }
            StreamUtil.closeStream(in);
        }
        return string;
    }

    public static String getLocaleStr(Locale locale) {
        if (locale == null) {
            return DEFAULT_LANGUAGE;
        }
        try {
            locale.hashCode();
        }
        catch (Throwable e) {
            return DEFAULT_LANGUAGE;
        }
        String country = locale.getCountry();
        String language = locale.getLanguage();
        if (!StringUtils.isEmpty((Object)country) && !StringUtils.isEmpty((Object)language)) {
            return language.toLowerCase() + "_" + country.toUpperCase();
        }
        return DEFAULT_LANGUAGE;
    }

    public static Locale getLocale(String localeStr) {
        if (StringUtils.hasText((String)localeStr)) {
            int pos = localeStr.indexOf("_");
            if (pos == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("\u4e0d\u7b26\u5408\u56fd\u9645\u5316\u89c4\u8303\u7684\u8bed\u8a00\u5b57\u7b26\u4e32,localeStr=" + localeStr);
                }
                return null;
            }
            String country = localeStr.substring(0, pos);
            String language = localeStr.substring(pos + 1);
            try {
                return new Locale(country, language);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u4e0d\u7b26\u5408\u56fd\u9645\u5316\u89c4\u8303\u7684\u8bed\u8a00\u5b57\u7b26\u4e32,localeStr=" + localeStr);
                }
                return null;
            }
        }
        return null;
    }

    public static String getLocaleStr(String path) {
        int end;
        if (StringUtils.isEmpty((Object)path)) {
            return DEFAULT_LANGUAGE;
        }
        String locale = DEFAULT_LANGUAGE;
        int start = path.lastIndexOf(FILE_PREFIX) + FILE_PREFIX.length() + 1;
        if (start < (end = path.indexOf(FILE_SUFFIX))) {
            locale = path.substring(start, end);
            int pos = locale.indexOf("_");
            if (pos >= 0) {
                locale = locale.substring(0, pos).toLowerCase() + locale.substring(pos).toUpperCase();
            } else if (LOG.isInfoEnabled()) {
                LOG.info("\u56fd\u9645\u5316\u8d44\u6e90\u6587\u4ef6\u547d\u540d\u4e0d\u7b26\u5408\u89c4\u8303 path = " + path + ",locale = " + locale);
            }
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> loadBundleResource(Bundle bundle, String path, String sperator) {
        InputStream in;
        block9: {
            Map<String, Object> map;
            if (bundle == null) return null;
            if (StringUtils.isEmpty((Object)path)) {
                return null;
            }
            in = null;
            try {
                try {
                    URL url = bundle.getEntry(path);
                    URLConnection connection = url.openConnection();
                    if (connection.getContentType() == null) {
                        ClassUtil.setAttribute(connection, "contentType", "application/text;charset=utf-8");
                    }
                    if ((in = (InputStream)connection.getContent()) == null) break block9;
                    map = I18nUtil.loadProperties(in, sperator);
                    Object var8_8 = null;
                    if (in == null) return map;
                }
                catch (IOException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", e);
                    }
                    Object var8_10 = null;
                    if (in == null) return null;
                    StreamUtil.closeStream(in);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (in == null) throw throwable;
                StreamUtil.closeStream(in);
                throw throwable;
            }
            StreamUtil.closeStream(in);
            return map;
        }
        Object var8_9 = null;
        if (in == null) return null;
        StreamUtil.closeStream(in);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadProperties(InputStream inputStream, String sperator) {
        ConcurrentHashMap<String, Object> map;
        block6: {
            if (inputStream == null) {
                return null;
            }
            Properties properties = null;
            map = null;
            try {
                try {
                    properties = new Properties();
                    properties.load(inputStream);
                    if (properties.size() > 0) {
                        map = new ConcurrentHashMap<String, Object>();
                        I18nUtil.fillMap(map, properties, sperator);
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    StreamUtil.closeStream(inputStream);
                    properties.clear();
                    properties = null;
                    throw throwable;
                }
                StreamUtil.closeStream(inputStream);
                properties.clear();
                properties = null;
                {
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error("\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", e);
            }
        }
        return map;
    }

    private static void fillMap(Map<String, Object> map, Properties properties, String sperator) {
        Object value = null;
        Iterator<Map.Entry<Object, Object>> it = properties.entrySet().iterator();
        if (StringUtils.isEmpty((Object)sperator)) {
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                value = entry.getValue();
                if (value == null) continue;
                map.put((String)entry.getKey(), value);
            }
        } else {
            String uri = null;
            int pos = 0;
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                if (!I18nUtil.isKeyValid(key, sperator)) continue;
                pos = key.indexOf(sperator);
                uri = key.substring(0, pos);
                String realKey = key.substring(pos + 1);
                value = entry.getValue();
                if (value == null) continue;
                if (map.containsKey(uri)) {
                    ((Map)map.get(uri)).put(realKey, value);
                    continue;
                }
                ConcurrentHashMap<String, Object> object = new ConcurrentHashMap<String, Object>();
                object.put(realKey, value);
                map.put(uri, object);
            }
        }
    }

    private static boolean isKeyValid(String key, String sperator) {
        int pos = key.indexOf(sperator);
        if (pos != -1) {
            String before = key.substring(0, pos);
            String after = key.substring(pos + 1);
            if (StringUtils.isEmpty((Object)before)) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("\u8d44\u6e90\u6587\u4ef6properties\u4e2d\u7684key\u4e0d\u7b26\u5408\u89c4\u8303,\u5206\u9694\u7b26\u524d\u534a\u90e8\u5206\u4e3a\u7a7a,key=" + key);
                }
                return false;
            }
            if (StringUtils.isEmpty((Object)after)) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("\u8d44\u6e90\u6587\u4ef6properties\u4e2d\u7684key\u4e0d\u7b26\u5408\u89c4\u8303,\u5206\u9694\u7b26\u540e\u534a\u90e8\u5206\u4e3a\u7a7a\uff0ckey=" + after);
                }
                return false;
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.error("\u8d44\u6e90\u6587\u4ef6properties\u4e2d\u7684key\u4e0d\u7b26\u5408\u89c4\u8303,key=" + key);
        }
        return false;
    }

    public static Object getResource(Map<String, Map<String, Object>> map, Locale locale, String key) {
        if (map == null) {
            return null;
        }
        Map<String, Object> m = map.get(I18nUtil.getLocaleStr(locale));
        if (m != null) {
            return m.get(key);
        }
        return null;
    }

    public static String convert(Locale locale, String str, Map<String, Map<String, Object>> resource) {
        if (resource == null || StringUtils.isEmpty((Object)str)) {
            return str;
        }
        String res = null;
        String localeStr = I18nUtil.getLocaleStr(locale);
        Map<String, Object> map = resource.get(localeStr);
        if (map != null) {
            Object value = null;
            res = str;
            Matcher m = Pattern.compile("[{]{2}(.*?)[}]{2}").matcher(str);
            while (m.find()) {
                String key = m.group(1);
                value = map.get(key);
                if (value == null) continue;
                res = res.replace("{{" + key + "}}", (String)value);
            }
        }
        return res;
    }
}

