/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.dataaccess.IHibernateTemplate;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.dataaccess.IStatelessSession;
import com.ygsoft.ecp.service.dataaccess.SessionFactoryManager;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.SysPropUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionImpl;
import org.springframework.aop.support.AopUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBUtil
implements IEcpToolLogic {
    private DBUtil() {
    }

    public static String getShareSchema() {
        return DBUitl.getShareSchema();
    }

    public static void closeConnection(Connection conn) {
        DBUitl.closeConnection(conn);
    }

    public static void closeConnStatementResultSet(Connection conn, Statement stat, ResultSet rs) {
        DBUitl.closeConnStatementResultSet(conn, stat, rs);
    }

    public static Timestamp getDatabaseDate(String sql) {
        return DBUitl.getDatabaseDate(sql);
    }

    public static IHibernateTemplate getHibernateTemplate() {
        return DBUitl.getHibernateTemplate();
    }

    public static ISQLTemplate getSqlTemplate() {
        return DBUitl.getSqlTemplate();
    }

    public static IStatelessSession getSqlStateless() {
        return OSGiUtil.getService(IStatelessSession.class);
    }

    public static String transBitAndSqlString(String x, String y) {
        return DBUitl.transBitAndSqlString(x, y);
    }

    public static boolean isOracle() {
        return DBUitl.isOracle();
    }

    public static boolean isDM() {
        return DBUitl.isDM();
    }

    public static boolean isH2() {
        return DBUitl.isH2();
    }

    public static boolean isMySql() {
        DatabaseType dbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        return dbType.equals((Object)DatabaseType.MySql);
    }

    public static String getFunctionName(String name) {
        if (DBUtil.isMySql()) {
            return StringUtil.replaceAll(name, ".", "_");
        }
        return name;
    }

    public static Map<String, Object> buildProcedureParameterMap() {
        if (SysPropUtil.isTrue("sgcc.nds.jdbc.driver.NdsDriver")) {
            return new LinkedHashMap<String, Object>();
        }
        return new HashMap<String, Object>();
    }

    public static int executeBatchSql(String[] sqls) {
        return DBUitl.getSqlTemplate().executeBatchSql(sqls);
    }

    public static Connection getConnection() {
        Connection conn = DBUtil.getCurrentConnection();
        try {
            if (conn == null || conn.isClosed()) {
                conn = ((DataSource)SpringContextHolder.INSTANCE.getApplicationContext().getBean("dataSource")).getConnection();
            }
        }
        catch (Throwable e) {
            return null;
        }
        return conn;
    }

    public static Connection getCurrentConnection() {
        Connection conn = null;
        try {
            Session proxy;
            Object sessionImpl = proxy = DBUtil.getCurrentSession();
            if (AopUtils.isAopProxy((Object)proxy)) {
                Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
                h.setAccessible(true);
                Object aopProxy = h.get(proxy);
                sessionImpl = ClassUtil.getAttribute(aopProxy, "target");
            }
            if (sessionImpl instanceof SessionImpl) {
                conn = ((SessionImpl)sessionImpl).connection();
                return conn;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Session getCurrentSession() {
        Session currentsession = null;
        SessionFactory sf = SessionFactoryManager.INSTANCE.getFactoryForTransactionSync();
        if (sf != null) {
            Object entityManagerFactory = OSGiUtil.getSpringBean("entityManagerFactory");
            Object value = TransactionSynchronizationManager.getResource((Object)entityManagerFactory);
            currentsession = value instanceof EntityManagerHolder && DBUitl.isbindJpaTransaction() ? (Session)((EntityManagerHolder)value).getEntityManager().unwrap(Session.class) : sf.getCurrentSession();
        }
        return currentsession;
    }
}

