/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.internal.tool.Assert;
import com.ygsoft.ecp.service.internal.tool.PrimitiveTypeDefault;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ArrayUtil;
import com.ygsoft.ecp.service.tool.ConvertUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.exception.FindException;
import com.ygsoft.ecp.service.tool.exception.ReflectException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.scannotation.AnnotationDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil
implements IEcpToolLogic {
    private static IEcpLog log = EcpLogFactory.getLog(ClassUtil.class);
    private static final char NAMESEP = '.';
    private static final char KEYSEP = '_';
    private static final String CACHEDNAME = StringUtil.genCacheName("system", "class");
    private static final String CLASSFIELDKEY = StringUtil.genCacheName("system", "field");
    private static final String CLASSMETHODKEY = StringUtil.genCacheName("system", "method");
    private static ICache<String, Map> instanceCache;
    private static ICache<String, Map> methodInstanceCache;
    private static ICache<String, Map> fieldMapCache;
    private static ICache<String, Map> fieldCache;
    private static final Class[] EMPTYTYPES;
    public static final Object[] EMPTY;
    private static final String NUMBERREGEXP = "^[-+]?\\d+(\\.\\d+)?$";
    private static final String PROPERTYPREFIX = ".property";
    private static final String FIELDMAPCACHEKEY;
    private static final String INCLUDESUPPERCLASS = "_INCLUDESUPPER";
    private static final Object[] EMPTYARGS;

    private ClassUtil() {
    }

    private static ICache<String, Map> getInstanceCache() {
        if (instanceCache == null) {
            instanceCache = EcpService.getCacheService(CACHEDNAME);
        }
        return instanceCache;
    }

    private static ICache<String, Map> getMethodInstanceCache() {
        if (methodInstanceCache == null) {
            methodInstanceCache = EcpService.getCacheService(CLASSMETHODKEY);
        }
        return methodInstanceCache;
    }

    private static ICache<String, Map> getFieldMapCache() {
        if (fieldMapCache == null) {
            fieldMapCache = EcpService.getCacheService(FIELDMAPCACHEKEY);
        }
        return fieldMapCache;
    }

    private static ICache<String, Map> getFieldCache() {
        if (fieldCache == null) {
            fieldCache = EcpService.getCacheService(CLASSFIELDKEY);
        }
        return fieldCache;
    }

    public static Map<String, Method> getInstanceMethodMap(Class cls) {
        try {
            int i;
            String keyName = cls.getName();
            ICache<String, Map> cache = ClassUtil.getMethodInstanceCache();
            ConcurrentHashMap<String, Method> methodMap = null;
            if (cache != null) {
                methodMap = cache.get(keyName);
            }
            if (methodMap != null) {
                return methodMap;
            }
            methodMap = new ConcurrentHashMap<String, Method>();
            Method[] ms = cls.getMethods();
            Method md = null;
            for (i = 0; i < ms.length; ++i) {
                md = ms[i];
                methodMap.put(ClassUtil.getMethodNumberKey(md), md);
                methodMap.put(ClassUtil.getMethodKey(md), md);
                methodMap.put(md.getName(), md);
            }
            ms = cls.getDeclaredMethods();
            for (i = 0; i < ms.length; ++i) {
                md = ms[i];
                methodMap.put(ClassUtil.getMethodNumberKey(md), md);
                methodMap.put(ClassUtil.getMethodKey(md), md);
                methodMap.put(md.getName(), md);
            }
            if (cache != null) {
                cache.put(keyName, methodMap);
            }
            return methodMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class getClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static String getMethodNumberKey(Method method) {
        return ClassUtil.comboMethodNumberKey(method.getName(), method.getParameterTypes().length);
    }

    public static String comboMethodNumberKey(String methodName, int paramCount) {
        return new StringBuffer().append(methodName).append('_').append(paramCount).toString();
    }

    public static Method getMethod(Object instance, String methodName, Class[] paramTypes) {
        Assert.check(instance != null);
        return ClassUtil.getMethod(instance.getClass(), methodName, paramTypes);
    }

    public static Method getMethod(Class cls, String methodName, Class[] pTypes) {
        Assert.check(cls != null);
        Class[] paramTypes = pTypes;
        if (paramTypes == null) {
            paramTypes = EMPTYTYPES;
        }
        try {
            Map<String, Method> methodMap = ClassUtil.getInstanceMethodMap(cls);
            String key = ClassUtil.comboMethodKey(methodName, paramTypes);
            Method md = methodMap.get(key);
            if (md != null) {
                return md;
            }
            key = ClassUtil.comboMethodNumberKey(methodName, paramTypes.length);
            return methodMap.get(key);
        }
        catch (SecurityException e) {
            throw new ReflectException("E0208.0005", EcpI18nUtil.localizedString("E0208.0005", "method\u83b7\u53d6\u5931\u8d25"), e, new Object[0]);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn(e.getMessage());
            }
            return null;
        }
    }

    public static String getMethodKey(Method method) {
        Assert.check(method != null);
        String name = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        return ClassUtil.comboMethodKey(name, paramTypes);
    }

    public static String comboMethodKey(String methodName, Class[] argsType) {
        return new StringBuffer().append(methodName).append('_').append(ArrayUtil.toString(argsType)).toString();
    }

    public static Map<String, Method> getMethods(Class cls) {
        Map<String, Method> methodMap = ClassUtil.getInstanceMethodMap(cls);
        return methodMap;
    }

    public static Map getInstancePropertyMap(Object instance) {
        Assert.check(instance != null);
        return ClassUtil.getInstancePropertyMap(instance.getClass());
    }

    public static Map getInstancePropertyMap(Class cls) {
        try {
            String keyName = cls.getName();
            ConcurrentHashMap<String, PropertyDescriptor> attrsMap = null;
            ICache<String, Map> cache = ClassUtil.getInstanceCache();
            if (cache != null) {
                attrsMap = cache.get(keyName);
            }
            if (attrsMap != null) {
                return attrsMap;
            }
            attrsMap = new ConcurrentHashMap<String, PropertyDescriptor>();
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] ps = bi.getPropertyDescriptors();
            PropertyDescriptor pd = null;
            for (int i = 0; i < ps.length; ++i) {
                pd = ps[i];
                attrsMap.put(pd.getName().toUpperCase(), pd);
            }
            if (cache != null) {
                cache.put(keyName, attrsMap);
            }
            return attrsMap;
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object instance, String name) {
        return ClassUtil.getPropertyDescriptor(instance.getClass(), name);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class cls, String name) {
        String propName = name.toUpperCase();
        Map map = ClassUtil.getInstancePropertyMap(cls);
        return (PropertyDescriptor)map.get(propName);
    }

    public static Class getPropertyClass(Class cls, String name) {
        PropertyDescriptor pd = ClassUtil.getPropertyDescriptor(cls, name);
        if (pd != null) {
            return pd.getPropertyType();
        }
        return null;
    }

    public static Class getPropertyClass(Object instance, String name) {
        PropertyDescriptor pd = ClassUtil.getPropertyDescriptor(instance, name);
        if (pd != null) {
            return pd.getPropertyType();
        }
        return null;
    }

    public static String getClassSimpleName(Class cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static String getClassSimpleName(String className) {
        if (className == null) {
            return null;
        }
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static Object createObject(Class cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new ReflectException("E0208.0006", EcpI18nUtil.localizedString("E0208.0006", "\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static Object createObject(String className) {
        try {
            Class<?> cls = null;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cls != null) {
                return cls.newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new ReflectException("E0208.0006", EcpI18nUtil.localizedString("E0208.0006", "\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static Object createObject(Class cls, Object[] constructorParams) {
        try {
            if (constructorParams == null) {
                return ClassUtil.createObject(cls);
            }
            Class[] paramsClass = new Class[constructorParams.length];
            for (int i = 0; i < constructorParams.length; ++i) {
                paramsClass[i] = constructorParams[i] != null ? constructorParams[i].getClass() : Object.class;
            }
            Constructor cst = cls.getConstructor(paramsClass);
            if (cst != null) {
                return cst.newInstance(constructorParams);
            }
            return null;
        }
        catch (Exception e) {
            throw new ReflectException("E0208.0006", EcpI18nUtil.localizedString("E0208.0006", "\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25"), e, new Object[0]);
        }
    }

    public static Map getClassFieldMap(Class cls) {
        ConcurrentHashMap<String, Field> map = new ConcurrentHashMap<String, Field>();
        Field[] fields = cls.getDeclaredFields();
        Field fld = null;
        for (int i = 0; i < fields.length; ++i) {
            fld = fields[i];
            map.put(fld.getName(), fld);
        }
        return map;
    }

    public static Field getClassField(Class cls, String name) {
        ICache<String, Map> cache = ClassUtil.getFieldCache();
        String key = cls.getName();
        Map map = null;
        if (cache != null) {
            map = cache.get(key);
        }
        if (map == null) {
            map = ClassUtil.getClassFieldMap(cls);
            if (cache != null) {
                cache.put(key, map);
            }
        }
        return (Field)map.get(name);
    }

    public static Field getClassFieldIncludeSuperClass(Class cls, String name) {
        Field fld = ClassUtil.getClassField(cls, name);
        if (fld == null) {
            for (Class parentCls = cls.getSuperclass(); parentCls != null && (fld = ClassUtil.getClassField(parentCls, name)) == null; parentCls = parentCls.getSuperclass()) {
            }
        }
        return fld;
    }

    public static Field getClassFieldIncludeSuperClass(Class cls, String name, Class endSuperClass) {
        Field fld = ClassUtil.getClassField(cls, name);
        if (fld == null) {
            for (Class parentCls = cls.getSuperclass(); parentCls != endSuperClass && (fld = ClassUtil.getClassField(parentCls, name)) == null; parentCls = parentCls.getSuperclass()) {
            }
        }
        return fld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getStaticAttribute(Class<?> cls, String attrName, boolean includeSuperClass) {
        Field field = includeSuperClass ? ClassUtil.getClassFieldIncludeSuperClass(cls, attrName) : ClassUtil.getClassField(cls, attrName);
        if (field == null) return null;
        if (!Modifier.isStatic(field.getModifiers())) return null;
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            Object object;
            try {
                object = field.get(null);
                Object var7_8 = null;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                Object var7_9 = null;
                field.setAccessible(accessible);
                return null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var7_10 = null;
                field.setAccessible(accessible);
                return null;
            }
            field.setAccessible(accessible);
            return object;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            field.setAccessible(accessible);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStaticAttribute(Class<?> cls, String attrName, Object value, boolean includeSuperClass) {
        block6: {
            Field field = includeSuperClass ? ClassUtil.getClassFieldIncludeSuperClass(cls, attrName) : ClassUtil.getClassField(cls, attrName);
            if (field != null && Modifier.isStatic(field.getModifiers())) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    try {
                        field.set(null, value);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        Object var8_7 = null;
                        field.setAccessible(accessible);
                        break block6;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        Object var8_8 = null;
                        field.setAccessible(accessible);
                    }
                    Object var8_6 = null;
                    field.setAccessible(accessible);
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    field.setAccessible(accessible);
                    throw throwable;
                }
            }
        }
    }

    public static Object getAttribute(Object obj, String attrName) {
        PropertyDescriptor pd = ClassUtil.getPropertyDescriptor(obj, attrName);
        if (pd != null) {
            Method md = pd.getReadMethod();
            if (md != null) {
                try {
                    return md.invoke(obj, EMPTY);
                }
                catch (Exception e) {
                    throw new ReflectException("E0208.0004", EcpI18nUtil.localizedString("E0208.0004", "\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25"), e, new Object[0]);
                }
            }
            throw new ReflectException("E0208.0004", EcpI18nUtil.localizedString("E0208.0004", "\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25"));
        }
        Field field = ClassUtil.getClassFieldIncludeSuperClass(obj.getClass(), attrName);
        if (field != null) {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                Object object = field.get(obj);
                Object var7_9 = null;
                return object;
            }
            catch (Exception e) {
                try {
                    throw new ReflectException("E0208.0004", EcpI18nUtil.localizedString("E0208.0004", "\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25"), e, new Object[0]);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    throw throwable;
                }
            }
        }
        return null;
    }

    public static void setAttribute(Object obj, String attrName, Object value) {
        Method md = null;
        PropertyDescriptor pd = ClassUtil.getPropertyDescriptor(obj, attrName);
        if (pd != null) {
            md = pd.getWriteMethod();
        }
        if (md != null) {
            try {
                md.invoke(obj, ConvertUtil.toClassObject(value, pd.getPropertyType()));
            }
            catch (Exception e) {
                throw new ReflectException("E0208.0004", EcpI18nUtil.localizedString("E0208.0004", "\u8bbe\u7f6e\u5bf9\u8c61\u5c5e\u6027\u503c\u5931\u8d25"), e, new Object[0]);
            }
        }
        Field field = ClassUtil.getClassFieldIncludeSuperClass(obj.getClass(), attrName);
        if (field != null) {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                try {
                    field.set(obj, value);
                }
                catch (Exception e) {
                    throw new ReflectException("E0208.0004", EcpI18nUtil.localizedString("E0208.0004", "\u8bbe\u7f6e\u5bf9\u8c61\u5c5e\u6027\u503c\u5931\u8d25"), e, new Object[0]);
                }
                Object var9_8 = null;
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!accessible) {
                    field.setAccessible(false);
                }
                throw throwable;
            }
        }
    }

    public static Object[] getValues(Object object, String[] properties) {
        Object[] results = new Object[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            results[i] = ClassUtil.getAttribute(object, properties[i]);
        }
        return results;
    }

    public static Object getPrimitiveTypeDefaultObject(Class cls) {
        return PrimitiveTypeDefault.getPrimitiveNullObject(cls);
    }

    public static boolean isNullOrPrimitiveDefault(Object obj, Class cls) {
        if (obj == null) {
            return true;
        }
        Class<?> tmpCls = cls;
        if (tmpCls == null) {
            tmpCls = obj.getClass();
        }
        if (tmpCls.isPrimitive()) {
            return obj.equals(ClassUtil.getPrimitiveTypeDefaultObject(tmpCls));
        }
        return false;
    }

    public static Object getFieldValue(Object object, String name) {
        Field fld = ClassUtil.getClassFieldIncludeSuperClass(object.getClass(), name);
        if (fld != null) {
            try {
                fld.setAccessible(true);
                return fld.get(object);
            }
            catch (Exception e) {
                throw new ReflectException("E0208.0004", EcpI18nUtil.localizedString("E0208.0004", "\u83b7\u53d6\u67d0\u5bf9\u8c61\u7684\u5b57\u6bb5\u503c\u5931\u8d25"), e, new Object[0]);
            }
        }
        return null;
    }

    public static boolean isSimpleClass(Class cls) {
        return ClassUtil.isNumber(cls) || ClassUtil.isString(cls) || ClassUtil.isBoolean(cls) || ClassUtil.isNull(cls);
    }

    public static boolean isSimpleObject(Object object) {
        if (object == null) {
            return false;
        }
        return ClassUtil.isSimpleClass(object.getClass());
    }

    public static boolean isAttributeExists(Class cls, String attrName) {
        PropertyDescriptor pd = ClassUtil.getPropertyDescriptor(cls, attrName);
        return pd != null;
    }

    public static boolean isAttributeExists(Object object, String attrName) {
        Assert.check(object != null);
        Class<?> cls = object.getClass();
        boolean ret = ClassUtil.isAttributeExists(cls, attrName);
        return ret;
    }

    public static boolean isNumber(Object object) {
        if (object != null && object instanceof String) {
            return ((String)object).matches(NUMBERREGEXP);
        }
        if (object != null && object.getClass() == Byte.TYPE || object != null && object.getClass() == Short.TYPE || object != null && object.getClass() == Integer.TYPE || object != null && object.getClass() == Long.TYPE || object != null && object.getClass() == Float.TYPE || object != null && object.getClass() == Double.TYPE) {
            return true;
        }
        return object instanceof Number;
    }

    public static boolean isNumber(Class clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz));
    }

    public static boolean isString(Object obj) {
        return obj instanceof String || obj instanceof Character || obj != null && (obj.getClass() == Character.TYPE || String.class.isAssignableFrom(obj.getClass()));
    }

    public static boolean isString(Class clazz) {
        return clazz != null && (String.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz));
    }

    public static boolean isBoolean(Class clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz));
    }

    public static boolean isBoolean(Object obj) {
        return obj instanceof Boolean || obj != null && obj.getClass() == Boolean.TYPE;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static Class getArrayClassComponentType(Class cls) {
        if (!cls.isArray()) {
            return cls;
        }
        Class<?> componentType = cls.getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    public static Map getClassProperty(Class cls) {
        ICache<String, Map> cache = ClassUtil.getFieldMapCache();
        String keyName = cls.getName();
        Map result = null;
        if (cache != null) {
            result = cache.get(keyName);
        }
        if (result != null) {
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        String name = ClassUtil.getClassSimpleName(cls) + PROPERTYPREFIX;
        InputStream stream = cls.getResourceAsStream(name);
        if (stream != null) {
            Properties properties;
            try {
                Properties props = new Properties();
                props.load(stream);
                if (cache != null) {
                    cache.put(keyName, props);
                }
                properties = props;
                Object var9_9 = null;
            }
            catch (Exception e) {
                try {
                    throw new ReflectException("E0208.0017", EcpI18nUtil.localizedString("E0208.0017", "\u53d6\u7c7b\u7684\u5c5e\u6027\u6587\u4ef6\u5931\u8d25"), e, new Object[0]);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    StreamUtil.closeStream(stream);
                    throw throwable;
                }
            }
            StreamUtil.closeStream(stream);
            return properties;
        }
        if (cache != null) {
            cache.put(keyName, new ConcurrentHashMap());
        }
        return null;
    }

    public static Map getClassPropertyIncludeSuperClass(Class cls, Class beforeSupperClass) {
        ICache<String, Map> cache = ClassUtil.getFieldMapCache();
        String keyName = cls.getName() + INCLUDESUPPERCLASS;
        Map result = null;
        if (cache != null) {
            result = cache.get(keyName);
        }
        if (result != null) {
            if (result.size() == 0) {
                return null;
            }
            return result;
        }
        Class<Object> checkSupperClass = beforeSupperClass;
        if (checkSupperClass == null) {
            checkSupperClass = Object.class;
        }
        ArrayList<Class> supperList = new ArrayList<Class>();
        for (Class parentClass = cls.getSuperclass(); parentClass != checkSupperClass && parentClass != Object.class; parentClass = parentClass.getSuperclass()) {
            supperList.add(parentClass);
        }
        supperList.add(cls);
        ConcurrentHashMap resultsMap = new ConcurrentHashMap();
        Iterator it = supperList.iterator();
        Map map = null;
        while (it.hasNext()) {
            Class tmpCls = (Class)it.next();
            map = ClassUtil.getClassProperty(tmpCls);
            if (map == null) continue;
            resultsMap.putAll(map);
        }
        if (cache != null) {
            cache.put(keyName, resultsMap);
        }
        return resultsMap;
    }

    public static Class[] getClass(Object[] instances) {
        Class[] cls = new Class[instances.length];
        Object obj = null;
        for (int i = 0; i < instances.length; ++i) {
            obj = instances[i];
            cls[i] = obj != null ? obj.getClass() : Object.class;
        }
        return cls;
    }

    public static Object callMethod(Object instance, String methodName, Object[] args) {
        Class[] types;
        Method method;
        if (instance instanceof Class) {
            return ClassUtil.callMethod((Class)instance, methodName, args);
        }
        Object[] callParams = args;
        if (callParams == null) {
            callParams = EMPTYARGS;
        }
        if ((method = ClassUtil.getMethod(instance, methodName, types = ClassUtil.getClass(callParams))) != null) {
            try {
                method.setAccessible(true);
                return method.invoke(instance, callParams);
            }
            catch (Exception e) {
                throw new ReflectException("E0208.0005", EcpI18nUtil.localizedString("E0208.0005", "\u8c03\u7528\u65b9\u6cd5\u5931\u8d25"), e, new Object[0]);
            }
        }
        return null;
    }

    public static Object callMethod(Class cls, String methodName, Object[] args) {
        Class[] types;
        Method method;
        Object[] callParams = args;
        if (callParams == null) {
            callParams = EMPTYARGS;
        }
        if ((method = ClassUtil.getMethod(cls, methodName, types = ClassUtil.getClass(callParams))) != null) {
            try {
                method.setAccessible(true);
                return method.invoke(null, callParams);
            }
            catch (Exception e) {
                throw new ReflectException("E0208.0005", EcpI18nUtil.localizedString("E0208.0005", "\u8c03\u7528\u65b9\u6cd5\u5931\u8d25"), e, new Object[0]);
            }
        }
        return null;
    }

    public static Set<Class<?>> serachInBundle(URL url, String[] scanPackages, Class<?>[] annotationClasses) {
        HashSet result;
        block8: {
            AnnotationDB annotationDB = new AnnotationDB();
            result = new HashSet();
            try {
                if (scanPackages != null && scanPackages.length > 0) {
                    annotationDB.setScanPackages(scanPackages);
                }
                annotationDB.scanArchives(new URL[]{url});
                for (int i = 0; i < annotationClasses.length; ++i) {
                    Set classNames = (Set)annotationDB.getAnnotationIndex().get(annotationClasses[i].getName());
                    if (classNames == null) continue;
                    for (String className : classNames) {
                        try {
                            result.add(ClassUtil.getClass(className));
                        }
                        catch (ClassNotFoundException e) {
                            if (log.isErrorEnabled()) {
                                log.error("\u83b7\u53d6\u7c7b\u5931\u8d25\uff01className\u4e3a" + className);
                            }
                            throw new FindException("E0208.0023", EcpI18nUtil.localizedString("E0208.0023", "\u83b7\u53d6\u7c7b\u5931\u8d25"), e, new Object[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block8;
                log.error("\u83b7\u53d6\u7c7b\u5931\u8d25\uff01bundle\u4e3a", e);
            }
        }
        return result;
    }

    public static Set<Class<?>> serachInBundle(Bundle bundle, String[] scanPackages, Class<?>[] annotationClasses) {
        URL jarURL;
        String jarFile = "file:/" + (String)ClassUtil.callMethod(bundle, "getBundlePath", null);
        try {
            jarURL = new URL(jarFile);
        }
        catch (MalformedURLException e) {
            if (log.isErrorEnabled()) {
                log.error("\u83b7\u53d6\u7c7b\u5931\u8d25\uff01bundle\u4e3a", e);
            }
            throw new RuntimeException(e);
        }
        return ClassUtil.serachInBundle(jarURL, scanPackages, annotationClasses);
    }

    private static Class<?> getActualGenericType(Type superType, int index) {
        if (superType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)superType).getActualTypeArguments();
            Type type = types[index];
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        return null;
    }

    public static Class<?>[] getActualGenericTypes(Class<?> clazz) {
        Type superClass = clazz.getGenericSuperclass();
        return ClassUtil.getActualGenericTypes(superClass);
    }

    public static Class<?>[] getActualGenericTypes(Class<?> clazz, Class<?> interfaceClass) {
        Type[] types = clazz.getGenericInterfaces();
        ParameterizedType superInterface = ClassUtil.getMatchedGenericType(types, interfaceClass);
        return ClassUtil.getActualGenericTypes(superInterface);
    }

    private static ParameterizedType getMatchedGenericType(Type[] types, Class<?> interfaceClass) {
        for (Type type : types) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(interfaceClass)) continue;
            return pt;
        }
        return null;
    }

    private static Class<?>[] getActualGenericTypes(Type superType) {
        if (superType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)superType).getActualTypeArguments();
            Class[] classes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                Type type = types[i];
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                classes[i] = type instanceof Class ? (Class)type : null;
            }
            return classes;
        }
        return new Class[0];
    }

    public static Class<?> getAcutalGenericType(Class<?> clazz, Class<?> interfaceClass, int index) {
        Type[] types = clazz.getGenericInterfaces();
        ParameterizedType superInterface = ClassUtil.getMatchedGenericType(types, interfaceClass);
        return ClassUtil.getActualGenericType(superInterface, index);
    }

    public static Class<?> getAcutalGenericType(Class<?> clazz, int index) {
        Type superClass = clazz.getGenericSuperclass();
        return ClassUtil.getActualGenericType(superClass, index);
    }

    static {
        EMPTYTYPES = new Class[0];
        EMPTY = new Object[0];
        FIELDMAPCACHEKEY = StringUtil.genCacheName("system", "fieldMap");
        EMPTYARGS = new Object[0];
    }
}

