/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.tool;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ygsoft.ecp.framework.model.dynamic.IDynamicModel;
import com.ygsoft.ecp.service.tool.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ReflectionUtils;

public final class RestServiceRequester {
    private static final int HTTP_BUFFER_SIZE = 2048;
    private static final String DEFUALT_ENCODER = "UTF-8";
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private RestServiceRequester() {
    }

    public static String send(String host, String requestPath, String methodName, Object[] parameters) throws IOException {
        HttpURLConnection httpConn;
        int statusCode;
        HttpURLConnection urlConnection = null;
        String requestMethod = "POST";
        StringBuilder urlString = new StringBuilder(host);
        urlString.append(requestPath);
        StringBuilder paramsBuilder = new StringBuilder();
        if (methodName.startsWith("find") || methodName.startsWith("get")) {
            requestMethod = "GET";
            if (parameters != null) {
                if ("find".equals(methodName) && parameters.length == 1) {
                    Object param = parameters[0];
                    if (param.getClass().isPrimitive() || param.getClass() == String.class) {
                        urlString.append("?id=").append(URLEncoder.encode(param.toString(), DEFUALT_ENCODER));
                    } else {
                        urlString.append("?id=").append(URLEncoder.encode(objectMapper.writeValueAsString(param), DEFUALT_ENCODER));
                    }
                } else if ("findList".equals(methodName) && parameters.length == 1) {
                    String value = objectMapper.writeValueAsString(parameters[0]);
                    paramsBuilder.append("?ids=").append(URLEncoder.encode(value, DEFUALT_ENCODER));
                } else if ("findListWithPage".equals(methodName) && parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        if (i == 0 && parameters[i] != null) {
                            urlString.append("?filter=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                            continue;
                        }
                        if (i == 1 && parameters[i] != null) {
                            urlString.append("&sort=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                            continue;
                        }
                        if (i == 2 && parameters[i] != null) {
                            urlString.append("&page=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                            continue;
                        }
                        if (i != 3 || parameters[i] == null) continue;
                        urlString.append("&fields=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                    }
                } else if ("findTop1000".equals(methodName) && parameters.length > 0) {
                    for (int i = 0; i < parameters.length; ++i) {
                        if (i == 0 && parameters[i] != null) {
                            urlString.append("?filter=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                            continue;
                        }
                        if (i == 1 && parameters[i] != null) {
                            urlString.append("&sort=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                            continue;
                        }
                        if (i != 2 || parameters[i] == null) continue;
                        urlString.append("&fields=").append(URLEncoder.encode(parameters[i].toString(), DEFUALT_ENCODER));
                    }
                } else {
                    for (int i = 0; i < parameters.length; ++i) {
                        Object param = parameters[i];
                        if (param.getClass().isPrimitive() || param.getClass() == String.class) {
                            urlString.append(URLEncoder.encode(param.toString(), DEFUALT_ENCODER));
                            continue;
                        }
                        urlString.append(URLEncoder.encode(objectMapper.writeValueAsString(param), DEFUALT_ENCODER));
                    }
                }
            }
        } else if ("deleteById".equals(methodName) && parameters != null && parameters.length == 1) {
            Object param = parameters[0];
            if (param.getClass().isPrimitive() || param.getClass() == String.class) {
                urlString.append("?id=").append(URLEncoder.encode(param.toString(), DEFUALT_ENCODER));
            } else {
                urlString.append("?id=").append(URLEncoder.encode(objectMapper.writeValueAsString(param), DEFUALT_ENCODER));
            }
        } else {
            paramsBuilder.append("params=[");
            if (parameters != null) {
                for (Object parameter : parameters) {
                    String value = null;
                    boolean isDynamicModel = false;
                    Class<?> clazz = parameter.getClass();
                    boolean b = true;
                    if (clazz.isArray()) {
                        Object[] arrays = (Object[])parameter;
                        isDynamicModel = IDynamicModel.class.isAssignableFrom(arrays[0].getClass());
                        b = arrays[0].getClass().isPrimitive();
                    } else if (Collection.class.isAssignableFrom(clazz)) {
                        Collection collection = (Collection)parameter;
                        Object obj2 = null;
                        for (Object obj2 : collection) {
                            if (obj2 == null) continue;
                            isDynamicModel = IDynamicModel.class.isAssignableFrom(obj2.getClass());
                            b = obj2.getClass().isPrimitive();
                            break;
                        }
                    } else {
                        isDynamicModel = IDynamicModel.class.isAssignableFrom(clazz);
                        b = clazz.isPrimitive();
                    }
                    value = b || parameter.getClass() == String.class ? parameter.toString() : (isDynamicModel ? JSONUtil.toJsonString(parameter) : objectMapper.writeValueAsString(parameter));
                    paramsBuilder.append(URLEncoder.encode(value, DEFUALT_ENCODER)).append(",");
                }
            }
            paramsBuilder.append("]");
        }
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
            URL u = new URL(urlString.toString());
            Constructor constructor = ReflectionUtils.findConstructor(clazz, (Object[])new Object[]{u, null});
            urlConnection = (HttpURLConnection)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{u, null});
        }
        catch (ClassNotFoundException ex) {
            urlConnection = (HttpURLConnection)new URL(urlString.toString()).openConnection();
        }
        urlConnection.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
        urlConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        urlConnection.addRequestProperty("ecp_token", "ecp.mapp");
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestMethod(requestMethod);
        byte[] bytes = paramsBuilder.toString().getBytes();
        if (bytes.length > 0) {
            urlConnection.setDoOutput(true);
            urlConnection.getOutputStream().write(bytes);
            urlConnection.getOutputStream().flush();
            urlConnection.getOutputStream().close();
        }
        InputStream in = (statusCode = (httpConn = urlConnection).getResponseCode()) == 200 ? httpConn.getInputStream() : httpConn.getErrorStream();
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[2048];
        int count = 0;
        while ((count = in.read(buffer)) > 0) {
            sb.append(new String(buffer, 0, count, DEFUALT_ENCODER));
        }
        in.close();
        if (statusCode == 200) {
            return sb.toString();
        }
        throw new RuntimeException(sb.toString());
    }
}

