/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import com.ygsoft.ecp.service.executor.BoundedConcurrentHashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftLimitMRUCache<K, V>
implements Serializable {
    private static final long serialVersionUID = -6202484863128427618L;
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    BoundedConcurrentHashMap cache = null;

    public SoftLimitMRUCache() {
        this(128);
    }

    public SoftLimitMRUCache(int strongRefCount) {
        this.cache = new BoundedConcurrentHashMap(strongRefCount);
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public V get(K key) {
        return (V)this.cache.get(key);
    }

    public V put(K key, V value) {
        Object result = this.cache.get(key);
        this.cache.put((Object)key, (Object)value);
        return (V)result;
    }

    public V remove(K key) {
        Object result = this.cache.get(key);
        this.cache.remove(key);
        return (V)result;
    }

    public Collection<V> values() {
        return this.cache.values();
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    public void clear() {
        this.cache.clear();
    }
}

