/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2453197247287366740L;
    private transient ConcurrentMap<E, Object> map;
    private static final Object PRESENT = new Object();
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap<E, Object>();
    }

    public ConcurrentHashSet(Collection<? extends E> c) {
        this.map = new ConcurrentHashMap<E, Object>(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        this.map = new ConcurrentHashMap<E, Object>(initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap<E, Object>(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            ConcurrentHashSet newSet = (ConcurrentHashSet)super.clone();
            newSet.map.putAll(this.map);
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
        outputStream.writeInt(this.map.size());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            outputStream.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.map = new ConcurrentHashMap<E, Object>();
        int size = inputStream.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = inputStream.readObject();
            this.map.put(e, PRESENT);
        }
    }
}

