/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.exception;

import com.ygsoft.ecp.service.exception.EcpException;
import java.text.MessageFormat;

public class EcpRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -3205107025741677315L;
    private String errorCode;

    public EcpRuntimeException(String newerrorCode, String message, Object ... messageParams) {
        super(MessageFormat.format(message, messageParams));
        this.errorCode = newerrorCode;
    }

    public EcpRuntimeException(String newerrorCode, String message) {
        super(message);
        this.errorCode = newerrorCode;
    }

    public EcpRuntimeException(EcpException cause) {
        super(cause);
    }

    public EcpRuntimeException(String newerrorCode, Throwable cause) {
        super(cause);
        this.errorCode = newerrorCode;
    }

    public EcpRuntimeException(String newerrorCode, String message, Throwable cause, Object ... messageParams) {
        super(MessageFormat.format(message, messageParams), cause);
        this.errorCode = newerrorCode;
    }

    public String getErrorCode() {
        if (this.errorCode == null) {
            Throwable cause = this.getCause();
            if (cause != null && cause instanceof EcpException) {
                this.errorCode = ((EcpException)cause).getErrorCode();
            } else if (cause != null && cause instanceof EcpRuntimeException) {
                this.errorCode = ((EcpRuntimeException)cause).getErrorCode();
            }
        }
        return this.errorCode;
    }

    public String getMessage() {
        return super.getMessage();
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? message : s;
    }
}

