/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.datasource;

import com.ygsoft.ecp.service.datasource.DataSourceSwapper;
import com.ygsoft.ecp.service.datasource.DatasourceInvokerHolder;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DataSourceUtil;
import com.ygsoft.ecp.service.tool.StringUtil;

public class DataSourceInvoker {
    private static final IEcpLog LOG = EcpLogFactory.getLog(DataSourceInvoker.class);

    public boolean before(ServiceMessage message) {
        String serviceCode = message.getServiceCode();
        String serviceName = message.getServiceName();
        if (DataSourceUtil.isDataSourceSwapEnable() && StringUtil.isNotEmptyString(serviceCode) && StringUtil.isNotEmptyString(serviceName)) {
            DatasourceInvokerHolder.INSTANCE.put(serviceCode, serviceName);
            Object jndi = message.get("jndi-ds");
            if (LOG.isInfoEnabled()) {
                LOG.info("\u4e3b\u4ece\u5e93\u5207\u6362\u62e6\u622a\u5f00\u59cb,\u524d\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0[" + message.getServiceCode() + "],\u65b9\u6cd5\u540d\u79f0[" + message.getServiceName() + "]");
            }
            if (jndi == null) {
                DataSourceSwapper.INSTANCE.set("fmismain");
            } else {
                DataSourceSwapper.INSTANCE.set(jndi.toString());
            }
        }
        return true;
    }

    public boolean after(ServiceMessage message) {
        String serviceCode = message.getServiceCode();
        String serviceName = message.getServiceName();
        if (DataSourceUtil.isDataSourceSwapEnable() && StringUtil.isNotEmptyString(serviceCode) && StringUtil.isNotEmptyString(serviceName)) {
            message.set("jndi-ds", null);
            if (LOG.isInfoEnabled()) {
                LOG.info("\u4e3b\u4ece\u5e93\u5207\u6362\u62e6\u622a\u7ed3\u675f,\u540e\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0[" + message.getServiceCode() + "],\u65b9\u6cd5\u540d\u79f0[" + message.getServiceName() + "]");
            }
            if (DataSourceSwapper.INSTANCE.get() != null) {
                DataSourceSwapper.INSTANCE.set(null);
            }
        }
        return true;
    }
}

