/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async.handler;

import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.executor.engine.IThreadPoolAopHandler;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonThreadLocalAopHandler
implements IThreadPoolAopHandler {
    public static final String CLIENT_IP = "CLIENT_IP";

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void beforeDispatch(Map<String, Object> map) {
        String clientIP = TokenHolder.INSTANCE.getClientIP();
        if (StringUtil.isNotEmpty(clientIP)) {
            map.put(CLIENT_IP, clientIP);
        }
    }

    @Override
    public void beforeExecute(Thread thread, Runnable runnable, Map<String, Object> map) {
        String clientIP = (String)map.get(CLIENT_IP);
        if (StringUtil.isNotEmpty(clientIP)) {
            TokenHolder.INSTANCE.setClientIP(clientIP);
        }
    }

    @Override
    public void afterExecute(Runnable runnable, Throwable throwable, Map<String, Object> map) {
        map.remove(CLIENT_IP);
        TokenHolder.INSTANCE.clearClientIP();
    }
}

