/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.model;

import com.ygsoft.abc.eepsp.satellite.client.openapi.exception.AbcIOException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class ByteArrayMultipartFile
implements MultipartFile {
    private String name;
    private String originalFilename;
    private String contentType;
    private Long size;
    private byte[] bytes;

    public static ByteArrayMultipartFile createFrom(byte[] data, String fileName) {
        try {
            ByteArrayMultipartFile extMultipartFile = new ByteArrayMultipartFile();
            extMultipartFile.name = fileName;
            extMultipartFile.originalFilename = fileName;
            extMultipartFile.contentType = "application/octet-stream";
            extMultipartFile.bytes = data;
            extMultipartFile.size = data.length;
            return extMultipartFile;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u521b\u5efaByteArrayMultipartFile\uff0c\u8bfb\u53d6\u9644\u4ef6size\u5931\u8d25\u3002", e);
        }
    }

    public static ByteArrayMultipartFile createFrom(byte[] data, String fileName, String contentType) {
        try {
            ByteArrayMultipartFile extMultipartFile = new ByteArrayMultipartFile();
            extMultipartFile.name = fileName;
            extMultipartFile.originalFilename = fileName;
            extMultipartFile.contentType = contentType;
            extMultipartFile.bytes = data;
            extMultipartFile.size = data.length;
            return extMultipartFile;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u521b\u5efaByteArrayMultipartFile\uff0c\u8bfb\u53d6\u9644\u4ef6size\u5931\u8d25\u3002", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public long getSize() {
        return this.size;
    }

    public byte[] getBytes() throws IOException {
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public void transferTo(File newDest) throws IOException, IllegalStateException {
    }
}

