/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.reader;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil2 {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtil2.class);
    public static final int BUFFER_SIZE = 10240;

    public static void unzip(File sourcesZipFile, String targetDir) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sourcesZipFile);
            ZipUtil2.unzip(inputStream, targetDir);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ZipUtil2.close(inputStream);
                throw throwable;
            }
        }
        ZipUtil2.close(inputStream);
    }

    public static void unzip(InputStream input, String targetDir) throws IOException {
        byte[] buffer = new byte[10240];
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(input);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                if (!entryName.endsWith("/")) {
                    File destFile = new File(targetDir, entryName);
                    File newFileDir = new File(destFile.getParent());
                    if (!newFileDir.exists()) {
                        newFileDir.mkdirs();
                    }
                    FileOutputStream fos = null;
                    try {
                        int len;
                        fos = new FileOutputStream(destFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        try {
                            LOG.error("\u89e3\u538b\u6587\u4ef6\u5185\u90e8\u51fa\u9519", (Throwable)e);
                            throw e;
                        }
                        catch (Throwable throwable) {
                            ZipUtil2.close(fos);
                            throw throwable;
                        }
                    }
                    ZipUtil2.close(fos);
                }
                zipEntry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            LOG.error("\u89e3\u538b\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            throw new IOException("\u89e3\u538b\u6587\u4ef6\u51fa\u9519");
        }
        finally {
            try {
                if (zis != null) {
                    zis.closeEntry();
                    zis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

