/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.reader;

import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.Content;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.text.TextCode;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.extractor.ExtractorFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ContentExtractor {
    private OFDReader reader;
    private ExtractorFilter filter;

    private ContentExtractor() {
    }

    public ContentExtractor(OFDReader reader) {
        this.reader = reader;
    }

    public ContentExtractor(OFDReader reader, ExtractorFilter filter) {
        this.reader = reader;
        this.filter = filter;
    }

    public List<String> getPageContent(int pageNum) {
        Content ofdContentObj = this.reader.getPage(pageNum).getContent();
        if (ofdContentObj == null) {
            return Collections.emptyList();
        }
        LinkedList<String> txtContentList = new LinkedList<String>();
        List<CT_Layer> layers = ofdContentObj.getLayers();
        for (CT_Layer layer : layers) {
            this.pageBlockHandle(txtContentList, layer.getPageBlocks());
        }
        return txtContentList;
    }

    private void pageBlockHandle(List<String> txtContentList, List<PageBlockType> pageBlocks) {
        for (PageBlockType block : pageBlocks) {
            if (block instanceof TextObject) {
                TextObject text = (TextObject)block;
                List<TextCode> textCodes = text.getTextCodes();
                for (TextCode code : textCodes) {
                    if (this.filter != null) {
                        String allowText = this.filter.getAllowText(text, code);
                        if (allowText == null || "".equals(allowText.trim())) continue;
                        txtContentList.add(allowText);
                        continue;
                    }
                    txtContentList.add(code.getContent());
                }
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            CT_PageBlock ctPageBlock = (CT_PageBlock)block;
            this.pageBlockHandle(txtContentList, ctPageBlock.getPageBlocks());
        }
    }

    public List<String> extractAll() {
        int numberOfPages = this.reader.getNumberOfPages();
        LinkedList<String> txtContentList = new LinkedList<String>();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            List<String> pageContent = this.getPageContent(pageNum);
            if (pageContent == null || pageContent.isEmpty()) continue;
            txtContentList.addAll(pageContent);
        }
        return txtContentList;
    }

    public void traverse(Receiver e) {
        int numberOfPages = this.reader.getNumberOfPages();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            List<String> pageContent = this.getPageContent(pageNum);
            if (pageContent == null || pageContent.isEmpty() || e == null) continue;
            e.process(pageNum, pageContent);
        }
    }

    public static interface Receiver {
        public void process(int var1, List<String> var2);
    }
}

