/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SignDir
extends VirtualContainer {
    public static final String SignContainerPrefix = "Sign_";
    public static final String SealFileName = "Seal.esl";
    public static final String SignatureFileName = "Signature.xml";
    public static final String SignedValueFileName = "SignedValue.dat";
    private Integer index = 0;

    public SignDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
        String indexStr = this.getContainerName().replace(SignContainerPrefix, "");
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            this.clean();
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u76ee\u5f55\u540d\u79f0\uff1a" + this.getContainerName() + "\uff0c\u76ee\u5f55\u540d\u79f0\u5e94\u4e3a Sign_N");
        }
    }

    public static Function<FilePath, SignDir> newFunc() {
        Function<FilePath, SignDir> creater = new Function<FilePath, SignDir>(){

            @Override
            public SignDir apply(FilePath path) {
                return new SignDir(path);
            }
        };
        return creater;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Signature getSignature() throws FileNotFoundException, DocumentException {
        Element ele = this.getObj(SignatureFileName);
        return new Signature(ele);
    }

    public SignDir setSignature(Signature signature) {
        this.putObj(SignatureFileName, signature);
        return this;
    }

    public FilePath getSeal() throws FileNotFoundException {
        return this.getFile(SealFileName);
    }

    public SignDir setSeal(FilePath seal) throws IOException {
        this.putFile(seal);
        return this;
    }

    public FilePath getSignedValue() throws FileNotFoundException {
        return this.getFile(SignedValueFileName);
    }

    public SignDir setSignedValue(FilePath signedValue) throws IOException {
        this.putFile(signedValue);
        return this;
    }
}

