/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.Holder;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.annotation.pageannot.PageAnnot;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.Page;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.res.Res;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.ResDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PageDir
extends VirtualContainer {
    public static final Pattern AnnotFileRegex = Pattern.compile("Annot_(\\d+).xml");
    public static final String PageContainerPrefix = "Page_";
    public static final String ContentFileName = "Content.xml";
    public static final String PageResFileName = "PageRes.xml";
    public static final String AnnotationFileName = "Annotation.xml";
    public static final String AnnotFilePrefix = "Annot_";
    private int index = 0;
    private Integer maxAnnotIndex = -1;

    public PageDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
        String indexStr = this.getContainerName().replace(PageContainerPrefix, "");
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            this.clean();
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u76ee\u5f55\u540d\u79f0\uff1a" + this.getContainerName() + "\uff0c\u76ee\u5f55\u540d\u79f0\u5e94\u4e3a Page_N");
        }
    }

    public static Function<FilePath, PageDir> newFunc() {
        Function<FilePath, PageDir> creater = new Function<FilePath, PageDir>(){

            @Override
            public PageDir apply(FilePath path) {
                return new PageDir(path);
            }
        };
        return creater;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Res getPageRes() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(PageResFileName);
        return new Res(obj);
    }

    public PageDir setPageRes(Res pageRes) {
        this.putObj(PageResFileName, pageRes);
        return this;
    }

    public PageAnnot getPageAnnot() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(AnnotationFileName);
        return new PageAnnot(obj);
    }

    public Map<String, PageAnnot> getPageAnnots() throws IOException {
        HashMap<String, PageAnnot> res = new HashMap<String, PageAnnot>();
        File path2 = new File(this.getContainerPath().getPath());
        File[] fileArray = path2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fileName = pathname.getName().toString().toLowerCase();
                return pathname.isFile() && fileName.startsWith(PageDir.AnnotFilePrefix.toLowerCase()) && fileName.endsWith(".xml");
            }
        });
        if (fileArray.length > 0) {
            for (File file : fileArray) {
                Element obj = null;
                try {
                    obj = this.getObj(AnnotationFileName);
                }
                catch (Exception e) {
                    obj = null;
                }
                if (obj == null) continue;
                res.put(file.getName().toString(), new PageAnnot(obj));
            }
        }
        return res;
    }

    public PageDir setPageAnnot(PageAnnot pageAnnot) {
        this.putObj(AnnotationFileName, pageAnnot);
        return this;
    }

    public ResDir obtainRes() {
        Function<FilePath, ResDir> creater = new Function<FilePath, ResDir>(){

            @Override
            public ResDir apply(FilePath path) {
                return new ResDir(path);
            }
        };
        return this.obtainContainer("Res", creater);
    }

    public ResDir getResDir() throws FileNotFoundException {
        Function<FilePath, ResDir> creater = new Function<FilePath, ResDir>(){

            @Override
            public ResDir apply(FilePath path) {
                return new ResDir(path);
            }
        };
        return this.getContainer("Res", creater);
    }

    public PageDir add(FilePath resource) throws IOException {
        this.obtainRes().add(resource);
        return this;
    }

    public ST_Loc addAnnot(PageAnnot pageAnnot) throws IOException {
        if (pageAnnot == null) {
            return null;
        }
        this.maxAnnotIndex = this.getMaxAnnotFileIndex() + 1;
        String fileName = AnnotFilePrefix + this.maxAnnotIndex + ".xml";
        return this.addAnnot(fileName, pageAnnot);
    }

    public ST_Loc addAnnot(String fileName, PageAnnot pageAnnot) {
        this.putObj(fileName, pageAnnot);
        return this.getAbsLoc().cat(fileName);
    }

    public Integer getMaxAnnotFileIndex() throws IOException {
        if (this.maxAnnotIndex < 0) {
            Holder<Integer> maxIndexHolder = new Holder<Integer>(-1);
            File path2 = new File(this.getContainerPath().getPath());
            File[] fileArray = path2.listFiles();
            if (fileArray.length > 0) {
                for (File file : fileArray) {
                    String fileName = file.getName().toString().toLowerCase();
                    if (!fileName.startsWith(AnnotFilePrefix.toLowerCase())) continue;
                    String numStr = fileName.replace(AnnotFilePrefix.toLowerCase(), "").split("\\.")[0];
                    try {
                        int n = Integer.parseInt(numStr);
                        if (n <= (Integer)maxIndexHolder.value) continue;
                        maxIndexHolder.value = n;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.maxAnnotIndex = (Integer)maxIndexHolder.value;
            }
            this.maxAnnotIndex = (Integer)maxIndexHolder.value;
        }
        return this.maxAnnotIndex;
    }

    public FilePath get(String name) throws FileNotFoundException {
        return this.obtainRes().getFile(name);
    }

    public Page getContent() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(ContentFileName);
        return new Page(obj);
    }

    public PageDir setContent(Page content) {
        this.putObj(ContentFileName, content);
        return this;
    }
}

