/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.x509.Certificate;
import org.bouncycastle162.cert.X509CertificateHolder;
import org.bouncycastle162.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;

public final class CertTools {
    public static Certificate asn1(java.security.cert.Certificate certificate) throws CertificateEncodingException, IOException {
        ASN1Primitive p = ASN1Primitive.fromByteArray((byte[])certificate.getEncoded());
        if (p == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u8bc1\u4e66(certificate)");
        }
        return Certificate.getInstance((Object)p);
    }

    public static java.security.cert.Certificate toJavaCert(Certificate certificate) throws CertificateException {
        return new JcaX509CertificateConverter().setProvider("BC162").getCertificate(new X509CertificateHolder(certificate));
    }

    public static java.security.cert.Certificate toJavaCert(byte[] certificate) throws CertificateException, IOException {
        return new JcaX509CertificateConverter().setProvider("BC162").getCertificate(new X509CertificateHolder(certificate));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

