/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.DocBody;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.OFD;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signatures;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.appearance.Seal;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.range.Reference;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.range.References;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.SignedInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.SESVersion;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.SESVersionHolder;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.VersionParser;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SES_Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SESeal;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.SignedDataValidateContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.FileIntegrityException;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.OFDVerifyException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDValidatorExt
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OFDValidatorExt.class);
    public static final String OFDFileName = "OFD.xml";
    public static final String ERROR_READ_ERROR = "\u89e3\u6790ofd\u6587\u4ef6\u5931\u8d25";
    private SignedDataValidateContainer validator;
    private final Map<String, byte[]> allFileData;
    private final Provider provider = new BouncyCastleProvider();

    public OFDValidatorExt(byte[] fileData) {
        this.allFileData = this.readZip(fileData);
    }

    public OFDValidatorExt setValidator(SignedDataValidateContainer validator) {
        if (validator == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9a8c\u8bc1\u5bb9\u5668\uff08validator\uff09\u4e3a\u7a7a");
        }
        this.validator = validator;
        return this;
    }

    private Map<String, byte[]> readZip(byte[] zipData) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        Object in = null;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new ByteArrayInputStream(zipData));
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                IOUtil.copy(zin, byteOutput);
                byte[] b = byteOutput.toByteArray();
                byteOutput.flush();
                IOUtil.close(byteOutput);
                String itemName = null;
                itemName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
                map.put(itemName, b);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(ERROR_READ_ERROR, e);
            }
            catch (Throwable throwable) {
                OFDValidatorExt.close(zin, in);
                throw throwable;
            }
        }
        OFDValidatorExt.close(zin, in);
        return map;
    }

    private byte[] getFileData(String filePath) throws FileNotFoundException {
        String file = filePath;
        if (filePath.startsWith("/")) {
            file = filePath.substring(1);
        }
        if (this.allFileData.containsKey(file)) {
            return this.allFileData.get(file);
        }
        throw new FileNotFoundException();
    }

    private static void close(Closeable ... closeable) {
        if (closeable != null && closeable.length > 0) {
            for (Closeable closeable1 : closeable) {
                try {
                    if (closeable1 == null) continue;
                    closeable1.close();
                }
                catch (IOException e) {
                    LOG.info("close io error", (Throwable)e);
                }
            }
        }
    }

    public <R> R get(String loc, Function<Element, R> mapper) throws FileNotFoundException, DocumentException {
        if (loc == null || loc.trim().equals("")) {
            throw new FileNotFoundException("\u8def\u5f84\u4e3a\u7a7a\uff08loc\uff09");
        }
        Element element = this.getObj(loc);
        return mapper.apply(element);
    }

    private Element getObj(String fileName) throws FileNotFoundException, DocumentException {
        if (fileName == null || fileName.length() == 0) {
            throw new DocumentException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        byte[] fileData = this.getFileData(fileName);
        return OFDValidatorExt.inject(fileData);
    }

    private static Element inject(byte[] fileData) throws DocumentException {
        Element element;
        SAXReader reader = new SAXReader();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(fileData);
            Document document = reader.read((InputStream)in);
            element = document.getRootElement();
        }
        catch (DocumentException e) {
            try {
                throw new DocumentException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
            catch (Throwable throwable) {
                OFDValidatorExt.close(in);
                throw throwable;
            }
        }
        OFDValidatorExt.close(in);
        return element;
    }

    private OFD getOfd() throws OFDVerifyException {
        Element obj = null;
        try {
            obj = this.getObj(OFDFileName);
        }
        catch (FileNotFoundException e) {
            throw new OFDVerifyException("\u6587\u6863\u4e3b\u5165\u53e3\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        catch (DocumentException e) {
            throw new OFDVerifyException("\u6587\u6863\u4e3b\u5165\u53e3\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", e);
        }
        return new OFD(obj);
    }

    private String getLocParent(String filePath) {
        String path0 = filePath;
        if (filePath.contains("/") && filePath.length() > 1) {
            path0 = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        return path0;
    }

    private String getAbsolutePath(String parent, String child) {
        if (child.startsWith("/")) {
            return child;
        }
        return parent + child;
    }

    public void exeValidate() throws OFDVerifyException {
        try {
            OFD ofd = this.getOfd();
            DocBody docBody = ofd.getDocBody();
            ST_Loc signaturesLoc = docBody.getSignatures();
            if (signaturesLoc == null) {
                throw new OFDVerifyException("\u6587\u4ef6\u672a\u8fdb\u884c\u7535\u5b50\u7b7e\u540d");
            }
            String sigListLoc = signaturesLoc.getLoc();
            Signatures sigList = null;
            try {
                sigList = this.get(sigListLoc, Signatures.newFunc());
            }
            catch (FileNotFoundException e) {
                throw new OFDVerifyException("\u7535\u5b50\u7b7e\u540d\u6587\u4ef6Signatures.xml\u4e0d\u5b58\u5728");
            }
            catch (DocumentException e) {
                throw new OFDVerifyException("\u7535\u5b50\u7b7e\u540d\u6587\u4ef6Signatures.xml\u89e3\u6790\u5f02\u5e38");
            }
            List<com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature> signatures = sigList.getSignatures();
            for (com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature sigRecord : signatures) {
                String sealFilePath;
                byte[] sealBin;
                boolean sealMatch;
                Seal seal;
                SigType type = sigRecord.getType();
                if (type == null) {
                    type = SigType.Seal;
                }
                ST_Loc signatureFileLoc = sigRecord.getBaseLoc();
                String signatureFilePath = this.getAbsolutePath(this.getLocParent(sigListLoc), signatureFileLoc.getLoc());
                Signature sig = this.get(signatureFilePath, Signature.newFunc());
                this.checkFileIntegrity(sig);
                byte[] signatureData = this.getFileData(signatureFilePath);
                String signedValueFilePath = this.getAbsolutePath(this.getLocParent(signatureFilePath), sig.getSignedValue().getLoc());
                byte[] sesSignatureBin = this.getFileData(signedValueFilePath);
                if (type == SigType.Seal && (seal = sig.getSignedInfo().getSeal()) != null && seal.getOFDElement("BaseLoc") != null && !(sealMatch = this.checkSealMatch(sealBin = this.getFileData(sealFilePath = this.getAbsolutePath(this.getLocParent(signatureFilePath), seal.getBaseLoc().getLoc())), sesSignatureBin))) {
                    throw new GeneralSecurityException("\u5370\u7ae0(Seal.esl)\u4e0e\u7535\u5b50\u7b7e\u7ae0\u6570\u636e(SignedValue.dat)\u4e2d\u7684\u5370\u7ae0\u4e0d\u5339\u914d");
                }
                String alg = sig.getSignedInfo().getSignatureMethod();
                this.checkSignedValue(type, alg, signatureData, sesSignatureBin);
            }
        }
        catch (Exception e) {
            if (e instanceof GeneralSecurityException) {
                throw new OFDVerifyException(e.getMessage(), e);
            }
            throw new OFDVerifyException("OFD\u89e3\u6790\u51fa\u9519\u3002", e);
        }
    }

    public void checkSignedValue(SigType type, String alg, byte[] tbsContent, byte[] signedValueData) throws IOException, GeneralSecurityException {
        if (this.validator == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9a8c\u8bc1\u5bb9\u5668\uff08validator\uff09\u4e3a\u7a7a,Call #setValidator");
        }
        if (type == null) {
            type = SigType.Seal;
        }
        this.validator.validate(type, alg, tbsContent, signedValueData);
    }

    private void checkFileIntegrity(Signature sig) throws OFDVerifyException, NoSuchAlgorithmException, IOException {
        SignedInfo signedInfo = sig.getSignedInfo();
        References references = signedInfo.getReferences();
        String checkMethod = references.getCheckMethod();
        MessageDigest md = MessageDigest.getInstance(checkMethod, this.provider);
        for (Reference ref : references.getReferences()) {
            ST_Loc fileRef = ref.getFileRef();
            String fileRefPath = fileRef.getLoc();
            byte[] expectDataHash = ref.getCheckValue();
            ByteArrayInputStream in = null;
            DigestInputStream dis = null;
            try {
                in = new ByteArrayInputStream(this.getFileData(fileRefPath));
                dis = new DigestInputStream(in, md);
                byte[] buffer = new byte[4096];
                while (dis.read(buffer) > -1) {
                }
                byte[] actualDataHash = md.digest();
                if (!Arrays.equals(expectDataHash, actualDataHash)) {
                    throw new FileIntegrityException(fileRef, expectDataHash, actualDataHash);
                }
            }
            catch (Exception e) {
                try {
                    throw new OFDVerifyException("OFD\u6587\u4ef6\u88ab\u7be1\u6539", e);
                }
                catch (Throwable throwable) {
                    OFDValidatorExt.close(dis);
                    OFDValidatorExt.close(in);
                    throw throwable;
                }
            }
            OFDValidatorExt.close(dis);
            OFDValidatorExt.close(in);
            md.reset();
        }
    }

    private boolean checkSealMatch(byte[] sealBin, byte[] sesSignatureBin) throws IOException, OFDVerifyException {
        byte[] expect = null;
        SESVersionHolder v = VersionParser.parseSES_SignatureVersion(sesSignatureBin);
        if (v.getVersion() == SESVersion.v4) {
            com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature sesSignature = com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature.getInstance(v.getObjSeq());
            SESeal eseal = sesSignature.getToSign().getEseal();
            expect = eseal.getEncoded("DER");
        } else if (v.getVersion() == SESVersion.v1) {
            SES_Signature sesSignature = SES_Signature.getInstance(v.getObjSeq());
            com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SESeal eseal = sesSignature.getToSign().getEseal();
            expect = eseal.getEncoded("DER");
        } else {
            throw new OFDVerifyException("\u672a\u77e5\u7684\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u7248\u672c\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        return Arrays.equals(expect, sealBin);
    }

    @Override
    public void close() throws IOException {
    }
}

