/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore;

import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.FileVisit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateStoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateStoreUtils.class);

    public static void printCert(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            LOG.info("\u7248\u672c\u53f7:" + x509Certificate.getVersion());
            LOG.info("\u5e8f\u5217\u53f7:" + x509Certificate.getSerialNumber().toString(16));
            LOG.info("\u4e3b\u4f53\u540d\uff1a" + x509Certificate.getSubjectDN());
            LOG.info("\u7b7e\u53d1\u8005\uff1a" + x509Certificate.getIssuerDN());
            LOG.info("\u6709\u6548\u671f\uff1a" + x509Certificate.getNotBefore());
            LOG.info("\u7b7e\u540d\u7b97\u6cd5\uff1a" + x509Certificate.getSigAlgName());
            byte[] sig = x509Certificate.getSignature();
            LOG.info("\u7b7e\u540d\u503c\uff1a" + Arrays.toString(sig));
            PublicKey pk = x509Certificate.getPublicKey();
            byte[] publicKey = pk.getEncoded();
            LOG.info("\u516c\u94a5:" + Arrays.toString(publicKey));
            LOG.info("======================================");
        } else {
            LOG.info("\u975eX509\u683c\u5f0f\u8bc1\u4e66\uff0c\u89e3\u6790\u5f02\u5e38");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Certificate readCertificate(byte[] certFileData) {
        Certificate certificate;
        ByteArrayInputStream inputStream = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            inputStream = new ByteArrayInputStream(certFileData);
            certificate = cf.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            try {
                throw new RuntimeException("\u89e3\u6790\u8bc1\u4e66\u5931\u8d25", e);
                catch (NoSuchProviderException e2) {
                    throw new RuntimeException("No BC Provider", e2);
                }
            }
            catch (Throwable throwable) {
                CertificateStoreUtils.close(inputStream);
                throw throwable;
            }
        }
        CertificateStoreUtils.close(inputStream);
        return certificate;
    }

    public static Certificate readCertificate(File certFile) {
        Certificate certificate;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(certFile);
            certificate = CertificateStoreUtils.readCertificate(inputStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                CertificateStoreUtils.close(inputStream);
                throw throwable;
            }
        }
        CertificateStoreUtils.close(inputStream);
        return certificate;
    }

    public static Certificate readCertificate(InputStream inputStream) {
        ByteArrayOutputStream outputStream = null;
        byte[] fileData = null;
        try {
            outputStream = new ByteArrayOutputStream();
            CertificateStoreUtils.copyLarge(inputStream, outputStream);
            fileData = outputStream.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                CertificateStoreUtils.close(outputStream);
                throw throwable;
            }
        }
        CertificateStoreUtils.close(outputStream);
        return CertificateStoreUtils.readCertificate(fileData);
    }

    public static byte[] toCertificateWithBase64(Certificate certificate) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("-----BEGIN CERTIFICATE-----\n");
        try {
            stringBuffer.append(new String(Base64.encode((byte[])certificate.getEncoded())));
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        stringBuffer.append("\n-----END CERTIFICATE-----\n");
        return stringBuffer.toString().getBytes();
    }

    public static String MD5(byte[] input) {
        if (input == null || input.length == 0) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(input);
            byte[] byteArray = md5.digest();
            char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            char[] charArray = new char[byteArray.length * 2];
            int index = 0;
            for (byte b : byteArray) {
                charArray[index++] = hexDigits[b >>> 4 & 0xF];
                charArray[index++] = hexDigits[b & 0xF];
            }
            return new String(charArray);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u7b97\u6cd5\u4e0d\u652f\u6301", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCertToFile(Certificate certificate, File file) {
        File dir = new File(file.getParent());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("create dir error");
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            byte[] data = CertificateStoreUtils.toCertificateWithBase64(certificate);
            ((OutputStream)outputStream).write(data);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CertificateStoreUtils.close(outputStream);
                throw throwable;
            }
            CertificateStoreUtils.close(outputStream);
        }
        CertificateStoreUtils.close(outputStream);
    }

    public static void close(Closeable ... closeable) {
        for (Closeable closeable1 : closeable) {
            if (closeable1 == null) continue;
            try {
                closeable1.close();
            }
            catch (IOException e) {
                LOG.warn("close error", (Throwable)e);
            }
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        long count = 0L;
        if (input != null) {
            int n;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        return count;
    }

    public static void traverseFile(File dir, FileVisit fileVisit) {
        File[] fileArray;
        if (dir.exists() && (fileArray = dir.listFiles()) != null && fileArray.length > 0) {
            for (File f : fileArray) {
                if (f.isDirectory()) {
                    CertificateStoreUtils.traverseFile(f, fileVisit);
                    continue;
                }
                fileVisit.visit(f);
            }
        }
    }

    public static File join(File root, String ... paths) {
        if (root == null) {
            throw new IllegalArgumentException("the root file can not be null");
        }
        File target = root;
        if (paths != null && paths.length > 0) {
            for (String path : paths) {
                target = new File(target, path);
            }
        }
        return target;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

