/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore;

import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreMemory;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreUtils;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.FileVisit;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.ICertificateStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateStoreFactory.class);
    private static ICertificateStore certificateStore = null;

    private CertificateStoreFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICertificateStore getInstance() {
        if (certificateStore != null) return certificateStore;
        Class<CertificateStoreFactory> clazz = CertificateStoreFactory.class;
        synchronized (CertificateStoreFactory.class) {
            if (certificateStore != null) return certificateStore;
            certificateStore = new CertificateStoreMemory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return certificateStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCertsFromJar(String[] jarCertFiles) {
        int sum = 0;
        for (String certFile : jarCertFiles) {
            InputStream is = null;
            try {
                is = CertificateStoreFactory.class.getClassLoader().getResourceAsStream(certFile);
                Certificate certificate = CertificateStoreUtils.readCertificate(is);
                CertificateStoreFactory.getInstance().add(certificate);
                LOG.info("add cert success with: " + certFile);
                ++sum;
            }
            catch (Exception e) {
                try {
                    LOG.error("add cert fail with: " + certFile, (Throwable)e);
                }
                catch (Throwable throwable) {
                    CertificateStoreUtils.close(is);
                    throw throwable;
                }
                CertificateStoreUtils.close(is);
                continue;
            }
            CertificateStoreUtils.close(is);
        }
        LOG.info("success add certs size: " + sum);
    }

    public static void addCertsFromDir(File dir) {
        final Integer[] sum = new Integer[]{0};
        CertificateStoreUtils.traverseFile(dir, new FileVisit(){

            @Override
            public void visit(File file) {
                if (file.getName().endsWith(".cer")) {
                    Certificate certificate = CertificateStoreUtils.readCertificate(file);
                    try {
                        CertificateStoreFactory.getInstance().add(certificate);
                        LOG.info("add cert success with: " + file.getAbsolutePath());
                        sum[0] = sum[0] + 1;
                    }
                    catch (Exception e) {
                        LOG.error("add cert fail with: " + file.getAbsolutePath(), (Throwable)e);
                        throw new RuntimeException("\u6dfb\u52a0\u8bc1\u4e66\u5931\u8d25", e);
                    }
                }
            }
        });
        LOG.info("success add certs size: " + sum[0]);
    }

    public static void addCert(Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            CertificateStoreFactory.getInstance().add(certificate);
        }
        catch (IOException e) {
            throw new RuntimeException("\u6dfb\u52a0\u8bc1\u4e66\u5931\u8d25", e);
        }
    }
}

