/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.crypto;

import cn.org.bjca.gaia.crypto.digests.SM3Digest;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPrivateKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanism;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2KeyPairGenerator;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PrivateKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.util.SM2PackageUtil;
import com.ygsoft.abc.mapp.ygca.crypto.BaseLib;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;

public class BCSoftLib
extends BaseLib {
    private static final Provider SADK_PROVIDER = new BouncyCastleProvider();
    private static volatile BCSoftLib singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final BCSoftLib getInstance() {
        if (singleton != null) return singleton;
        Class<BCSoftLib> var0 = BCSoftLib.class;
        Class<BCSoftLib> clazz = BCSoftLib.class;
        synchronized (BCSoftLib.class) {
            if (singleton != null) return singleton;
            singleton = new BCSoftLib();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    protected final KeyPair SM2GenerateKeyPair() {
        try {
            KeyPair keypair = SM2KeyPairGenerator.SM2GenerateKeyPair();
            GMTPrivateKey tmp_privateKey = (GMTPrivateKey)((Object)keypair.getPrivate());
            GMTPublicKey tmp_publicKey = (GMTPublicKey)((Object)keypair.getPublic());
            SM2PrivateKey privKey = new SM2PrivateKey(tmp_privateKey.getD(), tmp_publicKey.getPubX_Int(), tmp_publicKey.getPubY_Int());
            return new KeyPair((PublicKey)((Object)privKey.getSM2PublicKey()), (PrivateKey)((Object)privKey));
        }
        catch (Throwable var5) {
            throw new RuntimeException("GenerateKeyPair failure with throwable: " + var5.getMessage(), var5);
        }
    }

    @Override
    protected final KeyPair ECCGenerateKeyPair(Mechanism mechanism) {
        return null;
    }

    @Override
    protected final KeyPair RSAGenerateKeyPair(int bitLength) {
        try {
            if (bitLength >= 0 && bitLength <= 4096 && bitLength % 512 == 0) {
                KeyPairGenerator keyPairGen = null;
                try {
                    keyPairGen = KeyPairGenerator.getInstance("RSA", SADK_PROVIDER);
                }
                catch (Exception var5) {
                    throw new RuntimeException("RSAGenerateKeyPair failure with exception: " + var5.getMessage(), var5);
                }
                try {
                    keyPairGen.initialize(bitLength);
                    KeyPair keypair = keyPairGen.generateKeyPair();
                    return keypair;
                }
                catch (Exception var4) {
                    throw new RuntimeException("RSAGenerateKeyPair failure with exception: " + var4.getMessage(), var4);
                }
            }
            throw new RuntimeException("RSAGenerateKeyPair failure with invalid bitLength=" + bitLength);
        }
        catch (Exception var7) {
            throw new RuntimeException("RSAGenerateKeyPair failure with throwable: " + var7.getMessage(), var7);
        }
    }

    @Override
    protected final byte[] SM2EncryptMessage(SM2PublicKey sm2PublicKey, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] SM2DecryptMessage(SM2PrivateKey sm2PrivateKey, byte[] encryptData) {
        return null;
    }

    @Override
    protected final byte[] SM2SignHash(SM2PrivateKey sm2PrivateKey, byte[] hashValue) {
        return null;
    }

    @Override
    protected final boolean SM2VerifyHash(SM2PublicKey sm2PublicKey, byte[] hashValue, byte[] signValue) {
        try {
            boolean verifyResult = SM2PackageUtil.verifyByBC(hashValue, signValue, (Key)((Object)sm2PublicKey));
            return verifyResult;
        }
        catch (Exception var5) {
            throw new RuntimeException("SM2VerifyHash failure with exception: " + var5.getMessage(), var5);
        }
    }

    @Override
    protected final byte[] SM2HashMessage(SM2PublicKey sm2PubKey, byte[] message, boolean withZ) {
        try {
            byte[] hashValue = new byte[32];
            SM3Digest sm3Hash = new SM3Digest();
            if (withZ) {
                sm3Hash.update(sm2PubKey.getDefaultZ(), 0, 32);
            }
            sm3Hash.update(message, 0, message.length);
            sm3Hash.doFinal(hashValue, 0);
            return hashValue;
        }
        catch (Exception var6) {
            throw new RuntimeException("SM2HashMessage failure with exception: " + var6.getMessage(), var6);
        }
    }

    @Override
    protected final byte[] SM2HashFile(SM2PublicKey sm2PubKey, InputStream stream, boolean withZ) {
        try {
            int rLength;
            byte[] hashValue = new byte[32];
            byte[] buffer = new byte[65536];
            SM3Digest engine = new SM3Digest();
            if (withZ) {
                engine.update(sm2PubKey.getDefaultZ(), 0, 32);
            }
            boolean var7 = false;
            while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
                engine.update(buffer, 0, rLength);
            }
            engine.doFinal(hashValue, 0);
            return hashValue;
        }
        catch (Exception var8) {
            throw new RuntimeException("SM2HashFile failure with exception: " + var8.getMessage(), var8);
        }
    }

    @Override
    protected final byte[] RSAEncryptMessage(PublicKey publicKey, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] RSADecryptMessage(PrivateKey privateKey, byte[] encryptData) {
        return null;
    }

    @Override
    protected final byte[] RSASignHash(PrivateKey privateKey, byte[] hashWithAlgorithm) {
        return null;
    }

    @Override
    protected final boolean RSAVerifyHash(PublicKey publicKey, byte[] hashWithAlgorithm, byte[] signValue) {
        return false;
    }

    @Override
    protected final byte[] RSAHashMessage(Mechanism mechanism, byte[] message) {
        return this.RSAHashMessage(mechanism, message, true);
    }

    @Override
    protected byte[] RSAHashMessage(Mechanism mechanism, byte[] message, boolean isDerEncoding) {
        return null;
    }

    @Override
    protected final byte[] RSAHashFile(Mechanism mechanism, InputStream stream) {
        return this.RSAHashFile(mechanism, stream, true);
    }

    @Override
    protected byte[] RSAHashFile(Mechanism mechanism, InputStream stream, boolean isDerEncoding) {
        return null;
    }

    @Override
    protected final byte[] SM4EncryptMessage(Mechanism mechanism, Key key, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] SM4DecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) {
        return null;
    }

    @Override
    protected final byte[] RC4EncryptMessage(Mechanism mechanism, Key key, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] RC4DecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) {
        return null;
    }

    @Override
    protected final byte[] DESedeEncryptMessage(Mechanism mechanism, Key key, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] DESedeDecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) {
        return null;
    }

    @Override
    protected final byte[] AESEncryptMessage(Mechanism mechanism, Key key, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] AESDecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) {
        return null;
    }

    @Override
    protected final void SM2HashFile(SM2PublicKey sm2PubKey, boolean supportedWithoutZ, InputStream stream, byte[] hashWithZ, byte[] hashWithoutZ) {
        try {
            int rLength;
            byte[] buffer = new byte[65536];
            SM3Digest engineWithZ = new SM3Digest();
            engineWithZ.update(sm2PubKey.getDefaultZ(), 0, 32);
            SM3Digest engineWithoutZ = null;
            if (supportedWithoutZ) {
                engineWithoutZ = new SM3Digest();
            }
            boolean var9 = false;
            while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
                engineWithZ.update(buffer, 0, rLength);
                if (!supportedWithoutZ) continue;
                engineWithoutZ.update(buffer, 0, rLength);
            }
            engineWithZ.doFinal(hashWithZ, 0);
            if (supportedWithoutZ) {
                engineWithoutZ.doFinal(hashWithoutZ, 0);
            }
        }
        catch (Exception var10) {
            throw new RuntimeException("SM2HashFile failure with exception: " + var10.getMessage(), var10);
        }
    }

    @Override
    protected final byte[] ECDSASignHash(PrivateKey privateKey, byte[] hashWithoutAlgorithm, Mechanism mechanism) {
        return null;
    }

    @Override
    protected final boolean ECDSAVerifyHash(PublicKey publicKey, byte[] hashWithoutAlgorithm, byte[] signValue, Mechanism mechanism) {
        return false;
    }

    @Override
    protected final byte[] ECCEncryptMessage(PublicKey publicKey, byte[] message) {
        return null;
    }

    @Override
    protected final byte[] ECCDecryptMessage(PrivateKey privateKey, byte[] encryptData) {
        return null;
    }

    public final PublicKey exportEncPublicKey() {
        throw new RuntimeException("exportEncPublicKey failure: BCSoftLib not supported!");
    }

    public final boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) {
        throw new RuntimeException("importSM2KeyPair failure: BCSoftLib not supported!");
    }

    public final String getDeviceName() {
        return "JSOFT_LIB";
    }

    public final int getDeviceType() {
        return 0;
    }

    public final boolean useJniNativeOperation() {
        return false;
    }
}

