/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.crypto.generators.ECKeyPairGenerator;
import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECKeyGenerationParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.ec.FixedPointCombMultiplier;
import cn.org.bjca.gaia.math.ec.WNafUtil;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPrivateKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Params;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class SM2KeyPairGenerator
extends ECKeyPairGenerator {
    private final int mBitlength = 249;
    private ECDomainParameters params;
    private SecureRandom random;

    public final void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    public final AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        BigInteger n = this.params.getN();
        ECPoint G = this.params.getG();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        ECPoint Q = null;
        while ((d = new BigInteger(nBitLength, this.random)).bitLength() < 249 || d.compareTo(TWO) < 0 || d.compareTo(n) > 0 || WNafUtil.getNafWeight((BigInteger)d) < minWeight || (Q = multiplier.multiply(G, d).normalize()).getXCoord().bitLength() < 249 || Q.getYCoord().bitLength() < 249) {
        }
        return new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new ECPublicKeyParameters(Q, this.params), (AsymmetricKeyParameter)new ECPrivateKeyParameters(d, this.params));
    }

    public static final KeyPair SM2GenerateKeyPair() {
        SM2KeyPairGenerator gen = new SM2KeyPairGenerator();
        gen.init((KeyGenerationParameters)new ECKeyGenerationParameters(SM2Params.sm2DomainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair keypair = gen.generateKeyPair();
        ECPublicKeyParameters pubParameters = (ECPublicKeyParameters)keypair.getPublic();
        ECPrivateKeyParameters pvkParameters = (ECPrivateKeyParameters)keypair.getPrivate();
        GMTPublicKey pubKey = new GMTPublicKey(pubParameters);
        GMTPrivateKey priKey = new GMTPrivateKey(pvkParameters, pubParameters);
        return new KeyPair((PublicKey)((Object)pubKey), (PrivateKey)((Object)priKey));
    }
}

