/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.util.encoders.Hex;
import com.ygsoft.abc.mapp.ygca.algorithm.common.TLV;
import com.ygsoft.abc.mapp.ygca.algorithm.util.BigIntegerKit;
import java.math.BigInteger;
import java.util.Enumeration;

public class ASN1SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    public static ASN1SM2Signature getInstance(Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing object for getInstance");
        }
        ASN1SM2Signature sign = o instanceof ASN1SM2Signature ? (ASN1SM2Signature)((Object)o) : new ASN1SM2Signature(ASN1Sequence.getInstance((Object)o));
        return sign;
    }

    public ASN1SM2Signature(BigInteger r, BigInteger s) {
        if (r == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing R:signR");
        }
        if (s == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing S:signS");
        }
        this.r = BigIntegerKit.formatXYRS(new ASN1Integer(r));
        this.s = BigIntegerKit.formatXYRS(new ASN1Integer(s));
    }

    public ASN1SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = BigIntegerKit.formatXYRS(r);
        this.s = BigIntegerKit.formatXYRS(s);
    }

    public ASN1SM2Signature(ASN1Sequence seq) {
        this.decodedRS(seq);
    }

    public ASN1SM2Signature(byte[] signBytes) throws SecurityException {
        if (signBytes == null) {
            throw new SecurityException("ASN1SM2Signature signBytes missing");
        }
        if (signBytes.length < 58) {
            throw new SecurityException("ASN1SM2Signature signBytes required length>=58");
        }
        if (signBytes.length > 72) {
            throw new SecurityException("ASN1SM2Signature signBytes required length<=72");
        }
        if (ASN1SM2Signature.isASN1SignType(signBytes)) {
            ASN1InputStream asn1Is = null;
            ASN1Sequence seq = null;
            try {
                asn1Is = new ASN1InputStream(signBytes);
                seq = (ASN1Sequence)asn1Is.readObject();
            }
            catch (Exception var13) {
                throw new SecurityException("ASN1SM2Signature Unknown  signature value:" + Hex.toHexString((byte[])signBytes), var13);
            }
            finally {
                if (asn1Is != null) {
                    try {
                        asn1Is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.decodedRS(seq);
        } else {
            if (signBytes.length != 64) {
                throw new SecurityException("ASN1SM2Signature Unknown  signature value:" + Hex.toHexString((byte[])signBytes));
            }
            this.r = BigIntegerKit.formatXYRS(new ASN1Integer(ASN1SM2Signature.copyOfRange(signBytes, 0, 32)));
            this.s = BigIntegerKit.formatXYRS(new ASN1Integer(ASN1SM2Signature.copyOfRange(signBytes, 32, 64)));
        }
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private final void decodedRS(ASN1Sequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing seq");
        }
        if (seq.size() != 2) {
            throw new IllegalArgumentException("ASN1SM2Signature seq required size=2");
        }
        Enumeration e = seq.getObjects();
        this.r = BigIntegerKit.formatXYRS((ASN1Integer)e.nextElement());
        this.s = BigIntegerKit.formatXYRS((ASN1Integer)e.nextElement());
    }

    public static ASN1SM2Signature convertFrom64SignBytes(byte[] signBytes) {
        if (signBytes == null) {
            throw new IllegalArgumentException("ASN1SM2Signature signBytes missing");
        }
        if (signBytes.length != 64) {
            throw new IllegalArgumentException("ASN1SM2Signature signBytes required length=64");
        }
        ASN1Integer r = new ASN1Integer(ASN1SM2Signature.copyOfRange(signBytes, 0, 32));
        ASN1Integer s = new ASN1Integer(ASN1SM2Signature.copyOfRange(signBytes, 32, 64));
        return new ASN1SM2Signature(r, s);
    }

    public final byte[] getRSRaw64Bytes() {
        byte[] dest = new byte[64];
        System.arraycopy(BigIntegerKit.asUnsignedByteArray(32, this.r.getPositiveValue()), 0, dest, 0, 32);
        System.arraycopy(BigIntegerKit.asUnsignedByteArray(32, this.s.getPositiveValue()), 0, dest, 32, 32);
        return dest;
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.formatToPositive(this.r, 32));
        v.add((ASN1Encodable)this.formatToPositive(this.s, 32));
        return new DERSequence(v);
    }

    private ASN1Integer formatToPositive(ASN1Integer asn1Integer, int length) {
        byte[] bytes = asn1Integer.getValue().toByteArray();
        return BigIntegerKit.fromByteArray(bytes, length);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("SM2Signature [r=");
        builder.append(this.r);
        builder.append(", s=");
        builder.append(this.s);
        builder.append(']');
        return builder.toString();
    }

    public static final boolean isASN1SignType(byte[] signBytes) {
        if (signBytes == null) {
            return false;
        }
        if (signBytes.length >= 58 && signBytes.length <= 80) {
            int offset = 0;
            TLV tlv = new TLV(signBytes, offset);
            if (!tlv.failure && tlv.type == 48 && tlv.vLength >= 56) {
                int maxLength = (offset += tlv.hLength) + tlv.vLength;
                if (signBytes.length != maxLength) {
                    return false;
                }
                int num = 0;
                while (offset < maxLength) {
                    tlv = new TLV(signBytes, offset);
                    if (tlv.failure || tlv.type != 2 || tlv.vLength < 26) {
                        return false;
                    }
                    offset += tlv.hLength;
                    offset += tlv.vLength;
                    if (++num != 2) continue;
                }
                return num == 2 && offset == maxLength;
            }
            return false;
        }
        return false;
    }
}

