/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.websocket;

import com.ygsoft.abc.service.domain.bo.WebSocketSessionWrapper;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.function.Objects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BaseServerEndpoint {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BaseServerEndpoint.class);
    private static final AtomicInteger onlineCount = new AtomicInteger(0);
    public static final String HEART_PING = "ping:";
    public static final String HEART_PONG = "pong:";
    private static final ConcurrentHashMap<String, WebSocketSessionWrapper> sessionMap = new ConcurrentHashMap();
    private static volatile boolean start = false;
    private static final long EXPIRE_TIME = 180000L;
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);

    private static void start() {
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        LocalDateTime now = LocalDateTime.now();
                        ArrayList removeKeys = new ArrayList();
                        sessionMap.forEach((key, value) -> {
                            if (BaseServerEndpoint.isExpired(value.getLastTime(), now)) {
                                removeKeys.add(key);
                            }
                        });
                        if (LOG.isInfoEnabled()) {
                            String msg = String.format("\u79fb\u9664sessionId:%s", removeKeys);
                            LOG.info((Object)msg);
                        }
                        removeKeys.forEach(openId -> sessionMap.remove(openId));
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block3;
                        LOG.warn((Object)"\u8c03\u5ea6\u4efb\u52a1\u79fb\u9664openId\u5bf9\u5e94\u7684websocket\u5931\u8d25\u3002", (Throwable)e);
                    }
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void addOnlineCount() {
        onlineCount.incrementAndGet();
    }

    public void subOnlineCount() {
        onlineCount.decrementAndGet();
    }

    private static boolean isExpired(LocalDateTime lastTime, LocalDateTime now) {
        return lastTime.plusMinutes(180000L).isBefore(now);
    }

    public void put(String sessionId, WebSocketSessionWrapper sessionWrapper) {
        sessionMap.put(sessionId, sessionWrapper);
    }

    public WebSocketSessionWrapper getWebSocketSessionWrapper(String sessionId) {
        return sessionMap.get(sessionId);
    }

    public void remove(String sessionId) {
        block4: {
            WebSocketSessionWrapper sessionWrapper = sessionMap.remove(sessionId);
            if (Objects.isNull((Object)sessionWrapper)) {
                return;
            }
            try {
                if (sessionWrapper.getSession().isOpen()) {
                    sessionWrapper.getSession().close();
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)"\u79fb\u9664\u5e76\u5173\u95edsession\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    public int size() {
        return onlineCount.get();
    }

    public boolean isHeartPing(String message) {
        if (StringUtil.isNullOrTrimEmptyString((String)message)) {
            return false;
        }
        return message.startsWith(HEART_PING);
    }

    public String getMessageFormPing(String message) {
        String msg = message.substring(5);
        return msg;
    }

    public String buildPongMessage(String message) {
        return HEART_PONG + message;
    }

    public void send(String sessionId, String message) {
        block2: {
            try {
                sessionMap.get(sessionId).getSession().getBasicRemote().sendText(message);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"\u3010\u6307\u5b9a\u53d1\u9001\u3011--\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void broadcast(String message) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u3010\u5e7f\u64ad\u53d1\u9001\u3011--\u4fe1\u606f:" + message + "\uff0c\u603b\u8fde\u63a5\u6570:" + this.size()));
        }
        sessionMap.forEach((key, value) -> {
            block2: {
                try {
                    value.getSession().getBasicRemote().sendText(message);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block2;
                    LOG.warn((Object)"\u3010\u5e7f\u64ad\u53d1\u9001\u3011--\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                }
            }
        });
    }

    static {
        if (!start) {
            BaseServerEndpoint.start();
            start = true;
        }
    }
}

