/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.SqlDebugUtil;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.dcispec.PageModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Pageable;

public class PageQueryUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(PageQueryUtil.class);
    private ISQLTemplate sqlTemplate;
    private String sql;
    private String totalSql;
    private Class<?> pojoClass;
    private Pageable pageable;
    private String[] fieldArr;

    private PageQueryUtil(ISQLTemplate sqlTemplate, String sql, Class<?> pojoClass, Pageable pageable) {
        this.sqlTemplate = sqlTemplate;
        this.sql = sql;
        this.pojoClass = pojoClass;
        this.pageable = pageable;
    }

    private PageQueryUtil(ISQLTemplate sqlTemplate, String sql, String totalSql, Class<?> pojoClass, Pageable pageable) {
        this.sqlTemplate = sqlTemplate;
        this.sql = sql;
        this.totalSql = totalSql;
        this.pojoClass = pojoClass;
        this.pageable = pageable;
    }

    private PageQueryUtil(ISQLTemplate sqlTemplate, String sql, String totalSql, Class<?> pojoClass, Pageable pageable, String[] fieldArr) {
        this.sqlTemplate = sqlTemplate;
        this.sql = sql;
        this.totalSql = totalSql;
        this.pojoClass = pojoClass;
        this.pageable = pageable;
        this.fieldArr = fieldArr;
    }

    public static PageQueryUtil getInstance(ISQLTemplate sqlTemplate, String sql, Class<?> pojoClass, Pageable pageable) {
        if (sqlTemplate == null || StringUtil.isNullOrTrimEmptyString((String)sql) || pojoClass == null || pageable == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_getInstance_131", (String)"\u53c2\u6570\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\u6709null\u3002"));
        }
        return new PageQueryUtil(sqlTemplate, sql, pojoClass, pageable);
    }

    public static PageQueryUtil getInstance(ISQLTemplate sqlTemplate, String sql, String totalSql, Class<?> pojoClass, Pageable pageable) {
        if (sqlTemplate == null || StringUtil.isNullOrTrimEmptyString((String)sql) || pojoClass == null || pageable == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_getInstance_152", (String)"\u53c2\u6570\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\u6709null\u3002"));
        }
        return new PageQueryUtil(sqlTemplate, sql, totalSql, pojoClass, pageable);
    }

    public static PageQueryUtil getInstance(ISQLTemplate sqlTemplate, String sql, String totalSql, Class<?> pojoClass, Pageable pageable, String[] fieldArr) {
        if (sqlTemplate == null || StringUtil.isNullOrTrimEmptyString((String)sql) || pojoClass == null || pageable == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_getInstance_174", (String)"\u53c2\u6570\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\u6709null\u3002"));
        }
        if (fieldArr == null || fieldArr.length == 0) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_getInstance_177", (String)"\u53c2\u6570\u9519\u8beffieldArr\u4e3a\u7a7a\u3002"));
        }
        return new PageQueryUtil(sqlTemplate, sql, totalSql, pojoClass, pageable, fieldArr);
    }

    public static PageQueryUtil getInstance(ISQLTemplate sqlTemplate, String sql, Class<?> pojoClass, Pageable pageable, String[] fieldArr) {
        if (sqlTemplate == null || StringUtil.isNullOrTrimEmptyString((String)sql) || pojoClass == null || pageable == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_getInstance_199", (String)"\u53c2\u6570\u9519\u8bef\uff0c\u4f20\u5165\u53c2\u6570\u6709null\u3002"));
        }
        if (fieldArr == null || fieldArr.length == 0) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_getInstance_202", (String)"\u53c2\u6570\u9519\u8beffieldArr\u4e3a\u7a7a\u3002"));
        }
        return new PageQueryUtil(sqlTemplate, sql, null, pojoClass, pageable, fieldArr);
    }

    public <T> PageModel<T> pageQuery(T t) {
        return this.pageQueryBySql(null, t);
    }

    public <T> PageModel<T> pageQuery(Map<String, Object> param, T t) {
        return this.pageQueryBySql(param, t);
    }

    protected <T> PageModel<T> pageQueryBySql(Map<String, Object> param, T t) {
        PageModel pageResult = new PageModel();
        List datas = new ArrayList();
        try {
            int totalRowNum = 0;
            totalRowNum = param == null ? this.getTotalRowNum() : this.getTotalRowNum(param);
            if (totalRowNum > 0) {
                datas = param == null ? this.getTotalRows() : this.getTotalRows(param);
            }
            pageResult.setPage(this.pageable.getPageNumber());
            pageResult.setPageSize(this.pageable.getPageSize());
            pageResult.setTotalCounts((long)totalRowNum);
            pageResult.setContent(datas);
            return pageResult;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            throw new EcpRuntimeException("", (Throwable)e);
        }
    }

    private int getTotalRowNum() {
        String countSql = "";
        countSql = StringUtil.isNotEmptyString((String)this.totalSql) ? this.totalSql : "SELECT COUNT(1) CNT FROM (" + this.sql + ")";
        List list = this.sqlTemplate.findBySQLWithoutRowNumLimit(countSql, Map.class);
        if (BlockCollectionUtil.isEmpty(list)) {
            return 0;
        }
        return CastUtil.getIntegerNull2Zero(((Map)list.get(0)).get("cnt"));
    }

    private int getTotalRowNum(Map<String, Object> param) {
        String countSql = "";
        countSql = StringUtil.isNotEmptyString((String)this.totalSql) ? this.totalSql : "SELECT COUNT(1) CNT FROM (" + this.sql + ") T_T";
        List list = this.sqlTemplate.findBySQLWithoutRowNumLimit(countSql, param, Map.class);
        if (BlockCollectionUtil.isEmpty(list)) {
            return 0;
        }
        return CastUtil.getIntegerNull2Zero(((Map)list.get(0)).get("cnt"));
    }

    private List getTotalRows() {
        String dataSql = null;
        dataSql = this.fieldArr == null ? "SELECT * FROM (" + this.sql + ")" : "SELECT " + PageQueryUtil.buildFieldFragment("OUT$", this.fieldArr) + " FROM ( " + this.sql + " ) OUT$";
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u5206\u9875\u6570\u636eSQL:" + dataSql));
        }
        int pageNo = this.pageable.getPageNumber() + 1;
        return this.sqlTemplate.findBySQL(dataSql, pageNo, this.pageable.getPageSize(), this.pojoClass);
    }

    private List getTotalRows(Map<String, Object> param) {
        String dataSql = null;
        dataSql = this.fieldArr == null ? "SELECT * FROM (" + this.sql + ") T_T" : "SELECT " + PageQueryUtil.buildFieldFragment("T_A", this.fieldArr) + " FROM ( " + this.sql + " ) T_A ";
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>\u5206\u9875\u6570\u636eSQL:" + SqlDebugUtil.sqlWithValue(dataSql, param)));
        }
        int pageNo = this.pageable.getPageNumber() + 1;
        return this.sqlTemplate.findBySQL(dataSql, param, pageNo, this.pageable.getPageSize(), this.pojoClass);
    }

    private static String buildFieldFragment(String tableAlias, String[] fields) {
        if (fields == null || fields.length == 0) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"PageQueryUtil_buildFieldFragment_363", (String)"\u53c2\u6570fields\u4e3a\u7a7a\u3002"));
        }
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < fields.length; ++i) {
            if (StringUtil.isNullOrTrimEmptyString((String)tableAlias)) {
                sb.append(fields[i]);
            } else {
                sb.append(tableAlias + "." + fields[i]);
            }
            if (i == fields.length - 1) continue;
            sb.append(",");
        }
        sb.append(" ");
        return sb.toString();
    }
}

